/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
//
//	SDKINTF.H
//
//
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

#ifndef __SDKINTF__
#define __SDKINTF__

#ifndef __MAINSDK__
#include "sdk.h"
#endif

extern "C" {

typedef void  (APITestAPISdkIntf)       (void);

typedef SDLLObject*(APICreateDLLObjectIntf)(DLLFileRef);
typedef SDLLObject*(APIInstantiateIntf)(unsigned int, unsigned int);
typedef void(APIAddRegisteredTypeIntf)(SDLLRegisterTypeList**,EDLLObjectType,const long);
typedef void(APISendMessageIntf)(SMessage*);
typedef SSurface*(APICreateSurfaceIntf)(int,int);
typedef void(APIFreeSurfaceIntf)(SSurface*);
typedef void(APIEraseSurfaceIntf)(SSurface*);
typedef void(APIEraseSurfaceRGBIntf)(SSurface*, unsigned int);
typedef void(APIBlitIntf)(SSurface*);
typedef void(APIBlitTransparentIntf)(SSurface*,unsigned int);
typedef	void(APIBlitPartialIntf)(SSurface*,int,int,int,int);
typedef void(APIBlitPanelToSurfaceIntf)(SSurface*,SDLLObject*);
typedef int(APILoadFontIntf)(SFont*);
typedef void(APIFreeFontIntf)(SFont*);
typedef void(APIDrawDotIntf)(SSurface*,int,int,unsigned int);
typedef void(APIDrawLineIntf)(SSurface*,int,int,int,int,unsigned int);
typedef void(APIDrawRectIntf)(SSurface*,int,int,int,int,unsigned int);
typedef void(APIFillRectIntf)(SSurface*,int,int,int,int,unsigned int);
typedef void(APIDrawCircleIntf)(SSurface*,int,int,int,unsigned int);
typedef unsigned int(APIMakeRGBIntf)(unsigned int,unsigned int,unsigned int);
typedef void(APIDrawTextIntf)(SSurface*,SFont*,int,int,unsigned int,const char *);
typedef void(APIDrawTextCIntf)(SSurface*,SFont*,int,int,unsigned int,const char *);
typedef void(APIDrawTextRIntf)(SSurface*,SFont*,int,int,unsigned int,const char *);
typedef int(APITextHeightIntf)(SFont*,const char *);
typedef int(APITextWidthIntf)(SFont*,const char *);
typedef int(APICharHeightIntf)(SFont*,char);
typedef int(APICharWidthIntf)(SFont*,char);
typedef int(APIMaxCharHeightIntf)(SFont*);
typedef int(APIMaxCharWidthIntf)(SFont*);
typedef int(APILoadBitmapIntf)(SBitmap*);
typedef void(APIDrawBitmapIntf)(SSurface*,SBitmap*,int,int,int);
typedef void(APIDrawBitmapPartialIntf)(SSurface*,SBitmap*,int,int,int,int,int,int,int);
typedef	void(APIGetBitmapSizeIntf)(SBitmap *bitmap, int *xSize, int *ySize);
typedef int(APINumBitmapFramesIntf)(SBitmap*);
typedef void(APIFreeBitmapIntf)(SBitmap*);
typedef int(APIOpenStreamIntf)(SStream *stream);
typedef void(APICloseStreamIntf)(SStream *stream);
typedef int(APIDoesFileExistIntf)(const char*,EFileSearchLocation);
typedef int(APIDoesPodVolumeExistIntf)(const char *volumeName);
typedef void(APIWriteToIntf)(SDLLObject*,SStream*);
typedef void(APIReadFromIntf)(SDLLObject*,SStream*);
typedef void(APISkipObjectIntf)(SStream*);
typedef void(APIAdvanceToTagIntf)(unsigned int,SStream*);
typedef void(APIReadIntIntf)(int*,SStream*);
typedef void(APIReadUIntIntf)(unsigned int *,SStream*);
typedef void(APIReadFloatIntf)(float*,SStream*);
typedef void(APIReadDoubleIntf)(double*,SStream*);
typedef void(APIReadStringIntf)(char*,int,SStream*);
typedef void(APIReadVectorIntf)(SVector*,SStream*);
typedef void(APIReadPositionIntf)(SPosition*,SStream*);
typedef void(APIReadTimeIntf)(SDateTime*,SStream*);
typedef void(APIReadTimeDeltaIntf)(SDateTimeDelta*,SStream*);
typedef void(APIReadMessageIntf)(SMessage*,SStream*);
typedef void(APIWriteIntIntf)(int*result,SStream*);
typedef void(APIWriteUIntIntf)(unsigned int*,SStream*);
typedef void(APIWriteFloatIntf)(float*,SStream*);
typedef void(APIWriteDoubleIntf)(double*,SStream*);
typedef void(APIWriteStringIntf)(char*,SStream*);
typedef void(APIWriteVectorIntf)(SVector*,SStream*);
typedef void(APIWritePositionIntf)(SPosition*,SStream*);
typedef void(APIWriteTimeIntf)(SDateTime*,SStream*);
typedef void(APIWriteTimeDeltaIntf)(SDateTimeDelta*,SStream*);
typedef void(APIWriteMessageIntf)(SMessage*,SStream*);
typedef int(APIPlaySfxIntf)(char*);
typedef void(APIStopSfxIntf)(int);
typedef int(APIIsValidSfxIntf)(int);
typedef void(APISetSfxVolumeIntf)(int,float);
typedef void(APISetSfxPositionIntf)(int,SPosition*);
typedef void(APISetSfxDirectionIntf)(int,SVector*);
typedef void(APISetSfxVelocityIntf)(int,SVector*);
typedef void(APISetSfxFrequencyIntf)(int,float);
typedef void(APISetMouseCursorIntf)(EMouseCursorStyle);
typedef float(APIGetGaugeLightLevelIntf)(SDLLObject*);
typedef float(APIGetGaugeAmbientLightLevelIntf)(SDLLObject*);
typedef void(APIAddKeyHandlerIntf)(int,int,SDLLObject*);
typedef void(APIRemoveKeyHandlerIntf)(int,int,SDLLObject*);
typedef void(APIDebounceKeyIntf)(int,int);
typedef int(APIHasJoystickAxisIntf)(EJoystickAxis);
typedef float(APIGetJoystickAxisIntf)(EJoystickAxis);
typedef int(APIGetJoystickButtonCountIntf)(void);
typedef int(APIIsJoystickButtonPressedIntf)(int);
typedef void(APIGetLocalNavaidsIntf)(SNavaid**);
typedef void(APIGetLocalILSIntf)(SILS**);
typedef void(APIGetLocalCommsIntf)(SComm**);
typedef void(APIGetLocalCentersIntf)(SComm**);
typedef void(APIGetLocalAirportsIntf)(SAirport**);
typedef void(APIGetLocalWaypointsIntf)(SWaypoint **waypoints);
typedef int(APIGetNearestNavaidIntf)(SPosition*,int,SNavaid*,float*);
typedef int(APIGetNearestNavaidByFreqIntf)(SPosition*,int,float,SNavaid*,float*);
typedef int(APIGetNearestILSIntf)(SPosition*,float,SILS*,float*);
typedef int(APIGetNearestCommIntf)(SPosition*,float,SComm*,float*);
typedef int(APIGetNearestAirportCommIntf)(SPosition*,float,SComm*,float*);
typedef int(APIGetNearestCenterCommIntf)(SPosition*,float,SComm*,float*);
typedef int(APIGetNearestAirportIntf)(SPosition*,SAirport*,float*);
typedef int(APIInAirportRegionIntf)(SPosition*,float*);
typedef int(APIGetAirportIntf)(char*,SAirport*);
typedef int(APISearchNavaidsByIDIntf)(char*,int,SNavaid**);
typedef int(APISearchNavaidsByNameIntf)(char*,int,SNavaid**);
typedef int(APISearchWaypointsByNameIntf)(char*,SWaypoint**);
typedef int(APISearchAirportsByFAAIntf)(char*,SAirport**);
typedef int(APISearchAirportsByICAOIntf)(char*,SAirport**);
typedef int(APISearchAirportsByNameIntf)(char*,SAirport**);
typedef int(APISearchILSIntf)(char*,char*,SILS**);
typedef int(APISearchDatabaseIntf)(char*,char*,char*,SGeneric**);
typedef void(APIFreeNavaidIntf)(SNavaid*);
typedef void(APIFreeWaypointIntf)(SWaypoint*);
typedef void(APIFreeILSIntf)(SILS*);
typedef void(APIFreeCommIntf)(SComm*);
typedef void(APIFreeAirportIntf)(SAirport*);
typedef void(APIFreeGenericIntf)(SGeneric*);
typedef SDLLObject*(APICreateFlyObjectIntf)(char*);//(char*,DLLFileRef);
typedef SDLLObject*(APICreateFlyObjectByTypeIntf)(unsigned int);//(unsigned int,DLLFileRef);
typedef void(APIDestroyObjectIntf)(SDLLObject*);
typedef int(APIGetAircraftIntf)(SFlyObjectList**);
typedef int(APIGetObjectsIntf)(SFlyObjectList**);
typedef void(APIFreeObjectsIntf)(SFlyObjectList*);
typedef int(APIGetUserObjectIntf)(SFlyObjectRef*);
typedef int(APIGetObjectTypeIntf)(SFlyObjectRef*,EFlyObjectType*);
typedef int(APIIsValidObjectIntf)(SFlyObjectRef*);
typedef int(APIGetObjectPositionIntf)(SFlyObjectRef*,SPosition*);
typedef int(APISetObjectPositionIntf)(SFlyObjectRef*,SPosition*);
typedef int(APIGetObjectOrientationIntf)(SFlyObjectRef*,SVector*);
typedef int(APISetObjectOrientationIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectBodyVelocityIntf)(SFlyObjectRef*,SVector*);
typedef int(APISetObjectBodyVelocityIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectInertialVelocityIntf)(SFlyObjectRef*,SVector*);
typedef int(APISetObjectInertialVelocityIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectAngularVelocityIntf)(SFlyObjectRef*,SVector*);
typedef int(APISetObjectAngularVelocityIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectSpeedIntf)(SFlyObjectRef*,float*);
typedef int(APISetObjectSpeedIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectAltitudeRateIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectInertialAccelerationIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectBodyAccelerationIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectAltitudeAccelerationIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectLateralAccelerationIntf)(SFlyObjectRef*,float*);
typedef int(APIGetPartPositionIntf)(SFlyObjectRef*,char*,SVector*);
typedef int(APISetPartPositionIntf)(SFlyObjectRef*,char*,SVector*);
typedef int(APIGetPartOrientationIntf)(SFlyObjectRef*,char*,SVector*);
typedef int(APISetPartOrientationIntf)(SFlyObjectRef*,char*,SVector*);
typedef int(APIGetPartBodyOrientationIntf)(SFlyObjectRef*,char*,SVector*,SVector*);
typedef int(APISetPartBodyOrientationIntf)(SFlyObjectRef*,char*,SVector*,SVector*);
typedef int(APIRotatePartIntf)(SFlyObjectRef*,char*,SVector*);
typedef int(APIShowPartIntf)(SFlyObjectRef*,char*);
typedef int(APIHidePartIntf)(SFlyObjectRef*,char*);
typedef int(APISetPartIntf)(SFlyObjectRef *object, char *partName, float status, float pos);
typedef int(APISetPartFrameIntf)(SFlyObjectRef *object, char *partName, int frameIndex);
typedef int(APIGetObjectNameIntf)(SFlyObjectRef*,char*,int);
typedef int(APISetObjectNameIntf)(SFlyObjectRef*,char*);
typedef int(APIGetTailNumberIntf)(SFlyObjectRef*,char*,int,char*,int);
typedef int(APISetTailNumberIntf)(SFlyObjectRef*,char*,char*);
typedef int(APIGetObjectAGLIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectMSLIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectBodyGravityIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectTotalWeightIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectPressureAltitudeIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectDensityAltitudeIntf)(SFlyObjectRef*,float*);
typedef int(APIGetObjectInertialGroundSpeedIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectBodyGroundSpeedIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetObjectGroundSpeedIntf)(SFlyObjectRef*,float*);
typedef int(APIGetInertialWindVectorIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetBodyWindVectorIntf)(SFlyObjectRef*,SVector*);
typedef int(APIGetWindSpeedIntf)(SFlyObjectRef*,float*);
typedef int(APIGetWindHeadingIntf)(SFlyObjectRef*,float*);
typedef int(APIGetHeadWindIntf)(SFlyObjectRef*,float*);
typedef int(APIGetTailWindIntf)(SFlyObjectRef*,float*);
typedef int(APIGetOutsideAirTemperatureIntf)(SFlyObjectRef*,float*);
typedef int(APIGetOutsideAirPressureIntf)(SFlyObjectRef*,float*);
typedef int(APIGetTotalAirTemperatureIntf)(SFlyObjectRef*,float*);
typedef int(APIGetMachNumberIntf)(SFlyObjectRef*,float*);
typedef int(APIGetModelRadiusIntf)(SFlyObjectRef*,float*);
typedef int(APIIsObjectNearGroundIntf)(SFlyObjectRef*,int*);
typedef int(APIAreWheelsOnGroundIntf)(SFlyObjectRef*,int*);
typedef int(APIIsGearUpIntf)(SFlyObjectRef*,int*);
typedef int(APIIsGearDownIntf)(SFlyObjectRef*,int*);
typedef int(APIAreBrakesOnIntf)(SFlyObjectRef*,int*);
typedef int(APIGetGroundTypeUnderObjectIntf)(SFlyObjectRef*,int*);
typedef int(APITuneRadioIntf)(SFlyObjectRef*,ERadioType,int,float);
typedef int(APIObjectInRegionIntf)(SFlyObjectRef*,SPosition*,SPosition*,int*);
typedef int(APIObjectInAirportIntf)(SFlyObjectRef*,SAirport*,int*);
typedef int(APISimplifyObjectIntf)(SFlyObjectRef*);
typedef int(APILoadModelIntf)(SFlyObjectRef*,const char *,const unsigned int);
typedef int(APILoadNightModelIntf)(SFlyObjectRef*,const char *,const unsigned int);
typedef int(APISelectModelIntf)(SFlyObjectRef*,const unsigned int);
typedef int(APISelectNightModelIntf)(SFlyObjectRef*,const unsigned int);
typedef int(APIRayWorldIntersectionIntf)(SPosition*,SPosition*,SFlyObjectRef*,SCollision*,int);
typedef float(APIGetGroundHeightIntf)(SPosition*);
typedef SVector(APIGetGroundNormalIntf)(SPosition*);
typedef void(APILoadMetarIntf)(char*);
typedef void(APIGetWeatherInfoIntf)(SWeatherInfo*);
typedef void(APISetWeatherInfoIntf)(SWeatherInfo*);
typedef void(APISetFogColorIntf)(int,int,int);
typedef void(APISetUpdateRateIntf)(SDLLObject*,float);
typedef int(APIIsSimulationRunningIntf)(void);
typedef int(APIIsInteriorCameraIntf)(void);
typedef int(APIIsExteriorCameraIntf)(void);
typedef void(APIGetScreenResolutionIntf)(int*,int*);
typedef	void(APIGetMainWindowCoordsIntf)(int*,int*,int*,int*);
typedef SDLLObject*(APICreateWindowIntf)(int,int,int,int,int,int);
typedef void(APIWindowSetAutoSizeIntf)(SDLLObject*,int);
typedef void(APIWindowSetMoveableIntf)(SDLLObject*,int);
typedef void(APIWindowSetResizeableIntf)(SDLLObject*,int);
typedef void(APIWindowSetDrawTitleBarIntf)(SDLLObject*,int);
typedef void(APIWindowSetDrawCloseBoxIntf)(SDLLObject*,int);
typedef void(APIWindowSetDrawSizeBoxIntf)(SDLLObject*,int);
typedef void(APIWindowSetDrawBorderIntf)(SDLLObject*,int);
typedef void(APIWindowSetMinSizeIntf)(SDLLObject*,int,int);
typedef void(APIWindowSetMaxSizeIntf)(SDLLObject*,int,int);
typedef void(APIWindowSetPositionIntf)(SDLLObject*,int,int);
typedef void(APIWindowSetSizeIntf)(SDLLObject*,int,int);
typedef void(APICloseWindowIntf)(SDLLObject*object);
typedef float(APIWrap180Intf)(float);
typedef float(APIWrap360Intf)(float);
typedef float(APIWrapPiIntf)(float);
typedef float(APIWrapTwoPiIntf)(float);
typedef SPosition(APIAddVectorIntf)(SPosition*,SVector*);
typedef SPosition(APISubtractVectorIntf)(SPosition*,SVector*);
typedef SVector(APISubtractPositionIntf)(SPosition*,SPosition*);
typedef void(APISetCameraIntf)(unsigned int camera);
typedef unsigned int(APIGetCameraIntf)(void);
typedef void(APISetPanelIntf)(const int panelID);
typedef void(APISetToRightPanelIntf)(void);
typedef void(APISetToLeftPanelIntf)(void);
typedef void(APISetToUpperPanelIntf)(void);
typedef void(APISetToLowerPanelIntf)(void);
typedef void(APIHomePanelIntf)(void);
typedef void(APIPanCameraIntf)(float,float,int);
typedef void(APIZoomCameraIntf)(float);
typedef void(APIDrawNoticeToUserIntf)(const char *,const int);
typedef void(APISetSystemHardwareTypeIntf)(SDLLObject*,EMessageHWType);
typedef EMessageHWType(APIGetSystemHardwareTypeIntf)(SDLLObject*);
typedef void(APISetSystemIndicationIntf)(SDLLObject*,double);
typedef double(APIGetSystemIndicationIntf)(SDLLObject*);
typedef long(APIGetSystemUnitIDIntf)(SDLLObject*);
typedef int(APIGetSystemUnitNumberIntf)(SDLLObject*);
typedef void(APISetSystemStateIntf)(SDLLObject*,int);
typedef int(APIGetSystemStateIntf)(SDLLObject*);
typedef int(APIIsSystemActiveIntf)(SDLLObject*);
typedef void(APISetSystemLoadIntf)(SDLLObject*,double);
typedef double(APIGetSystemLoadIntf)(SDLLObject*);
typedef void(APISetSystemMaxVoltageIntf)(SDLLObject*,double);
typedef double(APIGetSystemMaxVoltageIntf)(SDLLObject*);
typedef void(APIGetFlightPlanIntf)(SFlightPlan**);
typedef void(APIFreeFlightPlanIntf)(SFlightPlan*);
typedef void(APIGetFPFirstEntryIntf)(SFPEntry*);
typedef void(APIGetFPLastEntryIntf)(SFPEntry*);
typedef void(APIGetFPToWaypointIntf)(SFPEntry*);
typedef void(APIGetFPFromWaypointIntf)(SFPEntry*);
typedef void(APIGetFPBeyondWaypointIntf)(SFPEntry*);
typedef void(APIUpdateFPCurrentWaypointIntf)(SPosition*);
typedef float(APIGreatCircleDistanceIntf)(SPosition*,SPosition*);
typedef SPosition(APIGreatCirclePositionIntf)(SPosition*,SVector*);
typedef SVector(APIGreatCirclePolarIntf)(SPosition*,SPosition*);
typedef SDate(APIGetDateIntf)(void);
typedef void(APISetDateIntf)(SDate);
typedef STime(APIGetTimeIntf)(void);
typedef void(APISetTimeIntf)(STime);
typedef ETimeOfDay(APIGetTimeOfDayIntf)(void);
typedef void(APIAdvanceTimeIntf)(STime*,float);
typedef void*(APIAllocMemIntf)(unsigned int);
typedef void(APIFreeMemIntf)(void*);
typedef void*(APILoadLibraryIntf)(char*);
typedef void*(APIGetLibraryRoutineIntf)(void*,char*);
typedef void(APIFreeLibraryIntf)(void*);
typedef void(APIShowPanelIntf)(void);
typedef void(APIHidePanelIntf)(void);
typedef SMovie*(APIOpenMovieIntf)(const char*);
typedef void(APIDrawMovieIntf)(SMovie *movie,int,int);
typedef void(APIPlayMovieIntf)(SMovie *movie);
typedef void(APIStopMovieIntf)(SMovie *movie);
typedef void(APIIdleMovieIntf)(SMovie *movie);
typedef int(APIMoviePlayingIntf)(SMovie *movie);
typedef void(APICloseMovieIntf)(SMovie *movie);
typedef void(APIPlayMovieInWindowIntf)(const char *,int,int,int);
typedef void(APISetBrokenCloudTexturesIntf)(char textures[3][64]);
typedef void(APISetOvercastCloudTextureIntf)(char texture[64]);
typedef void(APISetCloudPanelTexturesIntf)(char texture[3][64]);
typedef void(APISetLightningTexturesIntf)(char texture[3][64]);
typedef void(APISetRainTexturesIntf)(char texture[3][64]);
typedef void(APISetSnowTextureIntf)(char texture[64]);
typedef void(APISetSkyBackdropIntf)(char texture[64]);
typedef void(APIShowSkyBackdropIntf)(char trueFalse);
typedef void(APISetDomeRGBSaturationIntf)(float redSat, float greenSat, float blueSat);
typedef void(APIGetDomeRGBSaturationIntf)(float *redSat, float *greenSat, float *blueSat);
typedef float(APIGetAmbientLightLevelIntf)(void);
typedef void(APISetAmbientLightMultiplierIntf)(float);
typedef float(APIGetAmbientLightMultiplierIntf)(void);
typedef void(APICreateOverlayIntf)(SDLLObject*,SSurface*,const int,const int,DLLFileRef);
typedef void(APIRemoveOverlayIntf)(SSurface*,DLLFileRef);
typedef float(APIGetDeltaTimeIntf)(void);
typedef int(APIHasCameraIntf)(SFlyObjectRef *ref, unsigned int camera);
typedef void(APIAddCameraIntf)(SFlyObjectRef *ref, unsigned int camera, SStream *stream);
typedef int(APIGetObjectTrueHeadingIntf)(SFlyObjectRef *object, float *trueHeadingDegs);
typedef int(APIGetObjectMagneticHeadingIntf)(SFlyObjectRef *object, float *magHeadingDegs);
typedef int(APIGetObjectMagneticVariationIntf)(SFlyObjectRef *object, float *magVarDeg);
typedef void(APIUseVFRPanelsIntf)(void);
typedef void(APIUseIFRPanelsIntf)(void);
typedef void(APIGetCameraPositionIntf)(SPosition*,SVector*,SVector*);
typedef void(APISetDynamicSceneryIntf)(char trueOrFalse);
typedef void(APISetNumDynamicSceneryIntf)(int numDynamicObjects);
typedef void(APISetShadowsIntf)(int shadowsValue);
typedef void(APISetFiniteFuelIntf)(char trueOrFalse);
typedef void(APISetFiniteBatteryIntf)(char trueOrFalse);
typedef void(APISetPFactorIntf)(char trueOrFalse);
typedef void(APISetPropTorqueIntf)(char trueOrFalse);
typedef void(APISetAutoMixtureIntf)(char trueOrFalse);
typedef void(APISetAutoPropellerIntf)(char trueOrFalse);
typedef void(APISetIcePropellerIntf)(char trueOrFalse);
typedef void(APISetIceEngineIntf)(char trueOrFalse);
typedef void(APISetIceWingIntf)(char trueOrFalse);
typedef void(APISetIcePitotIntf)(char trueOrFalse);
typedef void(APISetGyroDriftIntf)(char trueOrFalse);
typedef void(APISetCoupleRudderAileronsIntf)(char trueOrFalse);
typedef void(APISetCoupleAirBrakeIntf)(char trueOrFalse);
typedef void(APISetCockpitMouseScrollingIntf)(char trueOrFalse);
typedef void(APISetATCServiceNamesIntf)(char trueOrFalse);
typedef void(APISetATCScrollingTextIntf)(char trueOrFalse);
typedef void(APISetObjectCollisionsIntf)(int collisions);
typedef void(APIGetIniVarIntf)(const char *section, const char *varname, int *value);
typedef void(APIGetIniStringIntf)(const char *section, const char *varname, char *strvar, int maxLength);
typedef void(APISetIniVarIntf)(const char *section, const char *varname, int *value);
typedef void(APISetIniStringIntf)(const char *section, const char *varname, char *strvar);
typedef void(APIGetReportedWeatherIntf)(SPosition *pos, SWeatherInfo *info);
typedef unsigned int(APIGetSystemTimerIntf)(void);
typedef int(APIPositionFromNamedObjectIntf)(const char *objectName, SPosition *pos);
typedef int(APIDistanceToNamedObjectIntf)(const char *objectName, SPosition *pos, float *distance);
typedef SPosition(APIMakePositionIntf)(const char *latString, const char *lonString, const float alt);
typedef int(APIPointInRegionIntf)(SPosition *pos, SPositionList *region);
typedef int(APIPointInCircleIntf)(SPosition *pos, SPosition *center, float radiusInFeet);
typedef int(APIPointInAirportIntf)(SPosition *pos, SAirport *airport);
typedef void(APICalculateRunwayRegionsIntf)(SRunway *runway, SPositionList **upwind, SPositionList **crosswind, SPositionList **downwind, SPositionList **base, SPositionList **final);
typedef void(APIDisposePositionListIntf)(SPositionList *region);
typedef void(APIMessageBoxIntf)(const char *msg);
typedef int(APIIsSlewingIntf)(void);
typedef int(APIIsPausedIntf)(void);
typedef void(APISetSlewingIntf)(const int slewFlag);
typedef void(APISetPausedIntf)(const int pauseFlag);
typedef void(APIMimicKeystrokeIntf)(unsigned int keyID);
typedef void(APIPositionCameraIntf)(float,float,float);
typedef void(APIHiliteGaugeIntf)(unsigned int gaugeID, unsigned int hiliteStyle, unsigned int hiliteColor, float timerSecs);
typedef void(APIScrollToGaugeIntf)(unsigned int gaugeID);
typedef void(APICreateWindowByTypeIntf)(int type, int x, int y, int xSize, int ySize);
typedef void(APIMoveWindowByTypeIntf)(int type, int x, int y);
typedef void(APISizeWindowByTypeIntf)(int type, int x, int y);
typedef void(APICloseWindowByTypeIntf)(int type);
typedef int(APIWindowCountIntf)(int type);
typedef void(APICloseAllWindowsIntf)(void);
typedef void(APICreateAirportWindowIntf)(SAirport *airport, int x, int y);
typedef void(APICloseAirportWindowIntf)(SAirport *airport);
typedef void(APICreateNavaidWindowIntf)(SNavaid *navaid, int x, int y);
typedef void(APICloseNavaidWindowIntf)(SNavaid *navaid);
typedef float(APIGetTunedFreqIntf)(SFlyObjectRef *object, ERadioType type, int radioUnit, EFreqType whichFreq);
typedef int(APIGetTunedTypeIntf)(SFlyObjectRef *object, ERadioType type, int radioUnit);
typedef int(APIGetTunedNavaidIntf)(SFlyObjectRef *object, ERadioType type, int radioUnit, SNavaid *navaid);
typedef int(APIGetTunedILSIntf)(SFlyObjectRef *object, ERadioType type, int radioUnit, SILS *localizer, SILS *glideslope, SILS *outer, SILS *middle, SILS *inner, SILS *backcourse);
typedef int(APIGetTunedCommIntf)(SFlyObjectRef *object, ERadioType type, int radioUnit, SComm *comm);
typedef int(APITuneRadio2Intf)(SFlyObjectRef*,ERadioType,int,float,EFreqType);
typedef void(APIStopSfxByUserDataIntf)(int,int);
typedef void(APISetSfxUserDataIntf)(int,int,int);
typedef void(APIVectorMapDrawAirportsIntf)(const int state);
typedef void(APIVectorMapDrawVORIntf)(const int state);
typedef void(APIVectorMapDrawNDBIntf)(const int state);
typedef void(APIVectorMapDrawAirportNameIntf)(const int state);
typedef void(APIVectorMapDrawAirportIDIntf)(const int state);
typedef void(APIVectorMapDrawVORNameIntf)(const int state);
typedef void(APIVectorMapDrawVORIDIntf)(const int state);
typedef void(APIVectorMapDrawVORFrequencyIntf)(const int state);
typedef void(APIVectorMapDrawNDBNameIntf)(const int state);
typedef void(APIVectorMapDrawNDBIDIntf)(const int state);
typedef void(APIVectorMapDrawLabelsIntf)(const int state);
typedef void(APIVectorMapDrawCompassPlateIntf)(const int state);
typedef void(APIVectorMapDrawBackgroundIntf)(const int state);
typedef void(APIVectorMapZoomIntf)(const float zoom);
typedef int(APIPlaySfxDelayIntf)(char *wavfile, float delay, float *length);
typedef SDLLObject*(APICreateScriptObjectIntf)(DLLFileRef dll, DLLObjectRef ref);
typedef void(APIDestroyScriptObjectIntf)(SDLLObject *object);
typedef void(APIGetKeyCodeIntf)(int keyID, int *code, int *mods);
typedef void(APIDefineKeyIntf)(int keyID, char *keyFunction, int keyCode, int modifiers);
typedef int(APIGetNamedObjectIntf)(char *name, SFlyObjectRef *ref);
typedef int(APIIsChecklistRunningIntf)(void);
typedef	void(APIRunChecklistIntf)(const char *checklist);
typedef int(APIGetKeyAssignmentIntf)(int keyID);
typedef void(APIAlertBoxIntf)(unsigned long windowID, char *title, char *message, int buttonStyle, int iconStyle, SDLLObject *notify);
typedef int(APICountPythonMethodModulesIntf)(void);
typedef void(APIGetPythonMethodModuleIntf)(int index, char *moduleName, SPythonMethod **methods);
typedef SFlyObjectRef(APICreateVehicleIntf)(char *infoFile, char *pathFile, SPosition *pos);
typedef void(APIDisposeVehicleIntf)(SFlyObjectRef *object);
typedef int(APISetVehiclePathIntf)(SFlyObjectRef *object, char *pathFile);
typedef void(APIAddKeyHandler2Intf)(int keyID, SDLLObject *object);
typedef void(APIRemoveKeyHandler2Intf)(int keyID, SDLLObject *object);
typedef void(APIDebounceKey2Intf)(int keyID);
typedef void(APICreateWindow2Intf)(unsigned long, char *winFile, SDLLObject *notify);
typedef int(APIIsWindowOpenIntf)(unsigned long windowID);
typedef void(APICloseWindow2Intf)(unsigned long windowID);
typedef	int(APIIsComponentTypeIntf)(unsigned long windowID, unsigned long componentID, unsigned int componentType);
typedef char*(APIGetUIButtonLabelIntf)(unsigned long windowID, unsigned long buttonID);
typedef void(APISetUIButtonLabelIntf)(unsigned long windowID, unsigned long buttonID, char *label);
typedef int(APIGetUICheckboxStateIntf)(unsigned long windowID, unsigned long checkID);
typedef void(APISetUICheckboxStateIntf)(unsigned long windowID, unsigned long checkID, int state);
typedef char*(APIGetUICheckboxLabelIntf)(unsigned long windowID, unsigned long checkID);
typedef void(APISetUICheckboxLabelIntf)(unsigned long windowID, unsigned long checkID, char *label);
typedef int(APIGetUIRadioStateIntf)(unsigned long windowID, unsigned long radioID);
typedef void(APISetUIRadioStateIntf)(unsigned long windowID, unsigned long radioID, int state);
typedef char*(APIGetUIRadioLabelIntf)(unsigned long windowID, unsigned long radioID);
typedef void(APISetUIRadioLabelIntf)(unsigned long windowID, unsigned long radioID, char *label);
typedef void(APIAddUIMenuIntf)(unsigned long windowID, unsigned long menubarID, unsigned long menuID, const char *label);
typedef void(APIAddUIMenuItemIntf)(unsigned long windowID, unsigned long menubarID, unsigned long menuID, unsigned long itemID, const char *label);
typedef void(APIAddUIMenuSeperatorIntf)(unsigned long windowID, unsigned long menubarID, unsigned long menuID);
typedef void(APIRemoveUIMenuItemIntf)(unsigned long windowID, unsigned long menubarID, unsigned long menuID, unsigned long itemID);
typedef void(APIClearUIMenuItemsIntf)(unsigned long windowID, unsigned long menubarID, unsigned long menuID);
typedef void(APICheckUIMenuItemIntf)(unsigned long windowID, unsigned long menubarID, unsigned long menuID, unsigned long itemID, int checked);
typedef void(APIEnableUIMenuItemIntf)(unsigned long windowID, unsigned long menubarID, unsigned long menuID, unsigned long itemID, int enabled);
typedef void(APIAddUIPopupItemIntf)(unsigned long windowID, unsigned long popupID, unsigned long itemID, const char *label);
typedef void(APIAddUIPopupSeperatorIntf)(unsigned long windowID, unsigned long popupID);
typedef void(APIRemoveUIPopupItemIntf)(unsigned long windowID, unsigned long popupID, unsigned long itemID);
typedef void(APIClearUIPopupItemsIntf)(unsigned long windowID, unsigned long popupID);
typedef void(APISelectUIPopupItemIntf)(unsigned long windowID, unsigned long popupID, unsigned long itemID);
typedef unsigned long(APIGetUIPopupItemSelectionIntf)(unsigned long windowID, unsigned long popupID, char *outText);
typedef char*(APIGetUIPopupLabelIntf)(unsigned long windowID, unsigned long popupID);
typedef void(APISetUIPopupLabelIntf)(unsigned long windowID, unsigned long popupID, char *label);
typedef void(APISetUIRadioGroupSelectionIntf)(unsigned long windowID, unsigned long groupID, unsigned long radioID);
typedef unsigned long(APIGetUIRadioGroupSelectionIntf)(unsigned long windowID, unsigned long groupID);
typedef char*(APIGetUILabelTextIntf)(unsigned long windowID, unsigned long buttonID);
typedef void(APISetUILabelTextIntf)(unsigned long windowID, unsigned long buttonID, char *label);
typedef void(APISetUIScrollbarMinIntf)(unsigned long windowID, unsigned long scrollID, float min);
typedef void(APISetUIScrollbarMaxIntf)(unsigned long windowID, unsigned long scrollID, float max);
typedef void(APISetUIScrollbarValueIntf)(unsigned long windowID, unsigned long scrollID, float value);
typedef float(APIGetUIScrollbarMinIntf)(unsigned long windowID, unsigned long scrollID);
typedef float(APIGetUIScrollbarMaxIntf)(unsigned long windowID, unsigned long scrollID);
typedef float(APIGetUIScrollbarValueIntf)(unsigned long windowID, unsigned long scrollID);
typedef void(APISetUIScrollbarPageSizeIntf)(unsigned long windowID, unsigned long scrollID, float pageSize);
typedef float(APIGetUIScrollbarPageSizeIntf)(unsigned long windowID, unsigned long scrollID);
typedef void(APISetUISliderMajorTickSpacingIntf)(unsigned long windowID, unsigned long sliderID, float spacing);
typedef void(APISetUISliderMinorTickSpacingIntf)(unsigned long windowID, unsigned long sliderID, float spacing);
typedef void(APISetUISliderSnapToTicksIntf)(unsigned long windowID, unsigned long sliderID, int snapFlag);
typedef void(APISetUISliderDrawMajorTicksIntf)(unsigned long windowID, unsigned long sliderID, int drawFlag);
typedef void(APISetUISliderDrawMinorTicksIntf)(unsigned long windowID, unsigned long sliderID, int drawFlag);
typedef float(APIGetUISliderMajorTickSpacingIntf)(unsigned long windowID, unsigned long sliderID);
typedef float(APIGetUISliderMinorTickSpacingIntf)(unsigned long windowID, unsigned long sliderID);
typedef int(APIGetUISliderSnapToTicksIntf)(unsigned long windowID, unsigned long sliderID);
typedef int(APIGetUISliderDrawMajorTicksIntf)(unsigned long windowID, unsigned long sliderID);
typedef int(APIGetUISliderDrawMinorTicksIntf)(unsigned long windowID, unsigned long sliderID);
typedef void(APISetUISliderLabelIntf)(unsigned long windowID, unsigned long sliderID, char *label);
typedef void(APISetUIGroupBoxLabelIntf)(unsigned long windowID, unsigned long groupID, char *label);
typedef void(APISetUITextMaxCharsIntf)(unsigned long windowID, unsigned long textID, int maxChars);
typedef int(APIGetUITextMaxCharsIntf)(unsigned long windowID, unsigned long textID);
typedef void(APIUseUITextPasswordIntf)(unsigned long windowID, unsigned long textID, int passwordFlag);
typedef int(APIIsUITextPasswordIntf)(unsigned long windowID, unsigned long textID);
typedef int(APIGetUITextLengthIntf)(unsigned long windowID, unsigned long textID);
typedef void(APISetUITextTextIntf)(unsigned long windowID, unsigned long textID, char *text);
typedef char*(APIGetUITextTextIntf)(unsigned long windowID, unsigned long textID);
typedef void(APISetUITextSelectionIntf)(unsigned long windowID, unsigned long textID, int firstChar, int lastChar);
typedef void(APIGetUITextSelectionIntf)(unsigned long windowID, unsigned long textID, int *firstChar, int *lastChar);
typedef void(APISetUIProgressIndeterminateIntf)(unsigned long windowID, unsigned long progressID, int flag);
typedef int(APIGetUIProgressIndeterminateIntf)(unsigned long windowID, unsigned long progressID);
typedef void(APISetUIProgressMinIntf)(unsigned long windowID, unsigned long progressID, int min);
typedef int(APIGetUIProgressMinIntf)(unsigned long windowID, unsigned long progressID);
typedef void(APISetUIProgressMaxIntf)(unsigned long windowID, unsigned long progressID, int max);
typedef int(APIGetUIProgressMaxIntf)(unsigned long windowID, unsigned long progressID);
typedef void(APISetUIProgressValueIntf)(unsigned long windowID, unsigned long progressID, int value);
typedef int(APIGetUIProgressValueIntf)(unsigned long windowID, unsigned long progressID);
typedef int(APIGetUIListRowCountIntf)(unsigned long windowID, unsigned long listID);
typedef int(APIGetUIListColumnCountIntf)(unsigned long windowID, unsigned long listID);
typedef void(APIAddUIListColumnIntf)(unsigned long windowID, unsigned long listID, int width, char *title);
typedef void(APIDeleteUIListColumnIntf)(unsigned long windowID, unsigned long listID, int column);
typedef void(APIDeleteAllUIListColumnsIntf)(unsigned long windowID, unsigned long listID);
typedef void(APISetUIListColumnWidthIntf)(unsigned long windowID, unsigned long listID, int column, int width);
typedef void(APIAddUIListRowIntf)(unsigned long windowID, unsigned long listID, int height);
typedef void(APIDeleteUIListRowIntf)(unsigned long windowID, unsigned long listID, int row);
typedef void(APIDeleteAllUIListRowsIntf)(unsigned long windowID, unsigned long listID);
typedef int(APICountUIListSelectedRowsIntf)(unsigned long windowID, unsigned long listID);
typedef int(APIGetUIListSelectedRowIntf)(unsigned long windowID, unsigned long listID, int index);
typedef void(APISelectUIListRowIntf)(unsigned long windowID, unsigned long listID, int row);
typedef void(APIClearUIListSelectionIntf)(unsigned long windowID, unsigned long listID);
typedef void(APISetUIListCellTextIntf)(unsigned long windowID, unsigned long listID, int row, int column, char *text);
typedef void(APISetUIListCellIconIntf)(unsigned long windowID, unsigned long listID, int row, int column, char *filename);
typedef void(APIClearUIListCellTextIntf)(unsigned long windowID, unsigned long listID, int row, int column);
typedef void(APIClearUIListCellIconIntf)(unsigned long windowID, unsigned long listID, int row, int column);
typedef void(APIGetUIListCellTextIntf)(unsigned long windowID, unsigned long listID, int row, int column, char *outtext);
typedef void(APIDebugStringIntf)(char *debug);
typedef void(APIAddUIGraphTraceIntf)(unsigned long windowID, unsigned long graphID, unsigned long traceID, int traceType);
typedef void(APIRemoveUIGraphTraceIntf)(unsigned long windowID, unsigned long graphID, unsigned long traceID);
typedef void(APIRemoveAllUIGraphTracesIntf)(unsigned long windowID, unsigned long graphID);
typedef void(APIAddUIGraphTracePointIntf)(unsigned long windowID, unsigned long graphID, unsigned long traceID, float x, float y);
typedef void(APIClearUIGraphTracePointsIntf)(unsigned long windowID, unsigned long graphID, unsigned long traceID);
typedef void(APISetUIGraphTraceRangeIntf)(unsigned long windowID, unsigned long graphID, unsigned long traceID, float minX, float minY, float maxX, float maxY);
typedef void(APISetUIGraphTraceColorIntf)(unsigned long windowID, unsigned long graphID, unsigned long traceID, unsigned int color);
typedef void(APISetUIGraphUseGridIntf)(unsigned long windowID, unsigned long graphID, int useGrid);
typedef void(APISetUIGraphGridRangeIntf)(unsigned long windowID, unsigned long graphID, float minX, float minY, float maxX, float maxY);
typedef void(APISetUIGraphGridSpacingIntf)(unsigned long windowID, unsigned long graphID, float xStep, float yStep);
typedef void(APISetUIGridColorIntf)(unsigned long windowID, unsigned long graphID, unsigned int color);
typedef void(APISetUIGridBackColorIntf)(unsigned long windowID, unsigned long graphID, unsigned int color);
typedef void(APIGetUIGraphGridRangeIntf)(unsigned long windowID, unsigned long graphID, float *minX, float *minY, float *maxX, float *maxY);
typedef void(APIGetUIGraphGridSpacingIntf)(unsigned long windowID, unsigned long graphID, float *xStep, float *yStep);
typedef void(APISetUIPictureImageIntf)(unsigned long windowID, unsigned long pictureID, char *pbmFile);
typedef void(APIOpenFileDialogIntf)(unsigned long windowID, char *title, char *extension, char *defaultName, char *defaultFolder, int createFolder, int allowLocalFiles, int allowPodFiles, int fileMustExist, SDLLObject *notify);
typedef void(APISaveFileDialogIntf)(unsigned long windowID, char *title, char *extension, char *defaultName, char *defaultFolder, int createFolder, int allowLocalFiles, int allowPodFiles, int fileMustExist, SDLLObject *notify);
typedef void(APIOKCancelBoxIntf)(unsigned long windowID, char *message, char *okButton, char *cancelButton, SDLLObject *notify);
typedef void(APIScrollUIListToRowIntf)(unsigned long windowID, unsigned long listID, int row);
typedef void(APIScrollUIListToColumnIntf)(unsigned long windowID, unsigned long listID, int column);
typedef int(APIUserNeedsRepairIntf)(void);
typedef void(APIRepairUserIntf)(void);
typedef float(APIReportAllDamageIntf)(void);
typedef float(APIReportRotorDamageIntf)(void);
typedef float(APIReportPropellerDamageIntf)(void);
typedef float(APIReportEngineDamageIntf)(void);
typedef float(APIReportWingDamageIntf)(void);
typedef float(APIReportWheelDamageIntf)(void);
typedef int(APIGetEngineStateIntf)(SFlyObjectRef *object, int engineNum);
typedef int(APIAllEnginesRunningIntf)(SFlyObjectRef *object);
typedef void(APITurnOffAllAutopilotsIntf)(SFlyObjectRef *object);
typedef void(APILockoutUserControlIntf)(SFlyObjectRef *object);
typedef int(APIVisibleMoistureIntf)(int *level);
typedef void(APITextToSpeechIntf)(const char *text);
typedef int(APITextToSpeechAvailableIntf)(void);
typedef int(APIEpicAvailableIntf)(void);
typedef void(APIEpicReadIntf)(unsigned char *buffer, int address, int numBytes);
typedef void(APIEpicWriteIntf)(unsigned char *buffer, int address, int numBytes);
typedef int(APIEpicSendEventIntf)(SEpicEvent *event);
typedef int(APIEpicSendPHIntf)(int phNum, int data0, int data1, int data2, int data3);
typedef int(APIEpicSendQPIntf)(int qpNum);
typedef int(APIOpenDataBlockIntf)(const char* blockName, const char* filename); // adds to list
typedef void(APICloseDataBlockIntf)(const char* blockName); // removes from list
typedef int(APIDataBlockSizeIntf)(const char *blockName);
typedef int(APIReadDataBlockIntf)(const char* blockName, SDataBlockItem *array);
typedef int(APIWriteDataBlockIntf)(const char* blockName, SDataBlockItem *array);
typedef int(APIReadDataItemIntf)(const char *blockName, unsigned int label, SDataBlockItem *item);
typedef int(APIReadDataItemIntIntf)(const char *blockName, unsigned int label);
typedef float(APIReadDataItemFloatIntf)(const char *blockName, unsigned int label);
typedef int(APIWriteDataItemIntf)(const char *blockName, SDataBlockItem *item);
typedef int(APIWriteDataItemIntIntf)(const char *blockName, unsigned int label, int data);
typedef int(APIWriteDataItemFloatIntf)(const char *blockName, unsigned int label, float data);
typedef void(APIShowWindowIntf)(unsigned long windowID);
typedef void(APIHideWindowIntf)(unsigned long windowID);
typedef int(APIGetGroundTypeIntf)(SPosition *pos);
typedef int(APIDoesSceneryExistIntf)(SPosition *ll, SPosition *ur);
typedef void(APIAddGeneratedSceneryIntf)(SPosition *pos, SVector *orient, char *daySmfFile, char *nightSmfFile, int autoHide);
typedef void(APIGetFlyVersionIntf)(int *majorRevision, int *minorRevision, int *buildNumber);
typedef void(APIGetScreenDirectIntf)(unsigned char **rowTable[], int *xSize, int *ySize, int *bpp, int *redScale, int *redShift,int *greenScale, int *greenShift, int *blueScale, int *blueShift, int *byteOrder);
typedef void(APIGainFocusIntf)(unsigned long windowID, unsigned long componentID);
typedef void(APILoseFocusIntf)(unsigned long windowID, unsigned long componentID);
typedef void(APIGetLightScalarsIntf)(float *dawn, float *day, float *dusk, float *night);
typedef void(APISetLightScalarsIntf)(float dawn, float day, float dusk, float night);
typedef void(APIGetWindsAloftIntf)(SWindsAloft aloft[WEATHER_WINDS_ALOFT_MAX]);
typedef void(APISetWindsAloftIntf)(SWindsAloft aloft[WEATHER_WINDS_ALOFT_MAX]);
typedef void(APIGetFilePathIntf)(unsigned long windowID, char *pathBuffer, int bufferLen);
typedef int(APIGestaltIntf)(SFlyObjectRef *object, int gestaltFlag);
typedef void(APIGestaltSetIntf)(SFlyObjectRef *object, int gestaltFlag);
typedef void(APIGestaltClearIntf)(SFlyObjectRef *object, int gestaltFlag);
typedef void(APILoadSkyModelsIntf)(const char *skyIniFilename);
typedef void(APISelectSkyModelIntf)(const char *skyEntryName);
typedef int(APIRandomlySwapSkiesIntf)(int flag);
typedef int(APIGetFileLengthIntf)(const char *dir, const char *file);
typedef int(APIOpenFileIntf)(const char *dir, const char *file, SFile *fp);
typedef void(APICloseFileIntf)(SFile *fp);
typedef int(APIReadFromFileIntf)(SFile *fp, unsigned int numBytes, void *buffer);

#ifdef WIN
#pragma pack(1)
#endif

#ifdef MAC
#pragma options align = packed
#endif

typedef struct APIFunctionRegistry
{
	APITestAPISdkIntf           *APITestAPISdk;

	APICreateDLLObjectIntf	*APICreateDLLObject;
	APIInstantiateIntf	*APIInstantiate;
	APICreateFlyObjectIntf	*APICreateFlyObject;
	APICreateFlyObjectByTypeIntf	*APICreateFlyObjectByType;
	APIDestroyObjectIntf	*APIDestroyObject;
	APIAddRegisteredTypeIntf	*APIAddRegisteredType;
	APISendMessageIntf	*APISendMessage;
	APICreateSurfaceIntf	*APICreateSurface;
	APIFreeSurfaceIntf	*APIFreeSurface;
  APIEraseSurfaceIntf *APIEraseSurface;
  APIEraseSurfaceRGBIntf *APIEraseSurfaceRGB;
	APIBlitIntf		*APIBlit;
	APIBlitPartialIntf	*APIBlitPartial;
	APIBlitTransparentIntf	*APIBlitTransparent;
	APIBlitPanelToSurfaceIntf	*APIBlitPanelToSurface;
	APILoadFontIntf		*APILoadFont;
	APIDrawTextIntf		*APIDrawText;
	APIDrawTextCIntf	*APIDrawTextC;
	APIDrawTextRIntf	*APIDrawTextR;
	APITextHeightIntf	*APITextHeight;
	APITextWidthIntf	*APITextWidth;
	APICharHeightIntf	*APICharHeight;
	APICharWidthIntf	*APICharWidth;
	APIMaxCharHeightIntf	*APIMaxCharHeight;
	APIMaxCharWidthIntf	*APIMaxCharWidth;
	APILoadBitmapIntf	*APILoadBitmap;
	APIDrawBitmapIntf	*APIDrawBitmap;
	APIDrawBitmapPartialIntf	*APIDrawBitmapPartial;
	APIGetBitmapSizeIntf	*APIGetBitmapSize;
	APINumBitmapFramesIntf	*APINumBitmapFrames;
	APIFreeBitmapIntf	*APIFreeBitmap;
	APIOpenStreamIntf	*APIOpenStream;
	APICloseStreamIntf	*APICloseStream;
	APIDoesFileExistIntf	*APIDoesFileExist;
	APIDoesPodVolumeExistIntf	*APIDoesPodVolumeExist;
	APIWriteToIntf		*APIWriteTo;
	APIReadFromIntf		*APIReadFrom;
	APISkipObjectIntf	*APISkipObject;
	APIAdvanceToTagIntf	*APIAdvanceToTag;
	APIReadIntIntf		*APIReadInt;
	APIReadUIntIntf		*APIReadUInt;
	APIReadFloatIntf	*APIReadFloat;
	APIReadDoubleIntf	*APIReadDouble;
	APIReadStringIntf	*APIReadString;
	APIReadVectorIntf	*APIReadVector;
	APIReadPositionIntf	*APIReadPosition;
	APIReadTimeIntf		*APIReadTime;
	APIReadTimeDeltaIntf	*APIReadTimeDelta;
	APIReadMessageIntf	*APIReadMessage;
	APIWriteIntIntf		*APIWriteInt;
	APIWriteUIntIntf	*APIWriteUInt;
	APIWriteFloatIntf	*APIWriteFloat;
	APIWriteDoubleIntf	*APIWriteDouble;
	APIWriteStringIntf	*APIWriteString;
	APIWriteVectorIntf	*APIWriteVector;
	APIWritePositionIntf	*APIWritePosition;
	APIWriteTimeIntf	*APIWriteTime;
	APIWriteTimeDeltaIntf	*APIWriteTimeDelta;
	APIWriteMessageIntf	*APIWriteMessage;
	APIPlaySfxIntf		*APIPlaySfx;
	APIStopSfxIntf		*APIStopSfx;
	APIIsValidSfxIntf	*APIIsValidSfx;
	APISetSfxVolumeIntf	*APISetSfxVolume;	
	APISetSfxPositionIntf	*APISetSfxPosition;
	APISetSfxDirectionIntf	*APISetSfxDirection;
	APISetSfxVelocityIntf	*APISetSfxVelocity;
	APISetSfxFrequencyIntf	*APISetSfxFrequency;
	APISetMouseCursorIntf	*APISetMouseCursor;
	APIGetGaugeLightLevelIntf	*APIGetGaugeLightLevel;
	APIGetGaugeAmbientLightLevelIntf	*APIGetGaugeAmbientLightLevel;
	APIAddKeyHandlerIntf	*APIAddKeyHandler;
	APIRemoveKeyHandlerIntf	*APIRemoveKeyHandler;
	APIDebounceKeyIntf	*APIDebounceKey;
	APIHasJoystickAxisIntf		*APIHasJoystickAxis;
	APIGetJoystickAxisIntf		*APIGetJoystickAxis;
	APIGetJoystickButtonCountIntf	*APIGetJoystickButtonCount;
	APIIsJoystickButtonPressedIntf	*APIIsJoystickButtonPressed;
	APIGetLocalNavaidsIntf		*APIGetLocalNavaids;
	APIGetLocalILSIntf		*APIGetLocalILS;	
	APIGetLocalCommsIntf		*APIGetLocalComms;	
	APIGetLocalCentersIntf		*APIGetLocalCenters;	
	APIGetLocalAirportsIntf		*APIGetLocalAirports;
	APIGetLocalWaypointsIntf	*APIGetLocalWaypoints;	
	APIGetNearestNavaidIntf		*APIGetNearestNavaid;	
	APIGetNearestNavaidByFreqIntf	*APIGetNearestNavaidByFreq;
	APIGetNearestILSIntf		*APIGetNearestILS;	
	APIGetNearestCommIntf		*APIGetNearestComm;	
	APIGetNearestAirportCommIntf	*APIGetNearestAirportComm;
	APIGetNearestCenterCommIntf	*APIGetNearestCenterComm;	
	APIGetNearestAirportIntf	*APIGetNearestAirport;	
	APIInAirportRegionIntf		*APIInAirportRegion;	
	APIGetAirportIntf		*APIGetAirport;	
	APISearchNavaidsByIDIntf	*APISearchNavaidsByID;
	APISearchNavaidsByNameIntf	*APISearchNavaidsByName;
	APISearchWaypointsByNameIntf	*APISearchWaypointsByName;
	APISearchAirportsByFAAIntf	*APISearchAirportsByFAA;
	APISearchAirportsByICAOIntf	*APISearchAirportsByICAO;
	APISearchAirportsByNameIntf	*APISearchAirportsByName;
	APISearchILSIntf		*APISearchILS;
	APISearchDatabaseIntf		*APISearchDatabase;
	APIFreeNavaidIntf		*APIFreeNavaid;	
	APIFreeWaypointIntf		*APIFreeWaypoint;	
	APIFreeILSIntf			*APIFreeILS;		
	APIFreeCommIntf			*APIFreeComm;		
	APIFreeAirportIntf		*APIFreeAirport;
	APIFreeGenericIntf		*APIFreeGeneric;
	APIGetFlightPlanIntf		*APIGetFlightPlan;
	APIFreeFlightPlanIntf		*APIFreeFlightPlan;
	APIGetFPFirstEntryIntf		*APIGetFPFirstEntry;
	APIGetFPLastEntryIntf		*APIGetFPLastEntry;
	APIGetFPToWaypointIntf		*APIGetFPToWaypoint;
	APIGetFPFromWaypointIntf	*APIGetFPFromWaypoint;
	APIGetFPBeyondWaypointIntf	*APIGetFPBeyondWaypoint;
	APIUpdateFPCurrentWaypointIntf	*APIUpdateFPCurrentWaypoint;
	APIGetAircraftIntf		*APIGetAircraft;
	APIGetObjectsIntf		*APIGetObjects;
	APIFreeObjectsIntf		*APIFreeObjects;
	APIGetUserObjectIntf		*APIGetUserObject;
	APIGetObjectTypeIntf		*APIGetObjectType;
	APIIsValidObjectIntf		*APIIsValidObject;
	APIGetObjectPositionIntf	*APIGetObjectPosition;
	APISetObjectPositionIntf	*APISetObjectPosition;
	APIGetObjectOrientationIntf	*APIGetObjectOrientation;
	APISetObjectOrientationIntf	*APISetObjectOrientation;
	APIGetObjectBodyVelocityIntf	*APIGetObjectBodyVelocity;
	APISetObjectBodyVelocityIntf	*APISetObjectBodyVelocity;
	APIGetObjectInertialVelocityIntf	*APIGetObjectInertialVelocity;
	APISetObjectInertialVelocityIntf	*APISetObjectInertialVelocity;
	APIGetObjectAngularVelocityIntf		*APIGetObjectAngularVelocity;
	APISetObjectAngularVelocityIntf		*APISetObjectAngularVelocity;
	APIGetObjectSpeedIntf		*APIGetObjectSpeed;
	APISetObjectSpeedIntf		*APISetObjectSpeed;
	APIGetObjectAltitudeRateIntf	*APIGetObjectAltitudeRate;
	APIGetObjectInertialAccelerationIntf	*APIGetObjectInertialAcceleration;
	APIGetObjectBodyAccelerationIntf	*APIGetObjectBodyAcceleration;
	APIGetObjectAltitudeAccelerationIntf	*APIGetObjectAltitudeAcceleration;	
	APIGetObjectLateralAccelerationIntf	*APIGetObjectLateralAcceleration;
	APIGetPartPositionIntf		*APIGetPartPosition;
	APISetPartPositionIntf		*APISetPartPosition;
	APIGetPartOrientationIntf	*APIGetPartOrientation;
	APISetPartOrientationIntf	*APISetPartOrientation;
	APIGetPartBodyOrientationIntf	*APIGetPartBodyOrientation;
	APISetPartBodyOrientationIntf	*APISetPartBodyOrientation;
	APIRotatePartIntf		*APIRotatePart;
	APIShowPartIntf			*APIShowPart;
	APIHidePartIntf			*APIHidePart;
	APIGetObjectNameIntf		*APIGetObjectName;
	APISetObjectNameIntf		*APISetObjectName;
	APIGetTailNumberIntf		*APIGetTailNumber;
	APISetTailNumberIntf		*APISetTailNumber;
	APIGetObjectAGLIntf		*APIGetObjectAGL;
	APIGetObjectMSLIntf		*APIGetObjectMSL;
	APIGetObjectBodyGravityIntf	*APIGetObjectBodyGravity;
	APIGetObjectTotalWeightIntf	*APIGetObjectTotalWeight;
	APIGetObjectPressureAltitudeIntf	*APIGetObjectPressureAltitude;
	APIGetObjectDensityAltitudeIntf		*APIGetObjectDensityAltitude;
	APIGetObjectInertialGroundSpeedIntf	*APIGetObjectInertialGroundSpeed;
	APIGetObjectBodyGroundSpeedIntf		*APIGetObjectBodyGroundSpeed;
	APIGetObjectGroundSpeedIntf	*APIGetObjectGroundSpeed;
	APIGetInertialWindVectorIntf	*APIGetInertialWindVector;
	APIGetBodyWindVectorIntf	*APIGetBodyWindVector;
	APIGetWindSpeedIntf		*APIGetWindSpeed;
	APIGetWindHeadingIntf		*APIGetWindHeading;
	APIGetHeadWindIntf		*APIGetHeadWind;
	APIGetTailWindIntf		*APIGetTailWind;
	APIGetOutsideAirTemperatureIntf		*APIGetOutsideAirTemperature;
	APIGetOutsideAirPressureIntf		*APIGetOutsideAirPressure;
	APIGetTotalAirTemperatureIntf		*APIGetTotalAirTemperature;
	APIGetMachNumberIntf		*APIGetMachNumber;
	APIGetModelRadiusIntf		*APIGetModelRadius;
	APIIsObjectNearGroundIntf	*APIIsObjectNearGround;
	APIAreWheelsOnGroundIntf	*APIAreWheelsOnGround;
	APIIsGearUpIntf			*APIIsGearUp;
	APIIsGearDownIntf		*APIIsGearDown;
	APIAreBrakesOnIntf		*APIAreBrakesOn;
	APIGetGroundTypeUnderObjectIntf		*APIGetGroundTypeUnderObject;
	APITuneRadioIntf		*APITuneRadio;
	APIObjectInRegionIntf		*APIObjectInRegion;
	APIObjectInAirportIntf		*APIObjectInAirport;
	APISimplifyObjectIntf		*APISimplifyObject;
	APILoadModelIntf		*APILoadModel;
	APILoadNightModelIntf		*APILoadNightModel;
	APISelectModelIntf		*APISelectModel;
	APISelectNightModelIntf		*APISelectNightModel;
	APIRayWorldIntersectionIntf	*APIRayWorldIntersection;
	APIGetGroundHeightIntf		*APIGetGroundHeight;
	APIGetGroundNormalIntf		*APIGetGroundNormal;
	APILoadMetarIntf	*APILoadMetar;
	APIGetWeatherInfoIntf	*APIGetWeatherInfo;
	APISetWeatherInfoIntf	*APISetWeatherInfo;
	APISetFogColorIntf	*APISetFogColor;
	APIIsSimulationRunningIntf	*APIIsSimulationRunning;
	APIIsInteriorCameraIntf		*APIIsInteriorCamera;
	APIIsExteriorCameraIntf		*APIIsExteriorCamera;
	APIGetScreenResolutionIntf	*APIGetScreenResolution;
	APIGetMainWindowCoordsIntf	*APIGetMainWindowCoords;
	APICreateWindowIntf		*APICreateWindow;
	APIWindowSetAutoSizeIntf	*APIWindowSetAutoSize;
	APIWindowSetMoveableIntf	*APIWindowSetMoveable;
	APIWindowSetResizeableIntf	*APIWindowSetResizeable;
	APIWindowSetDrawTitleBarIntf	*APIWindowSetDrawTitleBar;
	APIWindowSetDrawCloseBoxIntf	*APIWindowSetDrawCloseBox;
	APIWindowSetDrawSizeBoxIntf	*APIWindowSetDrawSizeBox;
	APIWindowSetDrawBorderIntf	*APIWindowSetDrawBorder;
	APIWindowSetMinSizeIntf		*APIWindowSetMinSize;
	APIWindowSetMaxSizeIntf		*APIWindowSetMaxSize;
	APIWindowSetPositionIntf	*APIWindowSetPosition;
	APIWindowSetSizeIntf		*APIWindowSetSize;
	APICloseWindowIntf		*APICloseWindow;
	APIWrap180Intf			*APIWrap180;
	APIWrap360Intf			*APIWrap360;
	APIWrapPiIntf			*APIWrapPi;
	APIWrapTwoPiIntf		*APIWrapTwoPi;
	APIAddVectorIntf		*APIAddVector;
	APISubtractVectorIntf		*APISubtractVector;
	APISubtractPositionIntf		*APISubtractPosition;
	APIGreatCircleDistanceIntf	*APIGreatCircleDistance;
	APIGreatCirclePositionIntf	*APIGreatCirclePosition;
	APIGreatCirclePolarIntf		*APIGreatCirclePolar;
	APISetCameraIntf		*APISetCamera;
	APIGetCameraIntf		*APIGetCamera;
	APISetPanelIntf			*APISetPanel;
	APISetToRightPanelIntf		*APISetToRightPanel;
	APISetToLeftPanelIntf		*APISetToLeftPanel;
	APISetToUpperPanelIntf		*APISetToUpperPanel;
	APISetToLowerPanelIntf		*APISetToLowerPanel;
	APIHomePanelIntf		*APIHomePanel;
	APIShowPanelIntf		*APIShowPanel;
	APIHidePanelIntf		*APIHidePanel;
	APIPanCameraIntf		*APIPanCamera;
	APIZoomCameraIntf		*APIZoomCamera;
	APIDrawNoticeToUserIntf		*APIDrawNoticeToUser;
	APISetSystemHardwareTypeIntf	*APISetSystemHardwareType;
	APIGetSystemHardwareTypeIntf	*APIGetSystemHardwareType;
	APISetSystemIndicationIntf	*APISetSystemIndication;
	APIGetSystemIndicationIntf	*APIGetSystemIndication;
	APIGetSystemUnitIDIntf		*APIGetSystemUnitID;
	APIGetSystemUnitNumberIntf	*APIGetSystemUnitNumber;
	APISetSystemStateIntf		*APISetSystemState;
	APIGetSystemStateIntf		*APIGetSystemState;
	APIIsSystemActiveIntf		*APIIsSystemActive;
	APISetSystemLoadIntf		*APISetSystemLoad;
	APIGetSystemLoadIntf		*APIGetSystemLoad;
	APISetSystemMaxVoltageIntf	*APISetSystemMaxVoltage;
	APIGetSystemMaxVoltageIntf	*APIGetSystemMaxVoltage;
	APIGetDateIntf			*APIGetDate;
	APISetDateIntf			*APISetDate;
	APIGetTimeIntf			*APIGetTime;
	APISetTimeIntf			*APISetTime;
	APIGetTimeOfDayIntf		*APIGetTimeOfDay;
	APIAdvanceTimeIntf		*APIAdvanceTime;
	APIAllocMemIntf			*APIAllocMem;
	APIFreeMemIntf			*APIFreeMem;
	APILoadLibraryIntf		*APILoadLibrary;
	APIGetLibraryRoutineIntf	*APIGetLibraryRoutine;
	APIFreeLibraryIntf		*APIFreeLibrary;
	APIOpenMovieIntf		*APIOpenMovie;
	APIDrawMovieIntf		*APIDrawMovie;
	APIPlayMovieIntf		*APIPlayMovie;
	APIStopMovieIntf		*APIStopMovie;
	APIMoviePlayingIntf		*APIMoviePlaying;
	APICloseMovieIntf		*APICloseMovie;
	APIIdleMovieIntf		*APIIdleMovie;
	APIPlayMovieInWindowIntf	*APIPlayMovieInWindow;
	APISetBrokenCloudTexturesIntf	*APISetBrokenCloudTextures;
	APISetOvercastCloudTextureIntf	*APISetOvercastCloudTexture;
	APISetCloudPanelTexturesIntf	*APISetCloudPanelTextures;
	APISetLightningTexturesIntf	*APISetLightningTextures;
	APISetRainTexturesIntf		*APISetRainTextures;
	APISetSnowTextureIntf		*APISetSnowTexture;
	APISetSkyBackdropIntf		*APISetSkyBackdrop;
	APIShowSkyBackdropIntf		*APIShowSkyBackdrop;
	APISetDomeRGBSaturationIntf	*APISetDomeRGBSaturation;
	APIGetDomeRGBSaturationIntf	*APIGetDomeRGBSaturation;
	APIGetAmbientLightLevelIntf	*APIGetAmbientLightLevel;
	APISetAmbientLightMultiplierIntf	*APISetAmbientLightMultiplier;
	APIGetAmbientLightMultiplierIntf	*APIGetAmbientLightMultiplier;
	APICreateOverlayIntf		*APICreateOverlay;
	APIRemoveOverlayIntf		*APIRemoveOverlay;
	APIGetDeltaTimeIntf		*APIGetDeltaTime;
	APIHasCameraIntf		*APIHasCamera;
	APIAddCameraIntf		*APIAddCamera;
	APIGetObjectTrueHeadingIntf	*APIGetObjectTrueHeading;
	APIGetObjectMagneticHeadingIntf	*APIGetObjectMagneticHeading;
	APIGetObjectMagneticVariationIntf	*APIGetObjectMagneticVariation;
	APIUseVFRPanelsIntf		*APIUseVFRPanels;
	APIUseIFRPanelsIntf		*APIUseIFRPanels;
	APIGetCameraPositionIntf	*APIGetCameraPosition;
	APISetDynamicSceneryIntf	*APISetDynamicScenery;
	APISetNumDynamicSceneryIntf	*APISetNumDynamicScenery;
	APISetShadowsIntf		*APISetShadows;
	APISetFiniteFuelIntf		*APISetFiniteFuel;
	APISetFiniteBatteryIntf		*APISetFiniteBattery;
	APISetPFactorIntf		*APISetPFactor;
	APISetPropTorqueIntf		*APISetPropTorque;
	APISetAutoMixtureIntf		*APISetAutoMixture;
	APISetAutoPropellerIntf		*APISetAutoPropeller;
	APISetIcePropellerIntf		*APISetIcePropeller;
	APISetIceEngineIntf		*APISetIceEngine;
	APISetIceWingIntf		*APISetIceWing;
	APISetIcePitotIntf		*APISetIcePitot;
	APISetGyroDriftIntf		*APISetGyroDrift;
	APISetCoupleRudderAileronsIntf	*APISetCoupleRudderAilerons;
	APISetCoupleAirBrakeIntf	*APISetCoupleAirBrake;
	APISetCockpitMouseScrollingIntf	*APISetCockpitMouseScrolling;
	APISetATCServiceNamesIntf	*APISetATCServiceNames;
	APISetATCScrollingTextIntf	*APISetATCScrollingText;
	APISetObjectCollisionsIntf	*APISetObjectCollisions;
	APIGetIniVarIntf		*APIGetIniVar;
	APIGetIniStringIntf		*APIGetIniString;
	APISetIniVarIntf		*APISetIniVar;
	APISetIniStringIntf		*APISetIniString;
	APIGetReportedWeatherIntf	*APIGetReportedWeather;
	APIGetSystemTimerIntf		*APIGetSystemTimer;
	APIPositionFromNamedObjectIntf	*APIPositionFromNamedObject;
	APIMakePositionIntf		*APIMakePosition;
	APIPointInRegionIntf		*APIPointInRegion;
	APIPointInCircleIntf		*APIPointInCircle;
	APIPointInAirportIntf		*APIPointInAirport;
	APICalculateRunwayRegionsIntf	*APICalculateRunwayRegions;
	APIDisposePositionListIntf	*APIDisposePositionList;
	APIMessageBoxIntf		*APIMessageBox;
	APIIsSlewingIntf		*APIIsSlewing;
	APIIsPausedIntf			*APIIsPaused;
	APISetSlewingIntf		*APISetSlewing;
	APISetPausedIntf		*APISetPaused;
	APIMimicKeystrokeIntf		*APIMimicKeystroke;
	APIPositionCameraIntf		*APIPositionCamera;
	APIHiliteGaugeIntf		*APIHiliteGauge;
	APIScrollToGaugeIntf		*APIScrollToGauge;
	APICreateWindowByTypeIntf	*APICreateWindowByType;
	APIMoveWindowByTypeIntf		*APIMoveWindowByType;
	APISizeWindowByTypeIntf		*APISizeWindowByType;
	APICloseWindowByTypeIntf	*APICloseWindowByType;
	APIWindowCountIntf		*APIWindowCount;
	APICloseAllWindowsIntf		*APICloseAllWindows;
	APICreateAirportWindowIntf	*APICreateAirportWindow;
	APICloseAirportWindowIntf	*APICloseAirportWindow;
	APICreateNavaidWindowIntf	*APICreateNavaidWindow;
	APICloseNavaidWindowIntf	*APICloseNavaidWindow;
	APIGetTunedFreqIntf		*APIGetTunedFreq;
	APITuneRadio2Intf		*APITuneRadio2;
	APIStopSfxByUserDataIntf	*APIStopSfxByUserData;
	APISetSfxUserDataIntf		*APISetSfxUserData;
	APIVectorMapDrawAirportsIntf	*APIVectorMapDrawAirports;
	APIVectorMapDrawVORIntf		*APIVectorMapDrawVOR;	
	APIVectorMapDrawNDBIntf		*APIVectorMapDrawNDB;	
	APIVectorMapDrawAirportNameIntf	*APIVectorMapDrawAirportName;
	APIVectorMapDrawAirportIDIntf	*APIVectorMapDrawAirportID;
	APIVectorMapDrawVORNameIntf		*APIVectorMapDrawVORName;	
	APIVectorMapDrawVORIDIntf		*APIVectorMapDrawVORID;	
	APIVectorMapDrawVORFrequencyIntf	*APIVectorMapDrawVORFrequency;
	APIVectorMapDrawNDBNameIntf		*APIVectorMapDrawNDBName;
	APIVectorMapDrawNDBIDIntf		*APIVectorMapDrawNDBID;	
	APIVectorMapDrawLabelsIntf		*APIVectorMapDrawLabels;
	APIVectorMapDrawCompassPlateIntf	*APIVectorMapDrawCompassPlate;
	APIVectorMapDrawBackgroundIntf	*APIVectorMapDrawBackground;
	APIVectorMapZoomIntf		*APIVectorMapZoom;
	APIPlaySfxDelayIntf		*APIPlaySfxDelay;
	APICreateScriptObjectIntf	*APICreateScriptObject;
	APIDestroyScriptObjectIntf		*APIDestroyScriptObject;
	APIGetKeyCodeIntf		*APIGetKeyCode;
	APIDefineKeyIntf		*APIDefineKey;
	APIGetNamedObjectIntf		*APIGetNamedObject;
	APIIsChecklistRunningIntf	*APIIsChecklistRunning;
	APIRunChecklistIntf		*APIRunChecklist;
	APIGetKeyAssignmentIntf		*APIGetKeyAssignment;
	APIAlertBoxIntf			*APIAlertBox;
	APICountPythonMethodModulesIntf		*APICountPythonMethodModules;
	APIGetPythonMethodModuleIntf	*APIGetPythonMethodModule;
	APICreateVehicleIntf		*APICreateVehicle;
	APIDisposeVehicleIntf		*APIDisposeVehicle;
	APISetVehiclePathIntf		*APISetVehiclePath;
	APIAddKeyHandler2Intf		*APIAddKeyHandler2;
	APIRemoveKeyHandler2Intf	*APIRemoveKeyHandler2;
	APIDebounceKey2Intf		*APIDebounceKey2;
	APICreateWindow2Intf		*APICreateWindow2;
	APICloseWindow2Intf		*APICloseWindow2;
	APIIsComponentTypeIntf		*APIIsComponentType;
	APIIsWindowOpenIntf		*APIIsWindowOpen;
	APIGetUIButtonLabelIntf		*APIGetUIButtonLabel;
	APISetUIButtonLabelIntf		*APISetUIButtonLabel;
	APIGetUICheckboxStateIntf	*APIGetUICheckboxState;
	APISetUICheckboxStateIntf	*APISetUICheckboxState;
	APIGetUICheckboxLabelIntf	*APIGetUICheckboxLabel;
	APISetUICheckboxLabelIntf	*APISetUICheckboxLabel;
	APIGetUIRadioStateIntf		*APIGetUIRadioState;
	APISetUIRadioStateIntf		*APISetUIRadioState;
	APIGetUIRadioLabelIntf		*APIGetUIRadioLabel;
	APISetUIRadioLabelIntf		*APISetUIRadioLabel;
	APIAddUIMenuIntf		*APIAddUIMenu;
	APIAddUIMenuItemIntf		*APIAddUIMenuItem;
	APIAddUIMenuSeperatorIntf	*APIAddUIMenuSeperator;
	APIRemoveUIMenuItemIntf		*APIRemoveUIMenuItem;
	APIClearUIMenuItemsIntf		*APIClearUIMenuItems;
	APICheckUIMenuItemIntf		*APICheckUIMenuItem;
	APIEnableUIMenuItemIntf		*APIEnableUIMenuItem;
	APIAddUIPopupItemIntf		*APIAddUIPopupItem;
	APIAddUIPopupSeperatorIntf	*APIAddUIPopupSeperator;
	APIRemoveUIPopupItemIntf	*APIRemoveUIPopupItem;
	APIClearUIPopupItemsIntf	*APIClearUIPopupItems;
	APISelectUIPopupItemIntf	*APISelectUIPopupItem;
	APIGetUIPopupItemSelectionIntf	*APIGetUIPopupItemSelection;
	APIGetUIPopupLabelIntf		*APIGetUIPopupLabel;
	APISetUIPopupLabelIntf		*APISetUIPopupLabel;
	APISetUIRadioGroupSelectionIntf	*APISetUIRadioGroupSelection;
	APIGetUIRadioGroupSelectionIntf	*APIGetUIRadioGroupSelection;
	APIGetUILabelTextIntf		*APIGetUILabelText;
	APISetUILabelTextIntf		*APISetUILabelText;
	APISetUIScrollbarMinIntf	*APISetUIScrollbarMin;
	APISetUIScrollbarMaxIntf	*APISetUIScrollbarMax;
	APISetUIScrollbarValueIntf	*APISetUIScrollbarValue;
	APIGetUIScrollbarMinIntf	*APIGetUIScrollbarMin;
	APIGetUIScrollbarMaxIntf	*APIGetUIScrollbarMax;
	APIGetUIScrollbarValueIntf	*APIGetUIScrollbarValue;
	APISetUIScrollbarPageSizeIntf	*APISetUIScrollbarPageSize;
	APIGetUIScrollbarPageSizeIntf	*APIGetUIScrollbarPageSize;
	APISetUISliderMajorTickSpacingIntf		*APISetUISliderMajorTickSpacing;
	APISetUISliderMinorTickSpacingIntf		*APISetUISliderMinorTickSpacing;
	APISetUISliderSnapToTicksIntf	*APISetUISliderSnapToTicks;
	APISetUISliderDrawMajorTicksIntf	*APISetUISliderDrawMajorTicks;
	APISetUISliderDrawMinorTicksIntf	*APISetUISliderDrawMinorTicks;
	APIGetUISliderMajorTickSpacingIntf		*APIGetUISliderMajorTickSpacing;
	APIGetUISliderMinorTickSpacingIntf		*APIGetUISliderMinorTickSpacing;
	APIGetUISliderSnapToTicksIntf	*APIGetUISliderSnapToTicks;
	APIGetUISliderDrawMajorTicksIntf		*APIGetUISliderDrawMajorTicks;
	APIGetUISliderDrawMinorTicksIntf		*APIGetUISliderDrawMinorTicks;
	APISetUISliderLabelIntf		*APISetUISliderLabel;
	APISetUIGroupBoxLabelIntf	*APISetUIGroupBoxLabel;
	APISetUITextMaxCharsIntf	*APISetUITextMaxChars;
	APIGetUITextMaxCharsIntf	*APIGetUITextMaxChars;
	APIUseUITextPasswordIntf	*APIUseUITextPassword;
	APIIsUITextPasswordIntf		*APIIsUITextPassword;
	APIGetUITextLengthIntf		*APIGetUITextLength;
	APISetUITextTextIntf		*APISetUITextText;
	APIGetUITextTextIntf		*APIGetUITextText;
	APISetUITextSelectionIntf	*APISetUITextSelection;
	APIGetUITextSelectionIntf	*APIGetUITextSelection;
	APISetUIProgressIndeterminateIntf		*APISetUIProgressIndeterminate;
	APIGetUIProgressIndeterminateIntf		*APIGetUIProgressIndeterminate;
	APISetUIProgressMinIntf		*APISetUIProgressMin;
	APIGetUIProgressMinIntf		*APIGetUIProgressMin;
	APISetUIProgressMaxIntf		*APISetUIProgressMax;
	APIGetUIProgressMaxIntf		*APIGetUIProgressMax;
	APISetUIProgressValueIntf	*APISetUIProgressValue;
	APIGetUIProgressValueIntf	*APIGetUIProgressValue;
	APIGetUIListRowCountIntf	*APIGetUIListRowCount;
	APIGetUIListColumnCountIntf	*APIGetUIListColumnCount;
	APIAddUIListColumnIntf		*APIAddUIListColumn;
	APIDeleteUIListColumnIntf	*APIDeleteUIListColumn;
	APIDeleteAllUIListColumnsIntf	*APIDeleteAllUIListColumns;
	APISetUIListColumnWidthIntf	*APISetUIListColumnWidth;
	APIAddUIListRowIntf		*APIAddUIListRow;
	APIDeleteUIListRowIntf		*APIDeleteUIListRow;
	APIDeleteAllUIListRowsIntf	*APIDeleteAllUIListRows;
	APICountUIListSelectedRowsIntf	*APICountUIListSelectedRows;
	APIGetUIListSelectedRowIntf	*APIGetUIListSelectedRow;
	APISelectUIListRowIntf		*APISelectUIListRow;
	APIClearUIListSelectionIntf	*APIClearUIListSelection;
	APISetUIListCellTextIntf	*APISetUIListCellText;
	APISetUIListCellIconIntf	*APISetUIListCellIcon;
	APIClearUIListCellTextIntf	*APIClearUIListCellText;
	APIClearUIListCellIconIntf	*APIClearUIListCellIcon;
	APIGetUIListCellTextIntf	*APIGetUIListCellText;
	APIDebugStringIntf		*APIDebugString;
	APIAddUIGraphTraceIntf		*APIAddUIGraphTrace;
	APIRemoveUIGraphTraceIntf	*APIRemoveUIGraphTrace;
	APIRemoveAllUIGraphTracesIntf	*APIRemoveAllUIGraphTraces;
	APIAddUIGraphTracePointIntf	*APIAddUIGraphTracePoint;
	APIClearUIGraphTracePointsIntf	*APIClearUIGraphTracePoints;
	APISetUIGraphTraceRangeIntf	*APISetUIGraphTraceRange;
	APISetUIGraphTraceColorIntf	*APISetUIGraphTraceColor;
	APISetUIGraphUseGridIntf	*APISetUIGraphUseGrid;
	APISetUIGraphGridRangeIntf	*APISetUIGraphGridRange;
	APISetUIGraphGridSpacingIntf	*APISetUIGraphGridSpacing;
	APISetUIGridColorIntf		*APISetUIGridColor;
	APISetUIGridBackColorIntf	*APISetUIGridBackColor;
	APIGetUIGraphGridRangeIntf	*APIGetUIGraphGridRange;
	APIGetUIGraphGridSpacingIntf	*APIGetUIGraphGridSpacing;
	APISetUIPictureImageIntf	*APISetUIPictureImage;
	APIOpenFileDialogIntf		*APIOpenFileDialog;
	APISaveFileDialogIntf		*APISaveFileDialog;
	APIOKCancelBoxIntf		*APIOKCancelBox;
	APIScrollUIListToRowIntf	*APIScrollUIListToRow;
	APIScrollUIListToColumnIntf	*APIScrollUIListToColumn;
	APIUserNeedsRepairIntf		*APIUserNeedsRepair;
	APIRepairUserIntf		*APIRepairUser;
	APIReportAllDamageIntf		*APIReportAllDamage;
	APIReportRotorDamageIntf	*APIReportRotorDamage;
	APIReportPropellerDamageIntf	*APIReportPropellerDamage;
	APIReportEngineDamageIntf	*APIReportEngineDamage;
	APIReportWingDamageIntf		*APIReportWingDamage;
	APIReportWheelDamageIntf	*APIReportWheelDamage;
	APIGetEngineStateIntf		*APIGetEngineState;
	APIAllEnginesRunningIntf	*APIAllEnginesRunning;
	APITurnOffAllAutopilotsIntf	*APITurnOffAllAutopilots;
	APILockoutUserControlIntf	*APILockoutUserControl;
	APIVisibleMoistureIntf		*APIVisibleMoisture;
	APIDistanceToNamedObjectIntf	*APIDistanceToNamedObject;
	APITextToSpeechIntf		*APITextToSpeech;
	APITextToSpeechAvailableIntf	*APITextToSpeechAvailable;
	APIEpicAvailableIntf		*APIEpicAvailable;
	APIEpicReadIntf			*APIEpicRead;
	APIEpicWriteIntf		*APIEpicWrite;
	APIEpicSendEventIntf		*APIEpicSendEvent;
	APIEpicSendPHIntf		*APIEpicSendPH;
	APIEpicSendQPIntf		*APIEpicSendQP;
	APIOpenDataBlockIntf		*APIOpenDataBlock;
	APICloseDataBlockIntf		*APICloseDataBlock;
	APIDataBlockSizeIntf		*APIDataBlockSize;
	APIReadDataBlockIntf		*APIReadDataBlock;
	APIWriteDataBlockIntf		*APIWriteDataBlock;
	APIReadDataItemIntf		*APIReadDataItem;
	APIReadDataItemIntIntf		*APIReadDataItemInt;
	APIReadDataItemFloatIntf	*APIReadDataItemFloat;
	APIWriteDataItemIntf		*APIWriteDataItem;
	APIWriteDataItemIntIntf		*APIWriteDataItemInt;
	APIWriteDataItemFloatIntf	*APIWriteDataItemFloat;
	APIGetTunedTypeIntf		*APIGetTunedType;
	APIGetTunedNavaidIntf		*APIGetTunedNavaid;
	APIGetTunedILSIntf		*APIGetTunedILS;
	APIGetTunedCommIntf		*APIGetTunedComm;
	APIShowWindowIntf		*APIShowWindow;
	APIHideWindowIntf		*APIHideWindow;
	APIGetGroundTypeIntf		*APIGetGroundType;
	APIDoesSceneryExistIntf		*APIDoesSceneryExist;
	APIAddGeneratedSceneryIntf	*APIAddGeneratedScenery;
	APISetPartIntf			*APISetPart;
	APISetPartFrameIntf		*APISetPartFrame;
	APIFreeFontIntf			*APIFreeFont;
  APIDrawDotIntf *APIDrawDot;
  APIDrawLineIntf *APIDrawLine;
  APIDrawRectIntf *APIDrawRect;
  APIFillRectIntf *APIFillRect;
  APIDrawCircleIntf *APIDrawCircle;
  APIMakeRGBIntf *APIMakeRGB;
	APIGetFlyVersionIntf		*APIGetFlyVersion;
	APIGetScreenDirectIntf		*APIGetScreenDirect;
	APIGainFocusIntf		*APIGainFocus;
	APILoseFocusIntf		*APILoseFocus;
	APIGetLightScalarsIntf		*APIGetLightScalars;
	APISetLightScalarsIntf		*APISetLightScalars;
	APIGetWindsAloftIntf		*APIGetWindsAloft;
	APISetWindsAloftIntf		*APISetWindsAloft;
	APIGetFilePathIntf		*APIGetFilePath;
	APIGestaltIntf			*APIGestalt;
	APIGestaltSetIntf		*APIGestaltSet;
	APIGestaltClearIntf		*APIGestaltClear;
	APILoadSkyModelsIntf		*APILoadSkyModels;
	APISelectSkyModelIntf		*APISelectSkyModel;
	APIRandomlySwapSkiesIntf	*APIRandomlySwapSkies;
	APIGetFileLengthIntf		*APIGetFileLength;
	APIOpenFileIntf			*APIOpenFile;
	APICloseFileIntf		*APICloseFile;
	APIReadFromFileIntf		*APIReadFromFile;

} APIFunctionRegistry;

#ifdef WIN
#pragma pack()
#endif

#ifdef MAC
#pragma options align = reset
#endif

extern APIFunctionRegistry	gRegistry;

};	// extern "C"

#endif // __SDKINTF__
