var map;
var FPMgr;
var listFP = [];
var fpLine;
var ssLine;
var gridLine;
var gridPts = []; 
var startPos;
var inertial;
var listRwy = [];
var markerSIT;

function flightplanSetUp(m) {
	map = m;
	FPMgr = new MarkerManager(map);
}

function clearFP() {
	if (listFP.length > 0) {
		FPMgr.clearMarkers();
		fpLine.setMap(null);
		listFP = [];
	}
	var polyOptions1 = {
      strokeColor: '#FF1CD9',
      strokeOpacity: 1.0,
      strokeWeight: 2
    }
    fpLine = new google.maps.Polyline(polyOptions1);
    fpLine.setMap(map);
	var polyOptions2 = {
      strokeColor: '#000000',
      strokeOpacity: 1.0,
      strokeWeight: 2
    }
    ssLine = new google.maps.Polyline(polyOptions2);
    ssLine.setMap(map);
}

function addPointToFp(location, name) {
	var path = fpLine.getPath();
	path.push(location);
	marker = createFPMarker(location, name);
	marker.setIcon(imgWptFP);
	listFP.push(marker);
}

function addPointToSS(location, name) {
	var path = ssLine.getPath();
	path.push(location);
}

function clearSS() {
	var path = ssLine.getPath();
	path.clear();
}

function addNewPointToFp(position, map) {
	addNewWptToFp(position,"WPT");
}
			
function addNewWptToFp(location, name) {
	marker = createFPMarker(location, name);
	mainWindow.addNewWptToFp(marker.getTitle(), marker.getPosition().lat(), marker.getPosition().lng() );
}

function createFPMarker(location, name) {
	var marker = new google.maps.Marker({
		position: location,
		title: name
	});
	google.maps.event.addListener(marker, 'mouseover', function() {
		lastApt = 0;
		lastNav = 0;
		lastWpt = marker;
	});
	return marker;
}

function pushFP() {
	FPMgr.addMarkers(listFP, 4);
	FPMgr.refresh();
}

function clearRunway() {
	for (var i = 0; i<listRwy.length; i++) {
		var runway = listRwy[i];
		runway.setMap(null);
	}
}

function drawRwy(location1, location2) {
	var optionsPolyline = {
		map: map,
		strokeWeight: 3,
		strokeColor:'#000000'
	};
	runway  = new google.maps.Polyline(optionsPolyline);
	listRwy.push(runway);
	runway.setMap(map);	
	runway.setPath([location1,location2]);
}

// SIT marker -----------------------------------------------------------------
function addSitMarker(location, name, angle) {
	icone = createSitIcon(angle);
	markerSIT.setMap(null);
    markerSIT = createSitMarker(location, name, icone);
}

function createSitMarker(location, name, icone) {
    var marker = new google.maps.Marker({
    	map: map,
        position: location,
        title: name,
		icon: icone,
		draggable: true
    });
    
	google.maps.event.addListener(marker, 'dragend', function () {
        pos = marker.getPosition();
        lat = pos.lat();
        lon = pos.lng();
        mainWindow.doMoveSIT(lat, lon);
    });
	return marker;
}

function createSitIcon(angle) {
	var imgSit = {
	  path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
	  fillOpacity: 0.0,
	  scale: 5,
	  strokeColor: "red",
	  strokeWeight: 2,
	  rotation: angle
	};
	return imgSit;
}

