var map;
var ArptMgr;
var VORMgr;
var NDBRteMgr;
var NDBTermMgr;
var WPTRteMgr;
var WPTTermMgr;
var WPTVfrMgr;
var imgNDB;
var imgNDBDME;
var imgVOR;
var imgDME;
var imgVORDME;
var imgArpt;
var imgWptRte;
var imgWptTerm;
var imgWptRNav;
var imgWptVfr;
var imgWptFP;

var acftMrkr;
var trace;

var typVor = 1;
var typVorTac = 5;
var typNdb = 8;
var typVorDme = 17;
var typNdbDme = 24;
var typWptF = 1;      	// Fixed
var typWptNdb = 4;    	// NDB
var typWptN = 6;      	// Named
var typWptOff = 9;    	// Off route
var typWptV = 10;     	// VFR
var typWptR = 12;     	// RNAV
var useHL = 1;			// High level
var useLL = 2;			// Low level
var useBL = 3;			// Both level
var useTerm = 4;		// Terminal
var useRNav = 5;		// RNAV
var useVFR = 6;			// VFR
var listApt = [];		// Airport
var listVOR = [];		// VOR, VORDME, DME
var listNDBRte = [];	// NDB en route
var listNDBTerm = [];	// NDB terminal
var listWptRte = [];	// En route
var listWptTerm = [];	// Terminal
var listWptRNav = [];	// RNAV
var listWptVfr = [];	// VFR
//ATS
var ats;
var path;
var listATSL = [];		// ATS Low level
var listATSH = [];		// ATS High level
var listATSB = [];		// ATS Both level

var lastApt = 0;
var lastNav = 0;
var lastWpt = 0;
var theLast = 0;

var zoomAPT = 6;
var zoomVOR = 7;
var zoomNDB = 7;
var zoomATS = 7;
var zoomWPT = 7;

// Initialize
function navigatorSetUp(m) {
	map = m;
	// Airport manager
	var mcOptions = {  
		gridSize: 500, 
		maxZoom: 6};
	ArptMgr = new MarkerClusterer(map, [], mcOptions);
	
	// Icon
	imgArpt = new google.maps.MarkerImage(
		"Images/Airport_Civil.png",
		new google.maps.Size(16, 16),
		null,
		new google.maps.Point(8, 8));
	imgVOR = new google.maps.MarkerImage(
		"Images\\VOR.png",
		null,
		null,
		new google.maps.Point(12, 10));
	imgDME = new google.maps.MarkerImage(
		"Images\\DME.png",
		null,
		null,
		new google.maps.Point(12, 10));
	imgVORDME = new google.maps.MarkerImage(
		"Images\\VORDME.png",
		null,
		null,
		new google.maps.Point(12, 10));
	imgNDB = new google.maps.MarkerImage(
		"Images\\NDB.png",
		null,
		null,
		new google.maps.Point(8,8));
	imgNDBDME = new google.maps.MarkerImage(
		"Images\\NDB.png",
		null,
		null,
		new google.maps.Point(8,8));
	imgWptRte = new google.maps.MarkerImage(
		"Images\\IFR1.png",
		new google.maps.Size(10, 10),
		null,
		new google.maps.Point(5, 5));
	imgWptTerm = new google.maps.MarkerImage(
		"Images\\IFR2.png",
		new google.maps.Size(10, 10),
		null,
		new google.maps.Point(5, 5));
	imgWptRNav = new google.maps.MarkerImage(
		"Images\\IFR4.png",
		new google.maps.Size(10, 10),
		null,
		new google.maps.Point(5, 5));
	imgWptVfr = new google.maps.MarkerImage(
		"Images\\IFR3.png",
		new google.maps.Size(10, 10),
		null,
		new google.maps.Point(5, 5));
	imgWptFP = new google.maps.MarkerImage(
		"Images\\Plan.png",
		null, //new google.maps.Size(10, 10),
		null,
		new google.maps.Point(5, 5));		
}

// Airport
function addAPTMarker(location, name, type, tooltip) {
	marker = createAPTMarker(location, name);
	attachMsg(marker, tooltip);
	listApt.push(marker);
}

function clearAllAPTMarker() {
	APTMgr.clearMarkers();
	listApt = [];
}

function createAPTMarker(location, name)
{
	var marker = new google.maps.Marker({
		position: location,
		title: name,
		icon: imgArpt
	});
	google.maps.event.addListener(marker, 'mouseover', function() {
		lastApt = marker;
		lastNav = 0;
		lastWpt = 0;
	});
	google.maps.event.addListener(marker, 'click', function() {
		mainWindow.doViewRwy(name);
	});
	return marker
}

function pushAPT() {
	ArptMgr.addMarkers(listApt);
}

// VOR
function addVORMarker(location, name, type, tooltip) {
	marker = createVORMarker(location, name);
	switch (type) {
		case typVor: 
			marker.setIcon(imgVOR);
			break;
		case typVorTac:
			marker.setIcon(imgDME);
			break;
		case typVorDme:
			marker.setIcon(imgVORDME);
	}
	attachMsg(marker, tooltip);
	listVOR.push(marker);
}

function addVORMarker2(location, name, type, tooltip) {
 	theLast.setMap(null);
	addVORMarker(location, name, type, tooltip)
	VORMgr.addMarker(marker);
}

function createVORMarker(location, name)
{
	var marker = new google.maps.Marker({
		position: location,
		title: name
	});
	google.maps.event.addListener(marker, 'mouseover', function() {
		lastApt = 0;
		lastNav = marker;
		lastWpt = 0;
	});
	return marker
}

function delNavaid() {
	index = listVOR.indexOf(lastNav);
	if (index != -1) {
		lastNav.setMap(null);
		return;
	}
	index = listNDBRte.indexOf(lastNav);
	if (index != -1) {
		lastNav.setMap(null);
		return;
	}
	index = listNDBTerm.indexOf(lastNav);
	if (index != -1) {
		lastNav.setMap(null);
		return;
	}
}

function delWaypoint() {
}

// NDB
function addNDBMarker(location, name, type, tooltip) {
 	marker = createNDBMarker(location, name);
	marker.setIcon(imgNDB);
 	switch (type) {
 		case useHL:
 		case useLL:
 		case useBL:
			listNDBRte.push(marker);
			break;
		case useTerm:
			listNDBTerm.push(marker);
	}
	attachMsg(marker, tooltip);
}

function addNDBMarker2(location, name, type, tooltip) {
 	theLast.setMap(null);
	addNDBMarker(location, name, type, tooltip)
 	switch (type) {
 		case useHL:
 		case useLL:
 		case useBL:
			NDBRteMgr.addMarker(marker,false);
			break;
		case useTerm:
			NDBTermMgr.addMarker(marker,false);
	}
}

function createNDBMarker(location, name)
{
	var marker = new google.maps.Marker({
		position: location,
		title: name
	});
	google.maps.event.addListener(marker, 'mouseover', function() {
		lastApt = 0;
		lastNav = marker;
		lastWpt = 0;
	});
	return marker
}

function addNavMgr() {
  	var mcOptions = {  
		gridSize: 500, 
		maxZoom: 6};
	VORMgr = new MarkerClusterer(map, null, mcOptions);
	NDBRteMgr = new MarkerClusterer(map, null, mcOptions);
	NDBTermMgr = new MarkerClusterer(map, null, mcOptions);
}

// Waypoint
function addWPTMarker(location, name, type, tooltip) {
	marker = createWPTMarker(location, name);
	switch (type) {
		case 0:
		case useHL:
		case useLL:
		case useBL:
		case useRNav:
			marker.setIcon(imgWptRte);
			listWptRte.push(marker);
			break;
		case useTerm:
			marker.setIcon(imgWptTerm);
			listWptTerm.push(marker);
			break;
		case useVFR:
			marker.setIcon(imgWptVfr);
			listWptVfr.push(marker);
			break;
	} 	
	attachMsg(marker, tooltip);
}

function addWPTMarker2(location, name, type, tooltip) {
 	theLast.setMap(null);
 	addWPTMarker(location, name, type, tooltip)
	switch (type) {
		case 0:
		case useHL:
		case useLL:
		case useBL:
		case useRNav:
			WPTRteMgr.addMarker(marker,false);
			break;
		case useTerm:
			WPTTermMgr.addMarker(marker,false);
			break;
		case useVFR:
			WPTVfrMgr.addMarker(marker,false);
			break;
	} 	
}

function createWPTMarker(location, name) {
	var marker = new google.maps.Marker({
		position: location,
		title: name
	});
	google.maps.event.addListener(marker, 'mouseover', function() {
		lastApt = 0;
		lastNav = 0;
		lastWpt = marker;
	});
	return marker
}

function addWptMgr() {
  	var mcOptions = {  
		gridSize: 500, 
		maxZoom: 6};
	WPTRteMgr = new MarkerClusterer(map, null, mcOptions);
	WPTTermMgr = new MarkerClusterer(map, null, mcOptions);
	WPTVfrMgr = new MarkerClusterer(map, null, mcOptions);
}

function attachMsg(marker, text) {
	google.maps.event.addListener(marker, 'mouseover', function() {
		mainWindow.doData(text);
	});	
	
	google.maps.event.addListener(marker, 'mouseout', function() {
		mainWindow.doData("");
	});	
}

// ATS
function addATS(level) {
	ats = createATS(level);
	switch (level) {
		case 'L': 
			listATSL.push(ats);
			break;
		case 'H': 
			listATSH.push(ats);
			break;
		case 'B': 
			listATSB.push(ats);
	}
}

function createATS(level) {
	var optionsPolyline = {
		map: map,
		strokeWeight: 1
	};
	switch (level) {
		case 'L': 
			optionsPolyline.strokeColor = '#0000FF';
			break;
		case 'H': 
			optionsPolyline.strokeColor = '#00FF00';
			break;
		case 'B': 
			optionsPolyline.strokeColor = '#FF0000';
	}
	var ats = new google.maps.Polyline(optionsPolyline);
//	google.maps.event.addListener(ats, 'mouseover', function() {
//		mainWindow.doSomething( 'Scenery for Legacy begin..' );
//	});
	return ats;
}

function addToATS(location, text) {
	var path = ats.getPath();
	path.push(location);	
	google.maps.geometry.encoding.encodePath(path);
}

function showATS(level, visible) {
	switch (level) {
		case 'L': 
			for (var i = 0; i<listATSL.length; i++) {
				var poly = listATSL[i]
				if (visible) {
					poly.setMap(map);
				} else {
					poly.setMap(null);
				}
			};
			break;
		case 'H': 
			for (var i = 0; i<listATSH.length; i++) {
				var poly = listATSH[i];
				if (visible) {
					poly.setMap(map);
				} else {
					poly.setMap(null);
				}
			}
			break;
		case 'B': 
			for (var i = 0; i<listATSB.length; i++) {
				var poly = listATSB[i];
				if (visible) {
					poly.setMap(map);
				} else {
					poly.setMap(null);
				}
			}
		}
}

function createAcftIcon(angle) {
	var AcftIcon = {
	  path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
	  fillOpacity: 0.0,
	  scale: 10,
	  strokeColor: "red",
	  strokeWeight: 1,
	  rotation: angle
	};
	return AcftIcon;
}

function setAcftMrkr(location, angle) {
	icone = createAcftIcon(angle);
    acftMrkr.setPosition(location);
    acftMrkr.setIcon(icone);
    addPointToTrace(location);
}

function addAcftMrkr(location, name, angle) {
	icone = createAcftIcon(angle);
    acftMrkr = new google.maps.Marker({
    	map: map,
        position: location,
        title: name,
		icon: icone,
		draggable: false
    });
    
	var polyOptions = {
      strokeColor: '#FF1CD9',
      strokeOpacity: 1.0,
      strokeWeight: 2
    }
    trace = new google.maps.Polyline(polyOptions);
    trace.setMap(map);
    addPointToTrace(location)
}

function eraseAcftMrkr() {
	acftMrkr.setMap(null);
	trace.setMap(null);
}

function addPointToTrace(location) {
	var path = trace.getPath();
	path.push(location);
}
