/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.controllers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.views.panels.generic.SceneryFilePanel;
import com.osm2xp.jobs.GenerateTileJob;
import com.osm2xp.jobs.MutexRule;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.project.Coordinates;
import com.osm2xp.parsers.tilesLister.TilesLister;
import com.osm2xp.parsers.tilesLister.TilesListerFactory;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.MiscUtils;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.helpers.Osm2xpProjectHelper;
import com.osm2xp.utils.helpers.StatsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import math.geom2d.Point2D;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class BuildController {
    private String folderPath;
    private MutexRule rule = new MutexRule();

    public void launchBuild() throws Osm2xpException {
        File currentFile = new File(GuiOptionsHelper.getOptions().getCurrentFilePath());
        this.folderPath = String.valueOf(currentFile.getParent()) + File.separator + GuiOptionsHelper.getSceneName();
        if (!new File(this.folderPath).exists() || MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm", (String)(String.valueOf(this.folderPath) + " already exists, delete?"))) {
            this.startGeneration(currentFile);
        }
    }

    public void restartImportedProject() throws Osm2xpException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective("com.osm2xp.buildPerspective", workbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            Osm2xpLogger.warning("Error switching perspective", e);
        }
        GuiOptionsHelper.getOptions().setCurrentFilePath(Osm2xpProjectHelper.getOsm2XpProject().getFile());
        File currentFile = new File(Osm2xpProjectHelper.getOsm2XpProject().getFile());
        this.folderPath = Osm2xpProjectHelper.getProjectFile().getParent();
        for (Coordinates coordinates : Osm2xpProjectHelper.getOsm2XpProject().getCoordinatesList().getCoordinates()) {
            Point2D tuile = new Point2D((double)coordinates.getLatitude(), (double)coordinates.getLongitude());
            try {
                this.generateSingleTile(currentFile, tuile, this.folderPath, null);
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error generating tile", e);
            }
        }
    }

    private void startGeneration(File currentFile) throws Osm2xpException {
        if (new File(this.folderPath).exists()) {
            FilesUtils.deleteDirectory(new File(this.folderPath));
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective("com.osm2xp.buildPerspective", workbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            Osm2xpLogger.warning("Error switching perspective", e);
        }
        Point2D coordinates = SceneryFilePanel.getCoordinates();
        if (coordinates == null) {
            this.generateWholeFile(currentFile, this.folderPath);
        } else {
            this.generateSingleTile(currentFile, coordinates, this.folderPath, null);
        }
    }

    private void generateSingleTile(File currentFile, Point2D coordinates, final String folderPath, List<Relation> relationsList) throws Osm2xpException {
        String jobTitle = "Generate tile " + (int)coordinates.x + " / " + (int)coordinates.y + " of file " + currentFile.getName();
        final GenerateTileJob job = new GenerateTileJob(jobTitle, currentFile, coordinates, folderPath, relationsList, "todoJob");
        job.setRule(new MutexRule());
        job.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                job.setFamilly("endedJob");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (Job.getJobManager().find((Object)"todoJob").length == 0) {
                            try {
                                StatsHelper.RecapStats(folderPath);
                            }
                            catch (Osm2xpException e) {
                                Osm2xpLogger.warning("Error saving recap stats.", e);
                            }
                            Osm2xpLogger.info("Generation finished.");
                            MiscUtils.switchPerspective(GuiOptionsHelper.getOptions().getOutputFormat());
                        }
                    }
                });
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
        job.setRule(this.rule);
        job.schedule();
    }

    private void generateWholeFile(final File currentFile, final String folderPath) {
        final TilesLister tilesLister = TilesListerFactory.getTilesLister(currentFile);
        Osm2xpLogger.info("Listing tiles in file " + currentFile.getName());
        Job job = new Job("Listing tiles "){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    tilesLister.process();
                }
                catch (Osm2xpException e) {
                    Osm2xpLogger.error("Error listing tiles", e);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                ArrayList<Point2D> tilesList = new ArrayList<Point2D>(tilesLister.getTilesList());
                Osm2xpLogger.info("listing of tiles complete");
                Osm2xpLogger.info(String.valueOf(tilesList.size()) + " tile(s) found");
                try {
                    Osm2xpProjectHelper.initProject(tilesList, folderPath, GuiOptionsHelper.getOptions().getCurrentFilePath());
                }
                catch (Osm2xpException e1) {
                    Osm2xpLogger.error("Error creating project file", e1);
                }
                for (Point2D tuile : tilesList) {
                    try {
                        BuildController.this.generateSingleTile(currentFile, tuile, folderPath, null);
                    }
                    catch (Osm2xpException e) {
                        Osm2xpLogger.error("Error generating tile", e);
                        this.canceling();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

