/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.dataProcessors.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Nd;
import com.osm2xp.model.osm.Node;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.h2.tools.Server;

public class DataBaseProcessorImpl
implements IProcessor {
    private static final String QUERY_SELECT_NODE = "SELECT * FROM nodes where id=";
    private static final String QUERY_INSERT_NODE = "INSERT INTO NODES (id,latitude,longitude) VALUES ";
    private static final String QUERY_CREATE_NODES_TABLE = "CREATE TABLE NODES(id LONG PRIMARY KEY, latitude DOUBLE,longitude DOUBLE)";
    private static final String QUERY_DROP_NODES_TABLE = "DROP TABLE IF EXISTS NODES";
    private Server server;
    private Connection conn;

    public DataBaseProcessorImpl() throws Osm2xpException {
        this.initDB();
    }

    private void initDB() throws Osm2xpException {
        try {
            this.server = Server.createTcpServer((String[])new String[0]).start();
            Class.forName("org.h2.Driver");
            this.conn = DriverManager.getConnection("jdbc:h2:~/db", "sa", "");
            this.conn.prepareStatement(QUERY_DROP_NODES_TABLE).execute();
            this.conn.prepareStatement(QUERY_CREATE_NODES_TABLE).execute();
        }
        catch (SQLException e) {
            throw new Osm2xpException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public void storeNode(Node node) throws Osm2xpException {
        String query = "INSERT INTO NODES (id,latitude,longitude) VALUES (" + node.getId() + "," + node.getLat() + "," + node.getLon() + ")";
        try {
            this.conn.prepareStatement(query).execute();
        }
        catch (SQLException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public Node getNode(Nd nd) throws Osm2xpException {
        String query = QUERY_SELECT_NODE + nd.getRef();
        Node node = null;
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet result = stmt.executeQuery(query);
            if (result.next()) {
                node = new Node();
                node.setId(nd.getRef());
                node.setLat(result.getDouble("LATITUDE"));
                node.setLon(result.getDouble("LONGITUDE"));
            }
        }
        catch (SQLException e) {
            throw new Osm2xpException(e.getMessage());
        }
        return node;
    }

    @Override
    public List<Node> getNodes(List<Nd> nds) throws Osm2xpException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Nd nd : nds) {
            Node node = this.getNode(nd);
            if (node == null) {
                return null;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void complete() {
        this.server.stop();
    }
}

