/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.dataProcessors.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Nd;
import com.osm2xp.model.osm.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import math.geom2d.Point2D;

public class MemoryProcessorImpl
implements IProcessor {
    private Map<Long, Point2D> nodeMap = new HashMap<Long, Point2D>();

    @Override
    public void storeNode(Node node) throws Osm2xpException {
        Point2D pt = new Point2D(node.getLat(), node.getLon());
        this.nodeMap.put(node.getId(), pt);
    }

    @Override
    public Node getNode(Nd nd) throws Osm2xpException {
        Point2D loc = this.nodeMap.get(nd.getRef());
        if (loc != null) {
            Node node = new Node();
            node.setId(nd.getRef());
            node.setLat(loc.x);
            node.setLon(loc.y);
            return node;
        }
        return null;
    }

    @Override
    public List<Node> getNodes(List<Nd> nds) throws Osm2xpException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Nd nd : nds) {
            Node node = this.getNode(nd);
            if (node == null) {
                return null;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void complete() {
        this.nodeMap = null;
    }
}

