/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.ApplicationActionBarAdvisor;
import com.osm2xp.utils.helpers.FlyLegacyOptionsHelper;
import com.osm2xp.utils.helpers.FsxOptionsHelper;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.helpers.StatsHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        MessageConsole myConsole = new MessageConsole("", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{myConsole});
        MessageConsoleStream stream = myConsole.newMessageStream();
        PrintStream myS = new PrintStream((OutputStream)stream);
        System.setOut(myS);
        System.setErr(myS);
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(400, 300));
        configurer.setShowStatusLine(false);
        configurer.setShowCoolBar(true);
        configurer.setTitle("Osm2xp");
        configurer.setShowPerspectiveBar(true);
        configurer.setShowProgressIndicator(true);
        PlatformUI.getPreferenceStore().setValue("SHOW_OTHER_IN_PERSPECTIVE_MENU", false);
        PlatformUI.getPreferenceStore().setValue("SHOW_OPEN_ON_PERSPECTIVE_BAR", false);
        PlatformUI.getPreferenceStore().setValue("SHOW_TRADITIONAL_STYLE_TABS", false);
        configurer.setShowPerspectiveBar(false);
        this.removeUnwantedToolItems();
    }

    private void removeUnwantedToolItems() {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] actionSets = reg.getActionSets();
        String actionSetId = "org.eclipse.ui.edit.text.actionSet";
        String searchSetId = "org.eclipse.search.searchActionSet";
        int i = 0;
        while (i < actionSets.length) {
            if (actionSets[i].getId().equalsIgnoreCase(searchSetId) || actionSets[i].getId().startsWith(actionSetId)) {
                IExtension ext = actionSets[i].getConfigurationElement().getDeclaringExtension();
                reg.removeExtension(ext, new Object[]{actionSets[i]});
            }
            ++i;
        }
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        Shell shell = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
        shell.setMaximized(true);
        Osm2xpLogger.displayWelcomeMessage();
        GuiOptionsHelper.getOptions().setCurrentFilePath(null);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.osm2xp.viewSceneryTab");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        try {
            GuiOptionsHelper.saveOptions();
            XplaneOptionsHelper.saveOptions();
            FsxOptionsHelper.saveOptions();
            FlyLegacyOptionsHelper.saveOptions();
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error(e.getMessage());
        }
        StatsHelper.getStatsList();
        super.dispose();
    }
}

