/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.components;

import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FacadesExclusionsTable
extends Composite {
    private TableViewer viewer;
    private Table table;

    public FacadesExclusionsTable(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.createViewer(parent);
    }

    public void updateImportedExclusionsTags() {
        this.viewer.setInput(XplaneOptionsHelper.getOptions().getBuildingsExclusions().getExclusions());
        this.viewer.refresh();
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 65536);
        this.createColumns(parent, this.viewer);
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setSize(500, 500);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(XplaneOptionsHelper.getOptions().getBuildingsExclusions().getExclusions());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.widthHint = 485;
        gridData.heightHint = 200;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"key", "value"};
        TableViewerColumn colKey = this.createTableViewerColumn(titles[0], 16384, 0);
        colKey.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OsmTag p = (OsmTag)element;
                return p.getKey();
            }
        });
        colKey.setEditingSupport(new EditingSupport((ColumnViewer)this.getViewer()){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)((Table)this.getViewer().getControl()));
            }

            protected Object getValue(Object element) {
                return ((OsmTag)element).getKey();
            }

            protected void setValue(Object element, Object value) {
                ((OsmTag)element).setKey((String)value);
                this.getViewer().refresh();
            }
        });
        TableViewerColumn colValue = this.createTableViewerColumn(titles[1], 131072, 1);
        colValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OsmTag p = (OsmTag)element;
                return p.getValue();
            }
        });
        colValue.setEditingSupport(new EditingSupport((ColumnViewer)this.getViewer()){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)((Table)this.getViewer().getControl()));
            }

            protected Object getValue(Object element) {
                return ((OsmTag)element).getValue();
            }

            protected void setValue(Object element, Object value) {
                ((OsmTag)element).setValue((String)value);
                this.getViewer().refresh();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0, colNumber);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(250);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }
}

