/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.dialogs;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.facades.Facade;
import com.osm2xp.model.facades.FacadeSet;
import com.osm2xp.utils.helpers.FacadeSetHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class FacadeSetEditorDialog
extends Dialog {
    private Text textName;
    private Text textAuthor;
    private Text textRoofColor;
    private Text textWallColor;
    private String facadeSetFolder;
    private Table table;
    private TableViewer viewer;
    private Facade currentFacade;
    private FacadeSet facadeSet;
    private Button btnIndustrial;
    private Button btnCommercial;
    private Button btnResidential;
    private Button btnSlopedRoof;
    private Button btnSimplebuildingOnly;
    private Spinner spinnerMinVector;
    private Spinner spinnerMaxVector;
    private Spinner spinnerMinHeight;
    private Spinner spinnerMaxHeight;
    private Group grpFacadeFile;

    public FacadeSetEditorDialog(Shell parentShell, String facadeSetFolder) {
        super(parentShell);
        this.facadeSetFolder = facadeSetFolder;
        try {
            this.facadeSet = FacadeSetHelper.getFacadeSet(facadeSetFolder);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error getting facade set.", e);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new FillLayout(256));
        Group groupFacadesList = new Group(container, 0);
        groupFacadesList.setLayout((Layout)new FillLayout(256));
        this.viewer = new TableViewer((Composite)groupFacadesList, 65536);
        TableViewerColumn colFile = new TableViewerColumn(this.viewer, 0, 0);
        TableColumn column = colFile.getColumn();
        column.setText("file");
        column.setWidth(450);
        column.setResizable(false);
        column.setMoveable(false);
        colFile.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Facade p = (Facade)element;
                return p.getFile();
            }
        });
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.facadeSet.getFacades());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FacadeSetEditorDialog.this.viewer.getSelection();
                FacadeSetEditorDialog.this.currentFacade = (Facade)selection.getFirstElement();
                FacadeSetEditorDialog.this.updateProperties();
            }
        });
        Group groupProperties = new Group(container, 0);
        groupProperties.setLayout((Layout)new GridLayout(1, false));
        Group grpFacadeSetProperties = new Group((Composite)groupProperties, 0);
        GridData gd_grpFacadeSetProperties = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_grpFacadeSetProperties.heightHint = 187;
        grpFacadeSetProperties.setLayoutData((Object)gd_grpFacadeSetProperties);
        grpFacadeSetProperties.setText("Facade set properties");
        grpFacadeSetProperties.setBounds(0, 0, 70, 80);
        grpFacadeSetProperties.setLayout((Layout)new GridLayout(2, false));
        Label labelName = new Label((Composite)grpFacadeSetProperties, 0);
        labelName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelName.setText("Facade set name : ");
        this.textName = new Text((Composite)grpFacadeSetProperties, 2048);
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FacadeSetEditorDialog.this.facadeSet.setName(FacadeSetEditorDialog.this.textName.getText());
            }
        });
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.facadeSet.getName() != null) {
            this.textName.setText(this.facadeSet.getName());
        }
        Label labelAuthor = new Label((Composite)grpFacadeSetProperties, 0);
        labelAuthor.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelAuthor.setText("Author : ");
        this.textAuthor = new Text((Composite)grpFacadeSetProperties, 2048);
        this.textAuthor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textAuthor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FacadeSetEditorDialog.this.facadeSet.setAuthor(FacadeSetEditorDialog.this.textAuthor.getText());
            }
        });
        if (this.facadeSet.getAuthor() != null) {
            this.textAuthor.setText(this.facadeSet.getAuthor());
        }
        Label labelDescription = new Label((Composite)grpFacadeSetProperties, 0);
        labelDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelDescription.setText("Description");
        final StyledText styledTextDescription = new StyledText((Composite)grpFacadeSetProperties, 2048);
        styledTextDescription.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        styledTextDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FacadeSetEditorDialog.this.facadeSet.setDescription(styledTextDescription.getText());
            }
        });
        if (this.facadeSet.getDescription() != null) {
            styledTextDescription.setText(this.facadeSet.getDescription());
        }
        this.grpFacadeFile = new Group((Composite)groupProperties, 0);
        this.grpFacadeFile.setVisible(false);
        this.grpFacadeFile.setLayout((Layout)new GridLayout(2, false));
        this.grpFacadeFile.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.grpFacadeFile.setText("Facade file");
        Label labelRoofColor = new Label((Composite)this.grpFacadeFile, 0);
        labelRoofColor.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelRoofColor.setText("Roof color : ");
        this.textRoofColor = new Text((Composite)this.grpFacadeFile, 2048);
        this.textRoofColor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textRoofColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorDialog dlg = new ColorDialog(FacadeSetEditorDialog.this.getShell());
                dlg.setText("Choose roof Color");
                RGB rgb = dlg.open();
                if (rgb != null) {
                    FacadeSetEditorDialog.this.textRoofColor.setText(String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue);
                    FacadeSetEditorDialog.this.currentFacade.setRoofColor(FacadeSetEditorDialog.this.textRoofColor.getText());
                }
            }
        });
        Label labelWallColor = new Label((Composite)this.grpFacadeFile, 0);
        labelWallColor.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelWallColor.setText("Wall color :");
        this.textWallColor = new Text((Composite)this.grpFacadeFile, 2048);
        this.textWallColor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textWallColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorDialog dlg = new ColorDialog(FacadeSetEditorDialog.this.getShell());
                dlg.setText("Choose wall Color");
                RGB rgb = dlg.open();
                if (rgb != null) {
                    FacadeSetEditorDialog.this.textWallColor.setText(String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue);
                    FacadeSetEditorDialog.this.currentFacade.setWallColor(FacadeSetEditorDialog.this.textWallColor.getText());
                }
            }
        });
        new Label((Composite)this.grpFacadeFile, 0);
        new Label((Composite)this.grpFacadeFile, 0);
        this.btnIndustrial = new Button((Composite)this.grpFacadeFile, 32);
        this.btnIndustrial.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacadeSetEditorDialog.this.currentFacade.setIndustrial(FacadeSetEditorDialog.this.btnIndustrial.getSelection());
            }
        });
        this.btnIndustrial.setText("Industrial");
        this.btnResidential = new Button((Composite)this.grpFacadeFile, 32);
        this.btnResidential.setText("Residential");
        this.btnResidential.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacadeSetEditorDialog.this.currentFacade.setResidential(FacadeSetEditorDialog.this.btnResidential.getSelection());
            }
        });
        this.btnCommercial = new Button((Composite)this.grpFacadeFile, 32);
        this.btnCommercial.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnCommercial.setText("Commercial");
        this.btnCommercial.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacadeSetEditorDialog.this.currentFacade.setCommercial(FacadeSetEditorDialog.this.btnCommercial.getSelection());
            }
        });
        this.btnSimplebuildingOnly = new Button((Composite)this.grpFacadeFile, 32);
        this.btnSimplebuildingOnly.setText("Simple building only");
        this.btnSimplebuildingOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacadeSetEditorDialog.this.currentFacade.setSimpleBuildingOnly(FacadeSetEditorDialog.this.btnSimplebuildingOnly.getSelection());
            }
        });
        this.btnSlopedRoof = new Button((Composite)this.grpFacadeFile, 32);
        this.btnSlopedRoof.setText("Sloped roof");
        this.btnSlopedRoof.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacadeSetEditorDialog.this.currentFacade.setSloped(FacadeSetEditorDialog.this.btnSlopedRoof.getSelection());
                FacadeSetEditorDialog.this.currentFacade.setResidential(true);
                FacadeSetEditorDialog.this.currentFacade.setSimpleBuildingOnly(true);
            }
        });
        new Label((Composite)this.grpFacadeFile, 0);
        new Label((Composite)this.grpFacadeFile, 0);
        new Label((Composite)this.grpFacadeFile, 0);
        new Label((Composite)this.grpFacadeFile, 0);
        new Label((Composite)this.grpFacadeFile, 0);
        Label labelMinVector = new Label((Composite)this.grpFacadeFile, 0);
        labelMinVector.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelMinVector.setText("Minimum vector length :");
        this.spinnerMinVector = new Spinner((Composite)this.grpFacadeFile, 2048);
        this.spinnerMinVector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FacadeSetEditorDialog.this.spinnerMinVector.getSelection() > 0) {
                    FacadeSetEditorDialog.this.currentFacade.setMinVectorLength((double)FacadeSetEditorDialog.this.spinnerMinVector.getSelection() / 100.0);
                }
            }
        });
        this.spinnerMinVector.setMaximum(1000);
        this.spinnerMinVector.setIncrement(100);
        this.spinnerMinVector.setDigits(2);
        this.spinnerMinVector.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNewLabel = new Label((Composite)this.grpFacadeFile, 0);
        lblNewLabel.setText("Maximum vector length :");
        this.spinnerMaxVector = new Spinner((Composite)this.grpFacadeFile, 2048);
        this.spinnerMaxVector.setIncrement(100);
        this.spinnerMaxVector.setMaximum(1000);
        this.spinnerMaxVector.setDigits(2);
        this.spinnerMaxVector.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblMinimumHeightmeters = new Label((Composite)this.grpFacadeFile, 0);
        lblMinimumHeightmeters.setText("Minimum height (meters) :");
        this.spinnerMinHeight = new Spinner((Composite)this.grpFacadeFile, 2048);
        this.spinnerMinHeight.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblMaximumHeightmeters = new Label((Composite)this.grpFacadeFile, 0);
        lblMaximumHeightmeters.setText("Maximum height (meters) : ");
        this.spinnerMaxHeight = new Spinner((Composite)this.grpFacadeFile, 2048);
        this.spinnerMaxHeight.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerMaxHeight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FacadeSetEditorDialog.this.spinnerMaxHeight.getSelection() > 0) {
                    FacadeSetEditorDialog.this.currentFacade.setMaxHeight(FacadeSetEditorDialog.this.spinnerMaxHeight.getSelection());
                }
            }
        });
        this.spinnerMinHeight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FacadeSetEditorDialog.this.spinnerMinHeight.getSelection() > 0) {
                    FacadeSetEditorDialog.this.currentFacade.setMinHeight(FacadeSetEditorDialog.this.spinnerMinHeight.getSelection());
                }
            }
        });
        this.spinnerMaxVector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FacadeSetEditorDialog.this.spinnerMaxVector.getSelection() > 0) {
                    FacadeSetEditorDialog.this.currentFacade.setMaxVectorLength((double)FacadeSetEditorDialog.this.spinnerMaxVector.getSelection() / 100.0);
                }
            }
        });
        return container;
    }

    private void updateProperties() {
        this.grpFacadeFile.setVisible(true);
        if (this.currentFacade.getRoofColor() != null) {
            this.textRoofColor.setText(this.currentFacade.getRoofColor());
        } else {
            this.textRoofColor.setText("");
        }
        if (this.currentFacade.getWallColor() != null) {
            this.textWallColor.setText(this.currentFacade.getWallColor());
        } else {
            this.textWallColor.setText("");
        }
        this.btnResidential.setSelection(this.currentFacade.isResidential());
        this.btnCommercial.setSelection(this.currentFacade.isCommercial());
        this.btnIndustrial.setSelection(this.currentFacade.isIndustrial());
        this.btnSlopedRoof.setSelection(this.currentFacade.isSloped());
        this.btnSimplebuildingOnly.setSelection(this.currentFacade.isSimpleBuildingOnly());
        if (this.currentFacade.getMinVectorLength() > 0.0) {
            this.spinnerMinVector.setSelection((int)(this.currentFacade.getMinVectorLength() * 100.0));
        } else {
            this.spinnerMinVector.setSelection(0);
        }
        if (this.currentFacade.getMaxVectorLength() > 0.0) {
            this.spinnerMaxVector.setSelection((int)(this.currentFacade.getMaxVectorLength() * 100.0));
        } else {
            this.spinnerMaxVector.setSelection(0);
        }
        if (this.currentFacade.getMaxHeight() > 0) {
            this.spinnerMaxHeight.setSelection(this.currentFacade.getMaxHeight());
        } else {
            this.spinnerMaxHeight.setSelection(0);
        }
        if (this.currentFacade.getMinHeight() > 0) {
            this.spinnerMinHeight.setSelection(this.currentFacade.getMinHeight());
        } else {
            this.spinnerMinHeight.setSelection(0);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                try {
                    FacadeSetHelper.saveFacadeSet(FacadeSetEditorDialog.this.facadeSet, FacadeSetEditorDialog.this.facadeSetFolder);
                }
                catch (Osm2xpException e1) {
                    Osm2xpLogger.error("Error saving facade set", e1);
                }
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(733, 615);
    }
}

