/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.handlers;

import com.osm2xp.controllers.BuildController;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.dialogs.utils.Osm2xpDialogsHelper;
import com.osm2xp.utils.helpers.FsxOptionsHelper;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;

public class CommandBuildScene
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getConfigurationErrors() == null) {
            BuildController bc = new BuildController();
            try {
                bc.launchBuild();
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error building scene.", e);
            }
        } else {
            Osm2xpDialogsHelper.displayErrorDialog("Bad configuration, please check following errors:\n" + this.getConfigurationErrors());
        }
        return null;
    }

    private String getConfigurationErrors() {
        StringBuilder errors = new StringBuilder();
        if (GuiOptionsHelper.getOptions().getCurrentFilePath() == null) {
            errors.append("-No osm file selected.\n");
        }
        if ((GuiOptionsHelper.getOptions().getOutputFormat().equals("Xplane 10") || GuiOptionsHelper.getOptions().getOutputFormat().equals("Xplane 9")) && XplaneOptionsHelper.getOptions().getFacadeSet() == null) {
            errors.append("-No facade set selected.\n");
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Flight Simulator X") && StringUtils.isBlank((String)FsxOptionsHelper.getOptions().getBglCompPath())) {
            errors.append("-bglComp.exe location not set!\n");
        }
        if (errors.length() > 0) {
            return errors.toString();
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

