/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.handlers;

import com.osm2xp.controllers.BuildController;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.utils.helpers.Osm2xpProjectHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class CommandImportProject
implements IHandler {
    private static final String[] FILTER_NAMES = new String[]{"osm2xp project (*.project)"};
    private static final String[] FILTER_EXTS = new String[]{"*.project"};

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        dlg.setFilterNames(FILTER_NAMES);
        dlg.setFilterExtensions(FILTER_EXTS);
        String fileName = dlg.open();
        if (fileName != null) {
            try {
                Osm2xpProjectHelper.loadProject(fileName);
                if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Import project", (String)("Import project " + new File(fileName).getName() + " ?\n" + "(osm file : " + Osm2xpProjectHelper.getOsm2XpProject().getFile() + " , " + Osm2xpProjectHelper.getOsm2XpProject().getCoordinatesList().getCoordinates().size() + " tile(s) to process )"))) {
                    BuildController bc = new BuildController();
                    bc.restartImportedProject();
                }
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error loading project file", e);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

