/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.flyLegacy;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.components.WatchedTagsListTable;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.FlyLegacyOptionsHelper;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class WatchedTagsListPanel
extends Composite {
    final WatchedTagsListTable tagsTable;
    private static final String[] FILTER_NAMES = new String[]{"XML exclusions file (*.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xml"};

    public WatchedTagsListPanel(final Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar((Composite)this, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ToolItem tltmAdd = new ToolItem(toolBar, 0);
        tltmAdd.setToolTipText("add");
        tltmAdd.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlyLegacyOptionsHelper.getOptions().getWatchedTagsList().getTags().add(new OsmTag("a key", "a value"));
                WatchedTagsListPanel.this.tagsTable.getViewer().refresh();
            }
        });
        ToolItem tltmDelete = new ToolItem(toolBar, 0);
        tltmDelete.setToolTipText("delete");
        tltmDelete.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WatchedTagsListPanel.this.tagsTable.getViewer().getSelection();
                OsmTag selectedTag = (OsmTag)selection.getFirstElement();
                FlyLegacyOptionsHelper.getOptions().getWatchedTagsList().getTags().remove(selectedTag);
                WatchedTagsListPanel.this.tagsTable.getViewer().refresh();
            }
        });
        ToolItem tltmSeparator = new ToolItem(toolBar, 2);
        tltmSeparator.setWidth(20);
        ToolItem tltmExport = new ToolItem(toolBar, 0);
        tltmExport.setToolTipText("Export");
        tltmExport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/export_16.ico"));
        tltmExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 8192);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    try {
                        XmlHelper.saveToXml(FlyLegacyOptionsHelper.getOptions().getWatchedTagsList(), new File(fn));
                    }
                    catch (Osm2xpException e1) {
                        Osm2xpLogger.error("Error saving watched tags list to file" + new File(fn).getName(), e1);
                    }
                }
            }
        });
        ToolItem tltmImport = new ToolItem(toolBar, 0);
        tltmImport.setToolTipText("Import");
        tltmImport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/import_16.ico"));
        tltmImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    FlyLegacyOptionsHelper.importWatchedTags(new File(fn));
                    WatchedTagsListPanel.this.tagsTable.updateImportedExclusionsTags();
                }
            }
        });
        Group groupTable = new Group((Composite)this, 0);
        groupTable.setText("Watched osm tags list");
        GridData gd_composite = new GridData(4, 0x1000000, false, true, 1, 1);
        gd_composite.widthHint = 523;
        groupTable.setLayoutData((Object)gd_composite);
        groupTable.setLayout((Layout)new FillLayout(256));
        this.tagsTable = new WatchedTagsListTable((Composite)groupTable, 0);
        this.tagsTable.setLayout((Layout)new FillLayout(256));
    }
}

