/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.fsx;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.components.FilesPathsTable;
import com.osm2xp.gui.components.TagsRulesTable;
import com.osm2xp.gui.views.panels.Osm2xpPanel;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.FsxOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class FsxObjectsRulesPanel
extends Osm2xpPanel {
    private TagsRulesTable tagsTable;
    private FilesPathsTable ObjectsFilesTable;
    private Group grpFiles;
    private Group grpAngle;
    private static final String[] FILTER_NAMES = new String[]{"XML objects rules file (*.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xml"};
    private ObjectTagRule selectedObjectTagRule;
    private Spinner spinnerAngle;
    private Composite compositeRuleDetail;
    private Button btnCheckRandomAngle;
    private ToolBar toolBar;
    private ToolItem tltmAdd;
    private ToolItem tltmDelete;
    private ToolItem tltmExport;
    private ToolItem tltmImport;
    private Group groupTags;
    private GridData gridData;
    private GridData gridDataObjects;
    private GridData gridAngle;
    private GridData gridFiles;
    private ToolBar toolBarObjectFiles;
    private ToolItem tltmAddObjectFile;
    private ToolItem tltmDeleteObjectFile;

    public FsxObjectsRulesPanel(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initLayout() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.groupTags.setLayoutData((Object)this.gridData);
        this.groupTags.setLayout((Layout)new GridLayout(1, false));
        this.tagsTable.setLayout((Layout)new FillLayout(256));
        this.compositeRuleDetail.setLayout((Layout)new GridLayout(1, false));
        this.compositeRuleDetail.setLayoutData((Object)this.gridDataObjects);
        this.grpAngle.setLayoutData((Object)this.gridAngle);
        this.grpAngle.setLayout((Layout)new GridLayout(5, false));
        this.grpFiles.setLayoutData((Object)this.gridFiles);
        this.grpFiles.setLayout((Layout)new GridLayout(1, false));
        this.ObjectsFilesTable.setLayout((Layout)new FillLayout(256));
    }

    @Override
    protected void initComponents() {
        this.toolBar = new ToolBar((Composite)this, 0x820000);
        this.tltmAdd = new ToolItem(this.toolBar, 0);
        this.tltmAdd.setToolTipText("add");
        this.tltmAdd.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        this.tltmDelete = new ToolItem(this.toolBar, 0);
        this.tltmDelete.setToolTipText("delete");
        this.tltmDelete.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        ToolItem tltmSeparator = new ToolItem(this.toolBar, 2);
        tltmSeparator.setWidth(20);
        this.tltmExport = new ToolItem(this.toolBar, 0);
        this.tltmExport.setToolTipText("Export");
        this.tltmExport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/export_16.ico"));
        this.tltmImport = new ToolItem(this.toolBar, 0);
        this.tltmImport.setToolTipText("Import");
        this.tltmImport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/import_16.ico"));
        new Label((Composite)this, 0);
        this.groupTags = new Group((Composite)this, 0);
        this.groupTags.setText("Objects rules - osm tags ");
        this.gridData = new GridData(4, 128, false, false, 1, 1);
        this.gridData.heightHint = 320;
        this.gridData.widthHint = 329;
        this.tagsTable = new TagsRulesTable((Composite)this.groupTags, 0, FsxOptionsHelper.getOptions().getObjectsRules().getRules());
        this.compositeRuleDetail = new Composite((Composite)this, 0);
        this.compositeRuleDetail.setVisible(false);
        this.gridDataObjects = new GridData(4, 128, false, false, 1, 1);
        this.gridDataObjects.heightHint = 347;
        this.gridDataObjects.widthHint = 608;
        this.grpAngle = new Group(this.compositeRuleDetail, 0);
        this.gridAngle = new GridData(16384, 128, true, false, 1, 1);
        this.gridAngle.heightHint = 28;
        this.btnCheckRandomAngle = new Button((Composite)this.grpAngle, 32);
        this.btnCheckRandomAngle.setText("Random angle");
        new Label((Composite)this.grpAngle, 0);
        Label lblAngle = new Label((Composite)this.grpAngle, 0);
        lblAngle.setBounds(0, 0, 20, 13);
        lblAngle.setText("Angle :");
        this.spinnerAngle = new Spinner((Composite)this.grpAngle, 2048);
        this.spinnerAngle.setMaximum(360);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        this.grpFiles = new Group(this.compositeRuleDetail, 0);
        this.gridFiles = new GridData(16384, 1024, true, false, 1, 1);
        this.gridFiles.heightHint = 264;
        this.toolBarObjectFiles = new ToolBar((Composite)this.grpFiles, 0x820000);
        this.tltmAddObjectFile = new ToolItem(this.toolBarObjectFiles, 0);
        this.tltmAddObjectFile.setToolTipText("add");
        this.tltmAddObjectFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        this.tltmDeleteObjectFile = new ToolItem(this.toolBarObjectFiles, 0);
        this.tltmDeleteObjectFile.setToolTipText("delete");
        this.tltmDeleteObjectFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        this.ObjectsFilesTable = new FilesPathsTable((Composite)this.grpFiles, 0, "Object GUID");
        new Label((Composite)this.grpFiles, 0);
    }

    @Override
    protected void bindComponents() {
    }

    @Override
    protected void addComponentsListeners() {
        this.tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FsxOptionsHelper.getOptions().getObjectsRules().getRules().add(new ObjectTagRule(new OsmTag("a tag key", "a tag value"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
                    {
                        this.add(new ObjectFile("object GUID"));
                    }
                }, 0, true));
                FsxObjectsRulesPanel.this.tagsTable.getViewer().refresh();
            }
        });
        this.tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FsxObjectsRulesPanel.this.tagsTable.getViewer().getSelection();
                FsxOptionsHelper.getOptions().getObjectsRules().getRules().remove((ObjectTagRule)selection.getFirstElement());
                FsxObjectsRulesPanel.this.compositeRuleDetail.setVisible(false);
                FsxObjectsRulesPanel.this.tagsTable.getViewer().refresh();
            }
        });
        this.tltmExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(FsxObjectsRulesPanel.this.getParent().getShell(), 8192);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    FsxOptionsHelper.exportObjectsRules(new File(fn));
                }
            }
        });
        this.tltmImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(FsxObjectsRulesPanel.this.getParent().getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    FsxOptionsHelper.importObjectsRules(new File(fn));
                    FsxObjectsRulesPanel.this.tagsTable.updateInput(FsxOptionsHelper.getOptions().getObjectsRules().getRules());
                }
            }
        });
        this.tagsTable.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FsxObjectsRulesPanel.this.selectedObjectTagRule = (ObjectTagRule)event.item.getData();
                String selectedTag = String.valueOf(FsxObjectsRulesPanel.this.selectedObjectTagRule.getTag().getKey()) + "=" + FsxObjectsRulesPanel.this.selectedObjectTagRule.getTag().getValue();
                FsxObjectsRulesPanel.this.grpFiles.setText(MessageFormat.format("Objects files for tag ({0})", selectedTag));
                FsxObjectsRulesPanel.this.grpAngle.setText(MessageFormat.format("Angle for tag ({0})", selectedTag));
                FsxObjectsRulesPanel.this.spinnerAngle.setSelection(FsxObjectsRulesPanel.this.selectedObjectTagRule.getAngle());
                FsxObjectsRulesPanel.this.btnCheckRandomAngle.setSelection(FsxObjectsRulesPanel.this.selectedObjectTagRule.isRandomAngle());
                try {
                    FsxObjectsRulesPanel.this.ObjectsFilesTable.updateSelectedRule(FsxObjectsRulesPanel.this.selectedObjectTagRule.getObjectsFiles());
                }
                catch (Osm2xpException e) {
                    Osm2xpLogger.error("Error updating rules table.", e);
                }
                FsxObjectsRulesPanel.this.compositeRuleDetail.setVisible(true);
            }
        });
        this.btnCheckRandomAngle.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                FsxObjectsRulesPanel.this.selectedObjectTagRule.setRandomAngle(!FsxObjectsRulesPanel.this.btnCheckRandomAngle.getSelection());
            }
        });
        this.spinnerAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FsxObjectsRulesPanel.this.selectedObjectTagRule.setAngle(FsxObjectsRulesPanel.this.spinnerAngle.getSelection());
            }
        });
        this.tltmAddObjectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFile file = new ObjectFile();
                file.setPath("object GUID");
                FsxObjectsRulesPanel.this.selectedObjectTagRule.getObjectsFiles().add(file);
                FsxObjectsRulesPanel.this.ObjectsFilesTable.getViewer().refresh();
            }
        });
        this.tltmDeleteObjectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FsxObjectsRulesPanel.this.ObjectsFilesTable.getViewer().getSelection();
                ObjectFile selectedFile = (ObjectFile)selection.getFirstElement();
                FsxObjectsRulesPanel.this.selectedObjectTagRule.getObjectsFiles().remove(selectedFile);
                FsxObjectsRulesPanel.this.ObjectsFilesTable.getViewer().refresh();
            }
        });
    }
}

