/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.generic;

import com.osm2xp.gui.views.panels.Osm2xpPanel;
import com.osm2xp.translators.TranslatorBuilder;
import com.osm2xp.utils.MiscUtils;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class OutPutFormatPanel
extends Osm2xpPanel {
    private Label lblOutputFormat;
    private Combo comboOutput;
    private GridData gridComboOutput;
    private Label translatorLogo;
    private StyledText styledText;

    public OutPutFormatPanel(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 15;
        gridLayout.horizontalSpacing = 15;
        gridLayout.verticalSpacing = 15;
        this.setLayout((Layout)gridLayout);
        this.comboOutput.setLayoutData((Object)this.gridComboOutput);
        this.styledText.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
    }

    @Override
    protected void initComponents() {
        this.lblOutputFormat = new Label((Composite)this, 0);
        this.lblOutputFormat.setText("Output format :");
        this.comboOutput = new Combo((Composite)this, 8);
        this.gridComboOutput = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.gridComboOutput.minimumWidth = 200;
        this.translatorLogo = new Label((Composite)this, 0);
        GridData gridTranslatorData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridTranslatorData.minimumHeight = 100;
        gridTranslatorData.minimumWidth = 150;
        this.translatorLogo.setLayoutData((Object)gridTranslatorData);
        this.styledText = new StyledText((Composite)this, 64);
        this.styledText.setEnabled(false);
        this.styledText.setEditable(false);
        this.comboOutput.setItems(new String[]{"Xplane 9", "Xplane 10", "Fly! Legacy", "Flight Simulator X", "OpenStreetMap (xml)", "WaveFront (.obj)", "Console", "G2xpl binding file"});
        if (GuiOptionsHelper.getOptions().getOutputFormat() != null) {
            this.updateTranslatorInfo();
        }
    }

    @Override
    protected void bindComponents() {
        this.bindComponent((Widget)this.comboOutput, GuiOptionsHelper.getOptions(), "outputFormat");
    }

    private void updateTranslatorInfo() {
        String description;
        this.comboOutput.setText(GuiOptionsHelper.getOptions().getOutputFormat());
        Image translatorImage = TranslatorBuilder.getMinimalTranslator().getLogo();
        if (translatorImage != null) {
            this.translatorLogo.setImage(translatorImage);
        }
        if ((description = TranslatorBuilder.getMinimalTranslator().getDescription()) == null) {
            description = "";
        }
        this.styledText.setText(description);
    }

    @Override
    protected void addComponentsListeners() {
        this.comboOutput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MiscUtils.switchPerspective(OutPutFormatPanel.this.comboOutput.getText());
                OutPutFormatPanel.this.updateTranslatorInfo();
            }
        });
    }
}

