/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.generic;

import com.osm2xp.gui.views.LastFilesView;
import com.osm2xp.gui.views.panels.Osm2xpPanel;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import math.geom2d.Point2D;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class SceneryFilePanel
extends Osm2xpPanel {
    private static Label labelInputSceneFile;
    private static Text textInputSceneName;
    private static final String[] FILTER_NAMES;
    private static final String[] FILTER_EXTS;
    private static Button btnGenerateAllTiles;
    private static Spinner spinnerLatitude;
    private static Spinner spinnerLongitude;
    private Button btnBrowse;
    private GridData gridInputSceneFile;
    private Label lblSceneName;
    private GridData gridInputSceneName;
    private Group grpCoordinates;
    private GridData gridCoordinates;

    static {
        FILTER_NAMES = new String[]{"OSM files (*.osm,*.pbf;*.shp)"};
        FILTER_EXTS = new String[]{"*.osm;*.pbf;*.shp"};
    }

    public SceneryFilePanel(Composite parent, int style) {
        super(parent, 2048);
    }

    private static String computeSceneName() {
        StringBuilder sceneName = new StringBuilder();
        File file = new File(GuiOptionsHelper.getOptions().getCurrentFilePath());
        String fileName = file.getName().substring(0, file.getName().indexOf("."));
        sceneName.append(fileName);
        if (GuiOptionsHelper.getOptions().isAppendHour()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("_dd_MM_yy_HH'_'mm");
            sceneName.append(dateFormat.format(new Date()));
        }
        return sceneName.toString();
    }

    public static void refreshCurrentFilePath() {
        labelInputSceneFile.setText(GuiOptionsHelper.getOptions().getCurrentFilePath());
        GuiOptionsHelper.setSceneName(SceneryFilePanel.computeSceneName());
        String sceneName = SceneryFilePanel.computeSceneName();
        GuiOptionsHelper.setSceneName(sceneName);
        textInputSceneName.setText(sceneName);
    }

    public static Point2D getCoordinates() {
        if (btnGenerateAllTiles.getSelection()) {
            return null;
        }
        Point2D result = new Point2D((double)spinnerLatitude.getSelection(), (double)spinnerLongitude.getSelection());
        return result;
    }

    @Override
    protected void initLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 15;
        gridLayout.horizontalSpacing = 15;
        this.setLayout((Layout)gridLayout);
        this.lblSceneName.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        labelInputSceneFile.setLayoutData((Object)this.gridInputSceneFile);
        textInputSceneName.setLayoutData((Object)this.gridInputSceneName);
        btnGenerateAllTiles.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        this.grpCoordinates.setLayout((Layout)new GridLayout(7, false));
        this.grpCoordinates.setLayoutData((Object)this.gridCoordinates);
    }

    @Override
    protected void initComponents() {
        this.gridInputSceneFile = new GridData(16384, 0x1000000, true, true, 1, 1);
        this.gridInputSceneFile.widthHint = 600;
        this.btnBrowse = new Button((Composite)this, 0);
        this.btnBrowse.setText("Browse");
        labelInputSceneFile = new Label((Composite)this, 0);
        this.lblSceneName = new Label((Composite)this, 0);
        this.lblSceneName.setText("Scene name :");
        this.gridInputSceneName = new GridData(16384, 0x1000000, true, true, 1, 1);
        this.gridInputSceneName.widthHint = 300;
        textInputSceneName = new Text((Composite)this, 2048);
        btnGenerateAllTiles = new Button((Composite)this, 32);
        btnGenerateAllTiles.setSelection(true);
        btnGenerateAllTiles.setText("Generate all tiles");
        this.grpCoordinates = new Group((Composite)this, 0);
        this.gridCoordinates = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.gridCoordinates.widthHint = 294;
        this.grpCoordinates.setText("Coordinates");
        this.grpCoordinates.setVisible(false);
        Label lblLatitude = new Label((Composite)this.grpCoordinates, 0);
        lblLatitude.setText("Latitude:");
        new Label((Composite)this.grpCoordinates, 0);
        spinnerLatitude = new Spinner((Composite)this.grpCoordinates, 2048);
        spinnerLatitude.setMaximum(200);
        spinnerLatitude.setMinimum(-200);
        Label lblLongitude = new Label((Composite)this.grpCoordinates, 0);
        lblLongitude.setText("Longitude:");
        spinnerLongitude = new Spinner((Composite)this.grpCoordinates, 2048);
        spinnerLongitude.setMaximum(200);
        spinnerLongitude.setMinimum(-200);
        new Label((Composite)this.grpCoordinates, 0);
        new Label((Composite)this.grpCoordinates, 0);
    }

    @Override
    protected void bindComponents() {
    }

    @Override
    protected void addComponentsListeners() {
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(SceneryFilePanel.this.getParent().getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fileName = dlg.open();
                if (fileName != null) {
                    GuiOptionsHelper.addUsedFile(fileName);
                    GuiOptionsHelper.getOptions().setCurrentFilePath(fileName);
                    labelInputSceneFile.setText(fileName);
                    String sceneName = SceneryFilePanel.computeSceneName();
                    GuiOptionsHelper.setSceneName(sceneName);
                    textInputSceneName.setText(sceneName);
                    LastFilesView.refreshList();
                    if (fileName.toUpperCase().contains(".SHP")) {
                        GuiOptionsHelper.askShapeFileNature(SceneryFilePanel.this.getShell());
                    }
                }
            }
        });
        textInputSceneName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GuiOptionsHelper.setSceneName(textInputSceneName.getText());
            }
        });
        btnGenerateAllTiles.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SceneryFilePanel.this.grpCoordinates.setVisible(btnGenerateAllTiles.getSelection());
            }
        });
    }
}

