/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.xplane;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.views.panels.Osm2xpPanel;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class FacadeSetPanel
extends Osm2xpPanel {
    private Combo comboFacade;
    private Label lblFacadeSet;
    private GridData gridFacade;
    private Spinner spinnerLod;
    private Button btnSlopedRoofs;
    private Button btnHardBuildings;

    public FacadeSetPanel(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 15;
        gridLayout.horizontalSpacing = 15;
        gridLayout.verticalSpacing = 15;
        this.setLayout((Layout)gridLayout);
        this.comboFacade.setLayoutData((Object)this.gridFacade);
        this.spinnerLod.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        this.btnSlopedRoofs.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.btnHardBuildings.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
    }

    @Override
    protected void initComponents() {
        this.lblFacadeSet = new Label((Composite)this, 0);
        this.lblFacadeSet.setText("Facade set : ");
        this.comboFacade = new Combo((Composite)this, 8);
        this.gridFacade = new GridData(16384, 0x1000000, true, true, 1, 1);
        this.gridFacade.minimumWidth = 200;
        Label lblLod = new Label((Composite)this, 0);
        lblLod.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        lblLod.setText("L.O.D :");
        this.spinnerLod = new Spinner((Composite)this, 2048);
        this.spinnerLod.setMaximum(100000);
        String[] items = null;
        try {
            items = FilesUtils.listFacadesSets().toArray(new String[0]);
            this.comboFacade.setItems(items);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error getting facades sets list", e);
        }
        if (XplaneOptionsHelper.getOptions().getFacadeSet() != null) {
            this.comboFacade.setText(XplaneOptionsHelper.getOptions().getFacadeSet());
        }
        this.btnSlopedRoofs = new Button((Composite)this, 32);
        this.btnSlopedRoofs.setText("Sloped roofs");
        this.btnHardBuildings = new Button((Composite)this, 32);
        this.btnHardBuildings.setText("Hard buildings");
    }

    @Override
    protected void bindComponents() {
        this.bindComponent((Widget)this.comboFacade, XplaneOptionsHelper.getOptions(), "facadeSet");
        this.bindComponent((Widget)this.spinnerLod, XplaneOptionsHelper.getOptions(), "facadeLod");
        this.bindComponent((Widget)this.btnSlopedRoofs, XplaneOptionsHelper.getOptions(), "generateSlopedRoofs");
        this.bindComponent((Widget)this.btnHardBuildings, XplaneOptionsHelper.getOptions(), "hardBuildings");
    }

    @Override
    protected void addComponentsListeners() {
    }
}

