/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.xplane;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.components.FacadesExclusionsTable;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class FacadesExclusionsPanel
extends Composite {
    final FacadesExclusionsTable facadesExclusionsTable;
    private static final String[] FILTER_NAMES = new String[]{"XML exclusions file (*.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xml"};

    public FacadesExclusionsPanel(final Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar((Composite)this, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ToolItem tltmAdd = new ToolItem(toolBar, 0);
        tltmAdd.setToolTipText("add");
        tltmAdd.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XplaneOptionsHelper.getOptions().getBuildingsExclusions().getExclusions().add(new OsmTag("a key", "a value"));
                FacadesExclusionsPanel.this.facadesExclusionsTable.getViewer().refresh();
            }
        });
        ToolItem tltmDelete = new ToolItem(toolBar, 0);
        tltmDelete.setToolTipText("delete");
        tltmDelete.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FacadesExclusionsPanel.this.facadesExclusionsTable.getViewer().getSelection();
                OsmTag selectedTag = (OsmTag)selection.getFirstElement();
                XplaneOptionsHelper.getOptions().getBuildingsExclusions().getExclusions().remove(selectedTag);
                FacadesExclusionsPanel.this.facadesExclusionsTable.getViewer().refresh();
            }
        });
        ToolItem tltmSeparator = new ToolItem(toolBar, 2);
        tltmSeparator.setWidth(20);
        ToolItem tltmExport = new ToolItem(toolBar, 0);
        tltmExport.setToolTipText("Export");
        tltmExport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/export_16.ico"));
        tltmExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 8192);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    try {
                        XmlHelper.saveToXml(XplaneOptionsHelper.getOptions().getBuildingsExclusions(), new File(fn));
                    }
                    catch (Osm2xpException e1) {
                        Osm2xpLogger.error("Error saving exclusions rules to file" + new File(fn).getName(), e1);
                    }
                }
            }
        });
        ToolItem tltmImport = new ToolItem(toolBar, 0);
        tltmImport.setToolTipText("Import");
        tltmImport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/import_16.ico"));
        tltmImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    XplaneOptionsHelper.importExclusions(new File(fn));
                    FacadesExclusionsPanel.this.facadesExclusionsTable.updateImportedExclusionsTags();
                }
            }
        });
        Group groupTable = new Group((Composite)this, 0);
        groupTable.setText("Osm Tags exclusions");
        GridData gd_composite = new GridData(4, 0x1000000, false, true, 1, 1);
        gd_composite.widthHint = 523;
        groupTable.setLayoutData((Object)gd_composite);
        groupTable.setLayout((Layout)new FillLayout(256));
        this.facadesExclusionsTable = new FacadesExclusionsTable((Composite)groupTable, 0);
        this.facadesExclusionsTable.setLayout((Layout)new FillLayout(256));
    }
}

