/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.xplane;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.components.FilesPathsTable;
import com.osm2xp.gui.components.TagsRulesTable;
import com.osm2xp.gui.views.panels.Osm2xpPanel;
import com.osm2xp.model.options.FacadeTagRule;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class FacadesRulesPanel
extends Osm2xpPanel {
    final TagsRulesTable tagsTable;
    final FilesPathsTable facadesFilesTable;
    final Group grpFiles;
    final Group grpSize;
    private static final String[] FILTER_NAMES = new String[]{"XML facades rules file (*.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xml"};
    private FacadeTagRule selectedFacadeTagRule;
    private Spinner spinnerMinSize;
    private Spinner spinnerMaxSize;
    private Composite compositeRuleDetail;
    private ToolBar toolBar;
    private ToolItem tltmAdd;
    private ToolItem tltmDelete;
    private ToolItem tltmSeparator;
    private ToolItem tltmExport;
    private ToolItem tltmImport;

    public FacadesRulesPanel(Composite parent, int style) {
        super(parent, style);
        new Label((Composite)this, 0);
        Group groupTags = new Group((Composite)this, 0);
        groupTags.setText("facades rules - osm tags ");
        GridData gridData = new GridData(4, 128, false, false, 1, 1);
        gridData.heightHint = 320;
        gridData.widthHint = 329;
        groupTags.setLayoutData((Object)gridData);
        groupTags.setLayout((Layout)new FillLayout(256));
        this.tagsTable = new TagsRulesTable((Composite)groupTags, 0, XplaneOptionsHelper.getOptions().getFacadesRules().getRules());
        this.tagsTable.setLayout((Layout)new FillLayout(256));
        this.tagsTable.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FacadesRulesPanel.this.selectedFacadeTagRule = (FacadeTagRule)event.item.getData();
                String selectedTag = String.valueOf(FacadesRulesPanel.this.selectedFacadeTagRule.getTag().getKey()) + "=" + FacadesRulesPanel.this.selectedFacadeTagRule.getTag().getValue();
                FacadesRulesPanel.this.grpFiles.setText(MessageFormat.format("Facades files for tag ({0})", selectedTag));
                FacadesRulesPanel.this.grpSize.setText(MessageFormat.format("Height for tag ({0})", selectedTag));
                FacadesRulesPanel.this.spinnerMinSize.setSelection(FacadesRulesPanel.this.selectedFacadeTagRule.getSizeMin());
                FacadesRulesPanel.this.spinnerMaxSize.setSelection(FacadesRulesPanel.this.selectedFacadeTagRule.getSizeMax());
                try {
                    FacadesRulesPanel.this.facadesFilesTable.updateSelectedRule(FacadesRulesPanel.this.selectedFacadeTagRule.getObjectsFiles());
                }
                catch (Osm2xpException e) {
                    Osm2xpLogger.error("Error updating rules table.", e);
                }
                FacadesRulesPanel.this.compositeRuleDetail.setVisible(true);
            }
        });
        this.compositeRuleDetail = new Composite((Composite)this, 0);
        this.compositeRuleDetail.setVisible(false);
        this.compositeRuleDetail.setLayout((Layout)new GridLayout(1, false));
        GridData gridDataFacadesObjects = new GridData(4, 128, true, false, 1, 1);
        gridDataFacadesObjects.heightHint = 347;
        gridDataFacadesObjects.widthHint = 608;
        this.compositeRuleDetail.setLayoutData((Object)gridDataFacadesObjects);
        this.grpSize = new Group(this.compositeRuleDetail, 0);
        GridData gridDataSize = new GridData(16384, 128, true, false, 1, 1);
        this.grpSize.setLayoutData((Object)gridDataSize);
        this.grpSize.setLayout((Layout)new GridLayout(6, false));
        Label lblMinSize = new Label((Composite)this.grpSize, 0);
        lblMinSize.setBounds(0, 0, 53, 13);
        lblMinSize.setText("Min : ");
        this.spinnerMinSize = new Spinner((Composite)this.grpSize, 2048);
        this.spinnerMinSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FacadesRulesPanel.this.selectedFacadeTagRule.setSizeMin(FacadesRulesPanel.this.spinnerMinSize.getSelection());
            }
        });
        new Label((Composite)this.grpSize, 0);
        new Label((Composite)this.grpSize, 0);
        Label lblMaxSize = new Label((Composite)this.grpSize, 0);
        lblMaxSize.setBounds(0, 0, 53, 13);
        lblMaxSize.setText("Max : ");
        this.spinnerMaxSize = new Spinner((Composite)this.grpSize, 2048);
        this.spinnerMaxSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.spinnerMaxSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FacadesRulesPanel.this.selectedFacadeTagRule.setSizeMax(FacadesRulesPanel.this.spinnerMaxSize.getSelection());
            }
        });
        this.grpFiles = new Group(this.compositeRuleDetail, 0);
        GridData gd_grpFiles = new GridData(16384, 1024, true, false, 1, 1);
        gd_grpFiles.heightHint = 261;
        this.grpFiles.setLayoutData((Object)gd_grpFiles);
        this.grpFiles.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBarFacadeFiles = new ToolBar((Composite)this.grpFiles, 0x820000);
        ToolItem tltmAddFacadeFile = new ToolItem(toolBarFacadeFiles, 0);
        tltmAddFacadeFile.setToolTipText("add");
        tltmAddFacadeFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAddFacadeFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFile file = new ObjectFile();
                file.setPath("SomePathTo" + File.separator + "aFacadeFile.fac");
                FacadesRulesPanel.this.selectedFacadeTagRule.getObjectsFiles().add(file);
                FacadesRulesPanel.this.facadesFilesTable.getViewer().refresh();
            }
        });
        ToolItem tltmDeleteFacadeFile = new ToolItem(toolBarFacadeFiles, 0);
        tltmDeleteFacadeFile.setToolTipText("delete");
        tltmDeleteFacadeFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDeleteFacadeFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FacadesRulesPanel.this.facadesFilesTable.getViewer().getSelection();
                ObjectFile selectedFile = (ObjectFile)selection.getFirstElement();
                FacadesRulesPanel.this.selectedFacadeTagRule.getObjectsFiles().remove(selectedFile);
                FacadesRulesPanel.this.facadesFilesTable.getViewer().refresh();
            }
        });
        this.facadesFilesTable = new FilesPathsTable((Composite)this.grpFiles, 0, "Facade path");
        this.facadesFilesTable.setLayout((Layout)new FillLayout(256));
        new Label((Composite)this.grpFiles, 0);
    }

    @Override
    protected void initLayout() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
    }

    @Override
    protected void initComponents() {
        this.toolBar = new ToolBar((Composite)this, 0x820000);
        this.tltmAdd = new ToolItem(this.toolBar, 0);
        this.tltmAdd.setToolTipText("add");
        this.tltmAdd.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        this.tltmDelete = new ToolItem(this.toolBar, 0);
        this.tltmDelete.setToolTipText("delete");
        this.tltmDelete.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        this.tltmSeparator = new ToolItem(this.toolBar, 2);
        this.tltmSeparator.setWidth(20);
        this.tltmExport = new ToolItem(this.toolBar, 0);
        this.tltmExport.setToolTipText("Export");
        this.tltmExport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/export_16.ico"));
        this.tltmImport = new ToolItem(this.toolBar, 0);
        this.tltmImport.setToolTipText("Import");
        this.tltmImport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/import_16.ico"));
    }

    @Override
    protected void bindComponents() {
        this.tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XplaneOptionsHelper.getOptions().getFacadesRules().getRules().add(new FacadeTagRule(new OsmTag("a tag key", "a tag value"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
                    {
                        this.add(new ObjectFile("the path to an Object file"));
                    }
                }, 10, 40));
                FacadesRulesPanel.this.tagsTable.getViewer().refresh();
            }
        });
        this.tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FacadesRulesPanel.this.tagsTable.getViewer().getSelection();
                FacadeTagRule selectedFacadeTagRule = (FacadeTagRule)selection.getFirstElement();
                XplaneOptionsHelper.getOptions().getFacadesRules().getRules().remove(selectedFacadeTagRule);
                FacadesRulesPanel.this.compositeRuleDetail.setVisible(false);
                FacadesRulesPanel.this.tagsTable.getViewer().refresh();
            }
        });
    }

    @Override
    protected void addComponentsListeners() {
        this.tltmExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(FacadesRulesPanel.this.getParent().getShell(), 8192);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    try {
                        XmlHelper.saveToXml(XplaneOptionsHelper.getOptions().getFacadesRules(), new File(fn));
                    }
                    catch (Osm2xpException e1) {
                        Osm2xpLogger.error("Error saving facades rules to file" + new File(fn).getName(), e1);
                    }
                }
            }
        });
        this.tltmImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(FacadesRulesPanel.this.getParent().getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    XplaneOptionsHelper.importFacadesRules(new File(fn));
                    FacadesRulesPanel.this.tagsTable.updateInput(XplaneOptionsHelper.getOptions().getFacadesRules().getRules());
                }
            }
        });
    }
}

