/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.xplane;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.components.FilesPathsTable;
import com.osm2xp.gui.components.TagsRulesTable;
import com.osm2xp.model.options.ForestTagRule;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class ForestsRulesPanel
extends Composite {
    final TagsRulesTable tagsTable;
    final FilesPathsTable ForestsFilesTable;
    final Group grpForestsFilesFor;
    final Group grpDensity;
    private static final String[] FILTER_NAMES = new String[]{"XML Forests rules file (*.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xml"};
    private ForestTagRule selectedForestTagRule;
    private Spinner spinnerForestDensity;
    private Composite compositeRuleDetail;

    public ForestsRulesPanel(final Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        ToolBar toolBar = new ToolBar((Composite)this, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ToolItem tltmAdd = new ToolItem(toolBar, 0);
        tltmAdd.setToolTipText("add");
        tltmAdd.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XplaneOptionsHelper.getOptions().getForestsRules().getRules().add(new ForestTagRule(new OsmTag("a tag key", "a value"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
                    {
                        this.add(new ObjectFile("path to a forest file"));
                    }
                }, 255));
            }
        });
        ToolItem tltmDelete = new ToolItem(toolBar, 0);
        tltmDelete.setToolTipText("delete");
        tltmDelete.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ForestsRulesPanel.this.tagsTable.getViewer().getSelection();
                ForestTagRule selectedForestTagRule = (ForestTagRule)selection.getFirstElement();
                XplaneOptionsHelper.getOptions().getForestsRules().getRules().remove(selectedForestTagRule);
                ForestsRulesPanel.this.compositeRuleDetail.setVisible(true);
                ForestsRulesPanel.this.tagsTable.getViewer().refresh();
            }
        });
        ToolItem tltmSeparator = new ToolItem(toolBar, 2);
        tltmSeparator.setWidth(20);
        ToolItem tltmExport = new ToolItem(toolBar, 0);
        tltmExport.setToolTipText("Export");
        tltmExport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/export_16.ico"));
        tltmExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 8192);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    try {
                        XmlHelper.saveToXml(XplaneOptionsHelper.getOptions().getForestsRules(), new File(fn));
                    }
                    catch (Osm2xpException e1) {
                        Osm2xpLogger.error("Error exporting forests rules to " + new File(fn).getName(), e1);
                    }
                }
            }
        });
        ToolItem tltmImport = new ToolItem(toolBar, 0);
        tltmImport.setToolTipText("Import");
        tltmImport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/import_16.ico"));
        tltmImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    XplaneOptionsHelper.importForestsRules(new File(fn));
                    ForestsRulesPanel.this.tagsTable.updateInput(XplaneOptionsHelper.getOptions().getForestsRules().getRules());
                }
            }
        });
        new Label((Composite)this, 0);
        Group groupTags = new Group((Composite)this, 0);
        groupTags.setText("Forests rules - osm tags ");
        GridData gridData = new GridData(4, 128, false, false, 1, 1);
        gridData.heightHint = 320;
        gridData.widthHint = 329;
        groupTags.setLayoutData((Object)gridData);
        groupTags.setLayout((Layout)new FillLayout(256));
        this.tagsTable = new TagsRulesTable((Composite)groupTags, 0, XplaneOptionsHelper.getOptions().getForestsRules().getRules());
        this.tagsTable.setLayout((Layout)new FillLayout(256));
        this.tagsTable.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ForestsRulesPanel.this.selectedForestTagRule = (ForestTagRule)event.item.getData();
                String selectedTag = String.valueOf(ForestsRulesPanel.this.selectedForestTagRule.getTag().getKey()) + "=" + ForestsRulesPanel.this.selectedForestTagRule.getTag().getValue();
                ForestsRulesPanel.this.grpForestsFilesFor.setText("Forests files for tag (" + selectedTag + ")");
                ForestsRulesPanel.this.grpDensity.setText("Forest density for tag (" + selectedTag + ")");
                ForestsRulesPanel.this.spinnerForestDensity.setSelection(ForestsRulesPanel.this.selectedForestTagRule.getForestDensity());
                try {
                    ForestsRulesPanel.this.ForestsFilesTable.updateSelectedRule(ForestsRulesPanel.this.selectedForestTagRule.getObjectsFiles());
                }
                catch (Osm2xpException e) {
                    Osm2xpLogger.error("Error updating rules table", e);
                }
                ForestsRulesPanel.this.compositeRuleDetail.setVisible(true);
            }
        });
        this.compositeRuleDetail = new Composite((Composite)this, 0);
        this.compositeRuleDetail.setVisible(false);
        this.compositeRuleDetail.setLayout((Layout)new GridLayout(1, false));
        GridData gridDataForestsObjects = new GridData(4, 128, false, false, 1, 1);
        gridDataForestsObjects.heightHint = 347;
        gridDataForestsObjects.widthHint = 608;
        this.compositeRuleDetail.setLayoutData((Object)gridDataForestsObjects);
        this.grpDensity = new Group(this.compositeRuleDetail, 0);
        this.grpDensity.setLayout((Layout)new GridLayout(2, false));
        GridData gd_grpDensity = new GridData(4, 1024, true, false, 1, 1);
        gd_grpDensity.widthHint = 368;
        this.grpDensity.setLayoutData((Object)gd_grpDensity);
        this.grpDensity.setText("Density ");
        Label lblDensity = new Label((Composite)this.grpDensity, 0);
        lblDensity.setText("Density : ");
        this.spinnerForestDensity = new Spinner((Composite)this.grpDensity, 2048);
        this.spinnerForestDensity.setMaximum(255);
        this.spinnerForestDensity.setMinimum(0);
        this.spinnerForestDensity.setToolTipText("maximum forest density 255");
        this.spinnerForestDensity.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ForestsRulesPanel.this.selectedForestTagRule.setForestDensity(ForestsRulesPanel.this.spinnerForestDensity.getSelection());
            }
        });
        this.grpForestsFilesFor = new Group(this.compositeRuleDetail, 0);
        GridData gd_grpForestsFilesFor = new GridData(4, 1024, true, false, 1, 1);
        gd_grpForestsFilesFor.heightHint = 261;
        this.grpForestsFilesFor.setLayoutData((Object)gd_grpForestsFilesFor);
        this.grpForestsFilesFor.setText("Forests files for xxx");
        this.grpForestsFilesFor.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBarForestFiles = new ToolBar((Composite)this.grpForestsFilesFor, 0x820000);
        ToolItem tltmAddForestFile = new ToolItem(toolBarForestFiles, 0);
        tltmAddForestFile.setToolTipText("add");
        tltmAddForestFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAddForestFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFile file = new ObjectFile();
                file.setPath("SomePathTo" + File.separator + "aForestFile.fac");
                ForestsRulesPanel.this.selectedForestTagRule.getObjectsFiles().add(file);
                ForestsRulesPanel.this.ForestsFilesTable.getViewer().refresh();
            }
        });
        ToolItem tltmDeleteForestFile = new ToolItem(toolBarForestFiles, 0);
        tltmDeleteForestFile.setToolTipText("delete");
        tltmDeleteForestFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDeleteForestFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ForestsRulesPanel.this.ForestsFilesTable.getViewer().getSelection();
                ObjectFile selectedFile = (ObjectFile)selection.getFirstElement();
                ForestsRulesPanel.this.selectedForestTagRule.getObjectsFiles().remove(selectedFile);
                ForestsRulesPanel.this.ForestsFilesTable.getViewer().refresh();
            }
        });
        this.ForestsFilesTable = new FilesPathsTable((Composite)this.grpForestsFilesFor, 0, "Forest file path");
        this.ForestsFilesTable.setLayout((Layout)new FillLayout(256));
        new Label((Composite)this.grpForestsFilesFor, 0);
    }
}

