/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.xplane;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.components.FilesPathsTable;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class StreetLightsPanel
extends Composite {
    final FilesPathsTable filesPathsTable;
    private static final String[] FILTER_NAMES = new String[]{"XML street lights objects file (*.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xml"};

    public StreetLightsPanel(final Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar((Composite)this, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ToolItem tltmAdd = new ToolItem(toolBar, 0);
        tltmAdd.setToolTipText("add");
        tltmAdd.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XplaneOptionsHelper.getOptions().getStreetLightObjects().getObjects().add(new ObjectFile("path to a light object..."));
                StreetLightsPanel.this.filesPathsTable.getViewer().refresh();
            }
        });
        ToolItem tltmDelete = new ToolItem(toolBar, 0);
        tltmDelete.setToolTipText("delete");
        tltmDelete.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)StreetLightsPanel.this.filesPathsTable.getViewer().getSelection();
                ObjectFile selectedFile = (ObjectFile)selection.getFirstElement();
                XplaneOptionsHelper.getOptions().getStreetLightObjects().getObjects().remove(selectedFile);
                StreetLightsPanel.this.filesPathsTable.getViewer().refresh();
            }
        });
        ToolItem tltmSeparator = new ToolItem(toolBar, 2);
        tltmSeparator.setWidth(20);
        ToolItem tltmExport = new ToolItem(toolBar, 0);
        tltmExport.setToolTipText("Export");
        tltmExport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/export_16.ico"));
        tltmExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 8192);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    try {
                        XmlHelper.saveToXml(XplaneOptionsHelper.getOptions().getStreetLightObjects(), new File(fn));
                    }
                    catch (Osm2xpException e1) {
                        Osm2xpLogger.error("Error saving rules to xml file " + new File(fn).getName(), e1);
                    }
                }
            }
        });
        ToolItem tltmImport = new ToolItem(toolBar, 0);
        tltmImport.setToolTipText("Import");
        tltmImport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/import_16.ico"));
        tltmImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    XplaneOptionsHelper.importStreetLightObjects(new File(fn));
                    try {
                        StreetLightsPanel.this.filesPathsTable.updateSelectedRule(XplaneOptionsHelper.getOptions().getStreetLightObjects().getObjects());
                    }
                    catch (Osm2xpException e1) {
                        Osm2xpLogger.error("Error exporting rules table", e1);
                    }
                }
            }
        });
        Group groupTable = new Group((Composite)this, 0);
        groupTable.setText("Street Lights objects");
        GridData gd_composite = new GridData(4, 0x1000000, false, true, 1, 1);
        gd_composite.widthHint = 523;
        groupTable.setLayoutData((Object)gd_composite);
        groupTable.setLayout((Layout)new FillLayout(256));
        this.filesPathsTable = new FilesPathsTable((Composite)groupTable, 0, "StreetLight object path");
        this.filesPathsTable.setLayout((Layout)new FillLayout(256));
        try {
            this.filesPathsTable.updateSelectedRule(XplaneOptionsHelper.getOptions().getStreetLightObjects().getObjects());
        }
        catch (Osm2xpException e1) {
            Osm2xpLogger.error("Error exporting rules table", e1);
        }
    }
}

