/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.gui.views.panels.xplane;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.gui.components.FilesPathsTable;
import com.osm2xp.gui.components.TagsRulesTable;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class XplaneObjectsRulesPanel
extends Composite {
    final TagsRulesTable tagsTable;
    final FilesPathsTable ObjectsFilesTable;
    final Group grpFiles;
    final Group grpAngle;
    private static final String[] FILTER_NAMES = new String[]{"XML objects rules file (*.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xml"};
    private ObjectTagRule selectedObjectTagRule;
    private Spinner spinnerAngle;
    private Composite compositeRuleDetail;
    private Button btnCheckRandomAngle;

    public XplaneObjectsRulesPanel(final Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        ToolBar toolBar = new ToolBar((Composite)this, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ToolItem tltmAdd = new ToolItem(toolBar, 0);
        tltmAdd.setToolTipText("add");
        tltmAdd.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XplaneOptionsHelper.getOptions().getObjectsRules().getRules().add(new ObjectTagRule(new OsmTag("a tag key", "a tag value"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
                    {
                        this.add(new ObjectFile("the path to an Object file"));
                    }
                }, 0, true));
                XplaneObjectsRulesPanel.this.tagsTable.getViewer().refresh();
            }
        });
        ToolItem tltmDelete = new ToolItem(toolBar, 0);
        tltmDelete.setToolTipText("delete");
        tltmDelete.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)XplaneObjectsRulesPanel.this.tagsTable.getViewer().getSelection();
                ObjectTagRule selectedObjectTagRule = (ObjectTagRule)selection.getFirstElement();
                XplaneOptionsHelper.getOptions().getObjectsRules().getRules().remove(selectedObjectTagRule);
                XplaneObjectsRulesPanel.this.compositeRuleDetail.setVisible(false);
                XplaneObjectsRulesPanel.this.tagsTable.getViewer().refresh();
            }
        });
        ToolItem tltmSeparator = new ToolItem(toolBar, 2);
        tltmSeparator.setWidth(20);
        ToolItem tltmExport = new ToolItem(toolBar, 0);
        tltmExport.setToolTipText("Export");
        tltmExport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/export_16.ico"));
        tltmExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 8192);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    try {
                        XmlHelper.saveToXml(XplaneOptionsHelper.getOptions().getObjectsRules(), new File(fn));
                    }
                    catch (Osm2xpException e1) {
                        Osm2xpLogger.error("Error saving rules to xml file " + new File(fn).getName(), e1);
                    }
                }
            }
        });
        ToolItem tltmImport = new ToolItem(toolBar, 0);
        tltmImport.setToolTipText("Import");
        tltmImport.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/import_16.ico"));
        tltmImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell(), 4096);
                dlg.setFilterNames(FILTER_NAMES);
                dlg.setFilterExtensions(FILTER_EXTS);
                String fn = dlg.open();
                if (fn != null) {
                    XplaneOptionsHelper.importObjectsRules(new File(fn));
                    XplaneObjectsRulesPanel.this.tagsTable.updateInput(XplaneOptionsHelper.getOptions().getObjectsRules().getRules());
                }
            }
        });
        new Label((Composite)this, 0);
        Group groupTags = new Group((Composite)this, 0);
        groupTags.setText("Objects rules - osm tags ");
        GridData gridData = new GridData(4, 128, false, false, 1, 1);
        gridData.heightHint = 320;
        gridData.widthHint = 329;
        groupTags.setLayoutData((Object)gridData);
        groupTags.setLayout((Layout)new FillLayout(256));
        this.tagsTable = new TagsRulesTable((Composite)groupTags, 0, XplaneOptionsHelper.getOptions().getObjectsRules().getRules());
        this.tagsTable.setLayout((Layout)new FillLayout(256));
        this.tagsTable.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XplaneObjectsRulesPanel.this.selectedObjectTagRule = (ObjectTagRule)event.item.getData();
                String selectedTag = String.valueOf(XplaneObjectsRulesPanel.this.selectedObjectTagRule.getTag().getKey()) + "=" + XplaneObjectsRulesPanel.this.selectedObjectTagRule.getTag().getValue();
                XplaneObjectsRulesPanel.this.grpFiles.setText(MessageFormat.format("Objects files for tag ({0})", selectedTag));
                XplaneObjectsRulesPanel.this.grpAngle.setText(MessageFormat.format("Angle for tag ({0})", selectedTag));
                XplaneObjectsRulesPanel.this.spinnerAngle.setSelection(XplaneObjectsRulesPanel.this.selectedObjectTagRule.getAngle());
                XplaneObjectsRulesPanel.this.btnCheckRandomAngle.setSelection(XplaneObjectsRulesPanel.this.selectedObjectTagRule.isRandomAngle());
                try {
                    XplaneObjectsRulesPanel.this.ObjectsFilesTable.updateSelectedRule(XplaneObjectsRulesPanel.this.selectedObjectTagRule.getObjectsFiles());
                }
                catch (Osm2xpException e) {
                    Osm2xpLogger.error("Error updating rules table", e);
                }
                XplaneObjectsRulesPanel.this.compositeRuleDetail.setVisible(true);
            }
        });
        this.compositeRuleDetail = new Composite((Composite)this, 0);
        this.compositeRuleDetail.setVisible(false);
        this.compositeRuleDetail.setLayout((Layout)new GridLayout(1, false));
        GridData gridDataObjectsObjects = new GridData(4, 128, false, false, 1, 1);
        gridDataObjectsObjects.heightHint = 347;
        gridDataObjectsObjects.widthHint = 608;
        this.compositeRuleDetail.setLayoutData((Object)gridDataObjectsObjects);
        this.grpAngle = new Group(this.compositeRuleDetail, 0);
        GridData gd_grpAngle = new GridData(16384, 128, true, false, 1, 1);
        gd_grpAngle.heightHint = 28;
        this.grpAngle.setLayoutData((Object)gd_grpAngle);
        this.grpAngle.setLayout((Layout)new GridLayout(5, false));
        this.btnCheckRandomAngle = new Button((Composite)this.grpAngle, 32);
        this.btnCheckRandomAngle.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                XplaneObjectsRulesPanel.this.selectedObjectTagRule.setRandomAngle(!XplaneObjectsRulesPanel.this.btnCheckRandomAngle.getSelection());
            }
        });
        this.btnCheckRandomAngle.setText("Random angle");
        new Label((Composite)this.grpAngle, 0);
        Label lblAngle = new Label((Composite)this.grpAngle, 0);
        lblAngle.setBounds(0, 0, 20, 13);
        lblAngle.setText("Angle :");
        this.spinnerAngle = new Spinner((Composite)this.grpAngle, 2048);
        this.spinnerAngle.setMaximum(360);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        new Label((Composite)this.grpAngle, 0);
        this.spinnerAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XplaneObjectsRulesPanel.this.selectedObjectTagRule.setAngle(XplaneObjectsRulesPanel.this.spinnerAngle.getSelection());
            }
        });
        this.grpFiles = new Group(this.compositeRuleDetail, 0);
        GridData gd_grpFiles = new GridData(16384, 1024, true, false, 1, 1);
        gd_grpFiles.heightHint = 264;
        this.grpFiles.setLayoutData((Object)gd_grpFiles);
        this.grpFiles.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBarObjectFiles = new ToolBar((Composite)this.grpFiles, 0x820000);
        ToolItem tltmAddObjectFile = new ToolItem(toolBarObjectFiles, 0);
        tltmAddObjectFile.setToolTipText("add");
        tltmAddObjectFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/add_16.ico"));
        tltmAddObjectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFile file = new ObjectFile();
                file.setPath("SomePathTo" + File.separator + "aObjectFile.fac");
                XplaneObjectsRulesPanel.this.selectedObjectTagRule.getObjectsFiles().add(file);
                XplaneObjectsRulesPanel.this.ObjectsFilesTable.getViewer().refresh();
            }
        });
        ToolItem tltmDeleteObjectFile = new ToolItem(toolBarObjectFiles, 0);
        tltmDeleteObjectFile.setToolTipText("delete");
        tltmDeleteObjectFile.setImage(ResourceManager.getPluginImage("com.osm2xp", "images/toolbarsIcons/delete_16.ico"));
        tltmDeleteObjectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)XplaneObjectsRulesPanel.this.ObjectsFilesTable.getViewer().getSelection();
                ObjectFile selectedFile = (ObjectFile)selection.getFirstElement();
                XplaneObjectsRulesPanel.this.selectedObjectTagRule.getObjectsFiles().remove(selectedFile);
                XplaneObjectsRulesPanel.this.ObjectsFilesTable.getViewer().refresh();
            }
        });
        this.ObjectsFilesTable = new FilesPathsTable((Composite)this.grpFiles, 0, "Object file path");
        this.ObjectsFilesTable.setLayout((Layout)new FillLayout(256));
        new Label((Composite)this.grpFiles, 0);
    }
}

