/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.jobs;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.parsers.IParser;
import com.osm2xp.parsers.ParserBuilder;
import com.osm2xp.utils.helpers.Osm2xpProjectHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.List;
import math.geom2d.Point2D;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class GenerateTileJob
extends Job {
    private transient Point2D coordinates;
    private transient File currentFile;
    private transient String folderPath;
    private transient List<Relation> relationsList;
    private String familly;

    public GenerateTileJob(String name, File currentFile, Point2D coordinates, String folderPath, List<Relation> relationsList, String familly) {
        super(name);
        this.coordinates = coordinates;
        this.currentFile = currentFile;
        this.folderPath = folderPath;
        this.relationsList = relationsList;
        this.familly = familly;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IParser parser = ParserBuilder.getParser(this.coordinates, this.currentFile, this.folderPath, this.relationsList);
            parser.process();
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error creating file parser.\n" + e.getMessage());
        }
        try {
            Osm2xpProjectHelper.removeTile(this.coordinates);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error updating project file.", e);
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return this.familly.equals(family);
    }

    public String getFamilly() {
        return this.familly;
    }

    public void setFamilly(String familly) {
        this.familly = familly;
    }
}

