/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.model.fsx;

import com.osm2xp.model.geom.Lod13Location;
import com.osm2xp.model.osm.Node;
import com.osm2xp.utils.GeomUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import math.geom3d.Vector3D;

public class FsxObject {
    private String guid;
    private String type;
    private ArrayList<Lod13Location> lod13Locations;

    public FsxObject(String guid, String type, List<Node> nodes) {
        this.guid = guid;
        this.type = type;
        this.lod13Locations = new ArrayList();
        for (Node node : nodes) {
            Lod13Location location = GeomUtils.getLod13Location(node.getLat(), node.getLon());
            this.lod13Locations.add(location);
        }
    }

    public boolean isOnASingleLod13Square() {
        if (!this.lod13Locations.isEmpty()) {
            Lod13Location base = this.lod13Locations.get(0);
            for (Lod13Location location : this.lod13Locations) {
                if (location.getLod13String().equalsIgnoreCase(base.getLod13String())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.type.equals("AGNGenericBuilding")) {
            return this.getSquareBuildingText();
        }
        if (this.type.equals("AGNPolyVegetation")) {
            return this.getForestText();
        }
        if (this.type.equals("AGNPolyBuilding")) {
            return this.getPolylineBuildingText();
        }
        return null;
    }

    public String getPolylineBuildingText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(this.type) + " ");
        stringBuilder.append("{" + this.guid + "} ");
        stringBuilder.append("-0.1 ");
        for (Lod13Location location : this.lod13Locations) {
            DecimalFormat formatter = new DecimalFormat("#.################");
            stringBuilder.append((String.valueOf(formatter.format(location.getxOffset())) + " " + formatter.format(location.getyOffset()) + " ").replaceAll(",", "."));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String getForestText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(this.type) + " ");
        stringBuilder.append("{" + this.guid + "} ");
        for (Lod13Location location : this.lod13Locations) {
            new DecimalFormat("#.################");
            NumberFormat formatter = NumberFormat.getInstance(Locale.getDefault());
            String xOffset = formatter.format((Object)location.getxOffset());
            String yOffset = formatter.format((Object)location.getyOffset());
            stringBuilder.append(String.valueOf(xOffset) + " " + yOffset + " ");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String getSquareBuildingText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(this.type) + " ");
        stringBuilder.append("{" + this.guid + "} ");
        DecimalFormat formatter = new DecimalFormat("#.################");
        Lod13Location location = this.lod13Locations.get(0);
        stringBuilder.append((String.valueOf(formatter.format(location.getxOffset())) + " " + formatter.format(location.getyOffset()) + " ").replaceAll(",", "."));
        stringBuilder.append(String.valueOf(formatter.format(location.getxOffset() - this.lod13Locations.get(1).getxOffset())) + " " + formatter.format(location.getyOffset() - this.lod13Locations.get(1).getyOffset()) + " ");
        stringBuilder.append((String.valueOf(formatter.format(this.lod13Locations.get(2).getxOffset())) + " " + formatter.format(this.lod13Locations.get(2).getyOffset()) + " ").replaceAll(",", "."));
        stringBuilder.append("\n");
        return stringBuilder.toString().replaceAll(",", ".");
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ArrayList<Lod13Location> getLod13Locations() {
        return this.lod13Locations;
    }

    public void setLod13Locations(ArrayList<Lod13Location> lod13Locations) {
        this.lod13Locations = lod13Locations;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public class AGNGenericBuilding {
        public Vector3D direction;
        public Vector3D offset;
        public Vector3D position;

        public AGNGenericBuilding(ArrayList<Lod13Location> lod13Locations) {
            this.position = new Vector3D(lod13Locations.get(1).getxOffset(), lod13Locations.get(1).getyOffset(), 0.0);
            this.direction = new Vector3D(lod13Locations.get(2).getxOffset(), lod13Locations.get(2).getyOffset(), 0.0);
            this.offset = new Vector3D(lod13Locations.get(3).getxOffset(), lod13Locations.get(3).getyOffset(), 0.0);
        }

        public String toString() {
            return null;
        }
    }
}

