/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.parsers.IParser;
import com.osm2xp.parsers.impl.PbfParserImpl;
import com.osm2xp.parsers.impl.SaxParserImpl;
import com.osm2xp.parsers.impl.ShapefileParserImpl;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.translators.TranslatorBuilder;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import math.geom2d.Point2D;

public class ParserBuilder {
    public static IParser getParser(Point2D currentTile, File currentFile, String folderPath, List<Relation> relationsList) throws Osm2xpException {
        IParser parser = null;
        ITranslator translator = TranslatorBuilder.getTranslator(currentFile, currentTile, folderPath, relationsList);
        Map<Long, Color> roofsColorMap = null;
        if (GuiOptionsHelper.getRoofColorFile() != null) {
            roofsColorMap = FilesUtils.loadG2xplColorFile(GuiOptionsHelper.getRoofColorFile());
        }
        if (GuiOptionsHelper.getOptions().getCurrentFilePath().toLowerCase().contains(".pbf")) {
            parser = new PbfParserImpl();
            parser.init(currentFile, translator, roofsColorMap);
        } else if (GuiOptionsHelper.getOptions().getCurrentFilePath().toLowerCase().contains(".osm")) {
            parser = new SaxParserImpl();
            parser.init(currentFile, translator, roofsColorMap);
        } else if (GuiOptionsHelper.getOptions().getCurrentFilePath().toLowerCase().contains(".shp")) {
            parser = new ShapefileParserImpl();
            parser.init(currentFile, translator, roofsColorMap);
        }
        return parser;
    }
}

