/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.impl;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Osm;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Way;
import com.osm2xp.parsers.IParser;
import com.osm2xp.translators.ITranslator;
import java.awt.Color;
import java.io.File;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class JaxbParserImpl
implements IParser {
    private File osmFile;
    private ITranslator translator;

    @Override
    public void process() throws Osm2xpException {
        this.translator.init();
        Osm osm = this.loadOsmFile(this.osmFile);
        for (Node node : osm.getNode()) {
            this.translator.processNode(node);
        }
        for (Way way : osm.getWay()) {
            this.translator.processWay(way);
        }
        for (Relation relation : osm.getRelation()) {
            this.translator.processRelation(relation);
        }
        this.complete();
    }

    @Override
    public void complete() {
        this.translator.complete();
    }

    @Override
    public void init(File file, ITranslator translator, Map<Long, Color> roofsColorMap) {
        this.osmFile = file;
        this.translator = translator;
    }

    private Osm loadOsmFile(File osmFile) throws Osm2xpException {
        Osm result = new Osm();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Osm.class.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            result = (Osm)u.unmarshal(osmFile);
        }
        catch (JAXBException e) {
            throw new Osm2xpException(e.getMessage());
        }
        return result;
    }
}

