/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.impl;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Nd;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Tag;
import com.osm2xp.model.osm.Way;
import com.osm2xp.parsers.IParser;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.logging.Osm2xpLogger;
import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockInputStream;
import crosby.binary.file.BlockReaderAdapter;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PbfParserImpl
extends BinaryParser
implements IParser {
    private File binaryFile;
    private ITranslator translator;
    private Map<Long, Color> roofsColorMap;

    @Override
    public void init(File binaryFile, ITranslator translator, Map<Long, Color> roofsColorMap) {
        this.binaryFile = binaryFile;
        this.translator = translator;
        this.roofsColorMap = roofsColorMap;
    }

    @Override
    public void complete() {
        this.translator.complete();
    }

    protected void parseRelations(List<Osmformat.Relation> rels) {
    }

    protected void parseDense(Osmformat.DenseNodes nodes) {
        long lastId = 0L;
        long lastLat = 0L;
        long lastLon = 0L;
        int j = 0;
        Osmformat.DenseInfo di = null;
        if (nodes.hasDenseinfo()) {
            di = nodes.getDenseinfo();
        }
        int i = 0;
        while (i < nodes.getIdCount()) {
            long id;
            long lon;
            long lat;
            ArrayList<Tag> tags = new ArrayList<Tag>();
            lastLat = lat = nodes.getLat(i) + lastLat;
            lastLon = lon = nodes.getLon(i) + lastLon;
            lastId = id = nodes.getId(i) + lastId;
            double latf = this.parseLat(lat);
            double lonf = this.parseLon(lon);
            if (nodes.getKeysValsCount() > 0) {
                while (nodes.getKeysVals(j) != 0) {
                    int keyid = nodes.getKeysVals(j++);
                    int valid = nodes.getKeysVals(j++);
                    Tag tag = new Tag();
                    tag.setK(this.getStringById(keyid));
                    tag.setV(this.getStringById(valid));
                    tags.add(tag);
                }
                ++j;
            }
            if (di != null) {
                Node node = new Node();
                node.setId(id);
                node.setLat(latf);
                node.setLon(lonf);
                node.getTag().addAll(tags);
                try {
                    this.translator.processNode(node);
                }
                catch (Osm2xpException e) {
                    Osm2xpLogger.error("Error processing node.", e);
                }
            }
            ++i;
        }
    }

    protected void parseNodes(List<Osmformat.Node> nodes) {
    }

    protected void parseWays(List<Osmformat.Way> ways) {
        for (Osmformat.Way i : ways) {
            ArrayList<Tag> listeTags = new ArrayList<Tag>();
            int j = 0;
            while (j < i.getKeysCount()) {
                Tag tag = new Tag();
                tag.setK(this.getStringById(i.getKeys(j)));
                tag.setV(this.getStringById(i.getVals(j)));
                listeTags.add(tag);
                ++j;
            }
            long lastId = 0L;
            ArrayList<Nd> listeLocalisationsRef = new ArrayList<Nd>();
            Iterator iterator = i.getRefsList().iterator();
            while (iterator.hasNext()) {
                long j2 = (Long)iterator.next();
                Nd nd = new Nd();
                nd.setRef(j2 + lastId);
                listeLocalisationsRef.add(nd);
                lastId = j2 + lastId;
            }
            Way way = new Way();
            way.getTag().addAll(listeTags);
            way.setId(i.getId());
            way.getNd().addAll(listeLocalisationsRef);
            if (this.roofsColorMap != null && this.roofsColorMap.get(way.getId()) != null) {
                String hexColor = Integer.toHexString(this.roofsColorMap.get(way.getId()).getRGB() & 0xFFFFFF);
                Tag roofColorTag = new Tag("building:roof:color", hexColor);
                way.getTag().add(roofColorTag);
            }
            try {
                this.translator.processWay(way);
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error processing way.", e);
            }
        }
    }

    protected void parse(Osmformat.HeaderBlock header) {
    }

    @Override
    public void process() throws Osm2xpException {
        FileInputStream input;
        this.translator.init();
        try {
            input = new FileInputStream(this.binaryFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Osm2xpException("Error loading file " + this.binaryFile.getPath());
        }
        BlockInputStream bm = new BlockInputStream((InputStream)input, (BlockReaderAdapter)this);
        try {
            bm.process();
        }
        catch (IOException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }
}

