/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.impl;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Nd;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Tag;
import com.osm2xp.model.osm.Way;
import com.osm2xp.parsers.IParser;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxParserImpl
implements ContentHandler,
IParser {
    private static final String XML_ATTRIBUTE_LONGITUDE = "lon";
    private static final String XML_ATTRIBUTE_LATITUDE = "lat";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_REF = "ref";
    private static final String XML_NODE_ND = "nd";
    private static final String XML_NODE_TAG = "tag";
    private static final String XML_NODE_NODE = "node";
    private static final String XML_NODE_WAY = "way";
    protected Locator locator;
    protected List<Tag> tagList;
    protected OsmAttributes currentAttributes;
    protected List<Nd> ndList;
    private File xmlFile;
    private ITranslator translator;
    private Map<Long, Color> roofsColorMap;

    @Override
    public void init(File xmlFile, ITranslator translator, Map<Long, Color> roofsColorMap) {
        this.xmlFile = xmlFile;
        this.translator = translator;
        this.roofsColorMap = roofsColorMap;
    }

    public void parseDocument() throws SAXException, Osm2xpException {
        XMLReader saxReader = XMLReaderFactory.createXMLReader();
        saxReader.setContentHandler(this);
        try {
            saxReader.parse(this.xmlFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public void setDocumentLocator(Locator value) {
        this.locator = value;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.complete();
    }

    @Override
    public void startPrefixMapping(String prefix, String URI2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
        if (localName.equalsIgnoreCase(XML_NODE_WAY) || localName.equalsIgnoreCase(XML_NODE_NODE)) {
            this.tagList = new ArrayList<Tag>();
            this.ndList = new ArrayList<Nd>();
            this.currentAttributes = new OsmAttributes(attributs);
        } else if (localName.equalsIgnoreCase(XML_NODE_TAG)) {
            Tag tag = new Tag();
            tag.setK(attributs.getValue(0));
            tag.setV(attributs.getValue(1));
            this.tagList.add(tag);
        } else if (localName.equalsIgnoreCase(XML_NODE_ND)) {
            Nd nd = new Nd();
            nd.setRef(Long.parseLong(attributs.getValue(XML_ATTRIBUTE_REF)));
            this.ndList.add(nd);
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
        if (localName.equals(XML_NODE_WAY)) {
            try {
                this.parseWay();
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error parsing way object.", e);
            }
        } else if (localName.equals(XML_NODE_NODE)) {
            this.parseNode();
        }
    }

    private void parseWay() throws Osm2xpException {
        Way way = new Way();
        way.setId(Long.parseLong(this.currentAttributes.getValue(XML_ATTRIBUTE_ID)));
        way.getTag().addAll(this.tagList);
        way.getNd().addAll(this.ndList);
        if (this.roofsColorMap != null && this.roofsColorMap.get(way.getId()) != null) {
            String hexColor = Integer.toHexString(this.roofsColorMap.get(way.getId()).getRGB() & 0xFFFFFF);
            Tag roofColorTag = new Tag("#" + hexColor.toUpperCase(), "building:roof:color");
            way.getTag().add(roofColorTag);
        }
        this.translator.processWay(way);
    }

    private void parseNode() {
        Node node = new Node();
        node.setId(Long.parseLong(this.currentAttributes.getValue(XML_ATTRIBUTE_ID)));
        node.setLat(Double.parseDouble(this.currentAttributes.getValue(XML_ATTRIBUTE_LATITUDE)));
        node.setLon(Double.parseDouble(this.currentAttributes.getValue(XML_ATTRIBUTE_LONGITUDE)));
        node.getTag().addAll(this.tagList);
        try {
            this.translator.processNode(node);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error processing node.", e);
        }
    }

    @Override
    public void process() throws Osm2xpException {
        this.translator.init();
        try {
            this.parseDocument();
        }
        catch (Osm2xpException e) {
            throw new Osm2xpException("Osm parser error on line " + this.locator.getLineNumber() + " col " + this.locator.getColumnNumber() + "\n" + e.getMessage());
        }
        catch (SAXException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public void complete() {
        this.translator.complete();
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    private class OsmAttributes {
        private HashMap<String, String> values = new HashMap();

        public OsmAttributes(Attributes attributs) {
            int i = 0;
            while (i < attributs.getLength()) {
                this.values.put(attributs.getLocalName(i), attributs.getValue(i));
                ++i;
            }
        }

        public String getValue(String key) {
            return this.values.get(key);
        }
    }
}

