/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.impl;

import com.bbn.openmap.layer.shape.ESRIPoly;
import com.bbn.openmap.layer.shape.ESRIPolygonRecord;
import com.bbn.openmap.layer.shape.ShapeFile;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Nd;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Way;
import com.osm2xp.parsers.IParser;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ShapefileParserImpl
implements IParser {
    private ShapeFile shapeFile;
    private ITranslator translator;
    private int nodeIndex = 1;
    private int wayIndex = 1;

    @Override
    public void init(File file, ITranslator translator, Map<Long, Color> roofsColorMap) {
        try {
            this.shapeFile = new ShapeFile(file);
            this.translator = translator;
        }
        catch (IOException e) {
            Osm2xpLogger.error("Error loading shapefile file", e);
        }
    }

    @Override
    public void process() throws Osm2xpException {
        this.translator.init();
        try {
            ESRIPolygonRecord esriPolygonRecord = (ESRIPolygonRecord)this.shapeFile.getNextRecord();
            while (esriPolygonRecord != null) {
                ESRIPoly.ESRIFloatPoly poly = (ESRIPoly.ESRIFloatPoly)esriPolygonRecord.polygons[0];
                Way way = new Way();
                way.getTag().add(GuiOptionsHelper.getShapefileTag());
                way.setId(++this.wayIndex);
                int i = 0;
                while (i < poly.getRadians().length - 1) {
                    Node node = new Node(null, Math.toDegrees(poly.getRadians()[i]), Math.toDegrees(poly.getRadians()[i + 1]), this.nodeIndex);
                    way.getNd().add(new Nd(this.nodeIndex));
                    this.translator.processNode(node);
                    ++this.nodeIndex;
                    i += 2;
                }
                this.translator.processWay(way);
                esriPolygonRecord = (ESRIPolygonRecord)this.shapeFile.getNextRecord();
            }
            this.complete();
        }
        catch (IOException e) {
            throw new Osm2xpException("Error parsing shapeFile :" + e.getMessage());
        }
    }

    @Override
    public void complete() {
        this.translator.complete();
    }
}

