/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.relationsLister;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Member;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.parsers.relationsLister.RelationsLister;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlRelationsLister
implements ContentHandler,
RelationsLister {
    private List<Relation> relationsList = new ArrayList<Relation>();
    private File file;
    private Boolean parsingRelation = false;
    private Relation currentRelation;

    public XmlRelationsLister(File file) {
        this.file = file;
    }

    @Override
    public List<Relation> getRelationsList() {
        return this.relationsList;
    }

    public void parseDocument() throws Osm2xpException {
        XMLReader saxReader = null;
        try {
            saxReader = XMLReaderFactory.createXMLReader();
            saxReader.setContentHandler(this);
            saxReader.parse(this.file.getAbsolutePath());
        }
        catch (SAXException e) {
            throw new Osm2xpException(e.getMessage());
        }
        catch (IOException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
        if (localName.equalsIgnoreCase("relation")) {
            this.parsingRelation = true;
            this.currentRelation = new Relation();
        }
        if (this.parsingRelation.booleanValue() && localName.equalsIgnoreCase("member")) {
            Member member = new Member(attributs.getValue("type"), attributs.getValue("ref"), attributs.getValue("role"));
            this.currentRelation.getMember().add(member);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equalsIgnoreCase("relation")) {
            this.parsingRelation = false;
            this.relationsList.add(this.currentRelation);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void process() throws Osm2xpException {
        this.parseDocument();
    }

    public void complete() {
    }
}

