/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.tilesLister;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.parsers.tilesLister.TilesLister;
import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockInputStream;
import crosby.binary.file.BlockReaderAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import math.geom2d.Point2D;

public class PbfTilesLister
extends BinaryParser
implements TilesLister {
    private Set<Point2D> tilesList = new HashSet<Point2D>();
    private File file;

    public PbfTilesLister(File file) {
        this.file = file;
    }

    public void complete() {
    }

    protected void parseRelations(List<Osmformat.Relation> rels) {
    }

    protected void parseDense(Osmformat.DenseNodes nodes) {
        long lastId = 0L;
        long lastLat = 0L;
        long lastLon = 0L;
        int j = 0;
        Osmformat.DenseInfo di = null;
        if (nodes.hasDenseinfo()) {
            di = nodes.getDenseinfo();
        }
        int i = 0;
        while (i < nodes.getIdCount()) {
            long id;
            long lon;
            long lat;
            ArrayList<OsmTag> tags = new ArrayList<OsmTag>(0);
            lastLat = lat = nodes.getLat(i) + lastLat;
            lastLon = lon = nodes.getLon(i) + lastLon;
            lastId = id = nodes.getId(i) + lastId;
            double latf = this.parseLat(lat);
            double lonf = this.parseLon(lon);
            if (nodes.getKeysValsCount() > 0) {
                while (nodes.getKeysVals(j) != 0) {
                    int keyid = nodes.getKeysVals(j++);
                    int valid = nodes.getKeysVals(j++);
                    OsmTag osmTag = new OsmTag();
                    osmTag.setKey(this.getStringById(keyid));
                    osmTag.setValue(this.getStringById(valid));
                    tags.add(osmTag);
                }
                ++j;
            }
            if (di != null) {
                Point2D loc = new Point2D(latf, lonf);
                int lati = (int)Math.floor(loc.x);
                int longi = (int)Math.floor(loc.y);
                Point2D cleanedLoc = new Point2D((double)lati, (double)longi);
                this.tilesList.add(cleanedLoc);
            }
            ++i;
        }
    }

    protected void parseNodes(List<Osmformat.Node> nodes) {
    }

    protected void parseWays(List<Osmformat.Way> ways) {
    }

    protected void parse(Osmformat.HeaderBlock header) {
    }

    @Override
    public void process() throws Osm2xpException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new Osm2xpException(e.getMessage());
        }
        BlockInputStream bm = new BlockInputStream((InputStream)input, (BlockReaderAdapter)this);
        try {
            bm.process();
        }
        catch (IOException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public Set<Point2D> getTilesList() {
        return this.tilesList;
    }
}

