/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.tilesLister;

import com.bbn.openmap.layer.shape.ESRIPoly;
import com.bbn.openmap.layer.shape.ESRIPolygonRecord;
import com.bbn.openmap.layer.shape.ShapeFile;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Node;
import com.osm2xp.parsers.tilesLister.TilesLister;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import math.geom2d.Point2D;

public class ShapefileTilesLister
implements TilesLister {
    private ShapeFile shapeFile;
    private Set<Point2D> tilesList = new HashSet<Point2D>();

    public ShapefileTilesLister(File file) {
        try {
            this.shapeFile = new ShapeFile(file);
        }
        catch (IOException e) {
            Osm2xpLogger.error("Error loading shapefile file", e);
        }
    }

    @Override
    public void process() throws Osm2xpException {
        try {
            ESRIPolygonRecord esriPolygonRecord = (ESRIPolygonRecord)this.shapeFile.getNextRecord();
            while (esriPolygonRecord != null) {
                ESRIPoly.ESRIFloatPoly poly = (ESRIPoly.ESRIFloatPoly)esriPolygonRecord.polygons[0];
                Node node = new Node();
                double[] dArray = poly.getRadians();
                int n = dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double point = dArray[n2];
                    if (node.getLat() == 0.0) {
                        node.setLat(Math.toDegrees(point));
                    } else if (node.getLat() != 0.0 && node.getLon() == 0.0) {
                        node.setLon(Math.toDegrees(point));
                        Point2D loc = new Point2D(node.getLat(), node.getLon());
                        int lat = (int)Math.floor(loc.x);
                        int lon = (int)Math.floor(loc.y);
                        Point2D cleanedLoc = new Point2D((double)lat, (double)lon);
                        this.tilesList.add(cleanedLoc);
                        node = new Node();
                    }
                    ++n2;
                }
                esriPolygonRecord = (ESRIPolygonRecord)this.shapeFile.getNextRecord();
            }
        }
        catch (IOException iOException) {
            throw new Osm2xpException("Error parsing tiles");
        }
    }

    @Override
    public Set<Point2D> getTilesList() {
        return this.tilesList;
    }
}

