/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.parsers.tilesLister;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.parsers.tilesLister.TilesLister;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import math.geom2d.Point2D;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlTilesLister
implements ContentHandler,
TilesLister {
    private Set<Point2D> tilesList = new HashSet<Point2D>();
    private File file;

    public XmlTilesLister(File file) {
        this.file = file;
    }

    @Override
    public Set<Point2D> getTilesList() {
        return this.tilesList;
    }

    public void parseDocument() throws Osm2xpException {
        XMLReader saxReader = null;
        try {
            saxReader = XMLReaderFactory.createXMLReader();
            saxReader.setContentHandler(this);
            saxReader.parse(this.file.getAbsolutePath());
        }
        catch (SAXException e) {
            throw new Osm2xpException(e.getMessage());
        }
        catch (IOException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
        if (localName.equalsIgnoreCase("node") && attributs.getValue("lat") != null && attributs.getValue("lon") != null) {
            Point2D loc = new Point2D(Double.parseDouble(attributs.getValue("lat")), Double.parseDouble(attributs.getValue("lon")));
            int lat = (int)Math.floor(loc.x);
            int lon = (int)Math.floor(loc.y);
            Point2D cleanedLoc = new Point2D((double)lat, (double)lon);
            this.tilesList.add(cleanedLoc);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void process() throws Osm2xpException {
        this.parseDocument();
    }

    public void complete() {
    }
}

