/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators;

import com.osm2xp.constants.Osm2xpConstants;
import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.dataProcessors.ProcessorFactory;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.facades.FacadeSet;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.stats.GenerationStats;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.translators.impl.ConsoleTranslatorImpl;
import com.osm2xp.translators.impl.FsxBgTranslatorImpl;
import com.osm2xp.translators.impl.G2xplTranslatorImpl;
import com.osm2xp.translators.impl.OsmTranslatorImpl;
import com.osm2xp.translators.impl.WavefrontTranslatorImpl;
import com.osm2xp.translators.impl.Xplane10TranslatorImpl;
import com.osm2xp.translators.impl.Xplane9TranslatorImpl;
import com.osm2xp.translators.impl.flyLegacyTranslatorImpl;
import com.osm2xp.utils.DsfObjectsProvider;
import com.osm2xp.utils.helpers.FacadeSetHelper;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.helpers.StatsHelper;
import com.osm2xp.utils.helpers.WavefrontOptionsHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.writers.impl.BglWriterImpl;
import com.osm2xp.writers.impl.DsfWriterImpl;
import com.osm2xp.writers.impl.OsmWriterImpl;
import java.io.File;
import java.util.List;
import math.geom2d.Point2D;

public class TranslatorBuilder {
    public static ITranslator getMinimalTranslator() {
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Xplane 9")) {
            return new Xplane9TranslatorImpl();
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Xplane 10")) {
            return new Xplane10TranslatorImpl();
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("OpenStreetMap (xml)")) {
            return new OsmTranslatorImpl();
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Console")) {
            return new ConsoleTranslatorImpl();
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("WaveFront (.obj)")) {
            return new WavefrontTranslatorImpl();
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Flight Simulator X")) {
            return new FsxBgTranslatorImpl();
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("G2xpl binding file")) {
            return new G2xplTranslatorImpl();
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Fly! Legacy")) {
            return new flyLegacyTranslatorImpl();
        }
        return null;
    }

    public static ITranslator getTranslator(File currentFile, Point2D currentTile, String folderPath, List<Relation> relationsList) throws Osm2xpException {
        IProcessor processor = ProcessorFactory.getProcessor();
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Xplane 9")) {
            return TranslatorBuilder.buildXplane9Translator(currentFile, currentTile, folderPath, processor, relationsList);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Xplane 10")) {
            return TranslatorBuilder.buildXplane10Translator(currentFile, currentTile, folderPath, processor);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("OpenStreetMap (xml)")) {
            return TranslatorBuilder.buildOsmTranslator(currentTile, folderPath, processor);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Console")) {
            return TranslatorBuilder.buildConsoleTranslator(currentTile, processor);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("WaveFront (.obj)")) {
            return TranslatorBuilder.buildWavefrontTranslator(currentTile, folderPath, processor);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Flight Simulator X")) {
            return TranslatorBuilder.buildFsxTranslator(currentFile, currentTile, folderPath, processor);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("G2xpl binding file")) {
            return TranslatorBuilder.buildG2xplTranslator(currentTile, folderPath, processor);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Fly! Legacy")) {
            return TranslatorBuilder.buildFlyLegacyTranslator(currentTile, folderPath, processor);
        }
        return null;
    }

    private static ITranslator buildFsxTranslator(File currentFile, Point2D currentTile, String folderPath, IProcessor processor) {
        BglWriterImpl writer = new BglWriterImpl(folderPath);
        GenerationStats stats = StatsHelper.initStats(currentFile, currentTile);
        return new FsxBgTranslatorImpl(stats, writer, currentTile, processor, folderPath);
    }

    private static ITranslator buildWavefrontTranslator(Point2D currentTile, String folderPath, IProcessor processor) {
        return new WavefrontTranslatorImpl(folderPath, currentTile, processor, WavefrontOptionsHelper.getOptions().isWaveFrontExportSingleObject());
    }

    private static ITranslator buildConsoleTranslator(Point2D currentTile, IProcessor processor) {
        DsfObjectsProvider dsfObjectsProvider = new DsfObjectsProvider();
        dsfObjectsProvider.compute3dObjectsList();
        return new ConsoleTranslatorImpl(currentTile, processor, dsfObjectsProvider);
    }

    private static ITranslator buildOsmTranslator(Point2D currentTile, String folderPath, IProcessor processor) {
        OsmWriterImpl writer = new OsmWriterImpl(folderPath);
        return new OsmTranslatorImpl(writer, currentTile, processor);
    }

    private static ITranslator buildG2xplTranslator(Point2D currentTile, String folderPath, IProcessor processor) {
        return new G2xplTranslatorImpl(currentTile, processor, folderPath);
    }

    private static ITranslator buildFlyLegacyTranslator(Point2D currentTile, String folderPath, IProcessor processor) {
        return new flyLegacyTranslatorImpl(currentTile, processor, folderPath);
    }

    private static ITranslator buildXplane10Translator(File currentFile, Point2D currentTile, String folderPath, IProcessor processor) throws Osm2xpException {
        GenerationStats stats = StatsHelper.initStats(currentFile, currentTile);
        String FacadeSetPath = String.valueOf(Osm2xpConstants.FACADES_SETS_PATH) + File.separator + XplaneOptionsHelper.getOptions().getFacadeSet();
        FacadeSet facadeSet = FacadeSetHelper.getFacadeSet(FacadeSetPath);
        DsfObjectsProvider dsfObjectsProvider = new DsfObjectsProvider(facadeSet);
        DsfWriterImpl writer = new DsfWriterImpl(folderPath, dsfObjectsProvider);
        return new Xplane10TranslatorImpl(stats, writer, currentTile, processor, folderPath, dsfObjectsProvider);
    }

    private static ITranslator buildXplane9Translator(File currentFile, Point2D currentTile, String folderPath, IProcessor processor, List<Relation> relationsList) throws Osm2xpException {
        GenerationStats stats = StatsHelper.initStats(currentFile, currentTile);
        String FacadeSetPath = String.valueOf(Osm2xpConstants.FACADES_SETS_PATH) + File.separator + XplaneOptionsHelper.getOptions().getFacadeSet();
        FacadeSet facadeSet = FacadeSetHelper.getFacadeSet(FacadeSetPath);
        DsfObjectsProvider dsfObjectsProvider = new DsfObjectsProvider(facadeSet);
        DsfWriterImpl writer = new DsfWriterImpl(folderPath, dsfObjectsProvider);
        return new Xplane9TranslatorImpl(stats, writer, currentTile, processor, folderPath, dsfObjectsProvider);
    }
}

