/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Way;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.DsfObjectsProvider;
import com.osm2xp.utils.DsfUtils;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.util.List;
import math.geom2d.Point2D;
import math.geom2d.polygon.LinearRing2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class ConsoleTranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/terminalLogo.jpg";
    private static final int BUILDING_MIN_VECTORS = 3;
    private static final int BUILDING_MAX_VECTORS = 512;
    private Point2D currentTile;
    private IProcessor processor;
    private DsfObjectsProvider dsfObjectsProvider;

    public ConsoleTranslatorImpl(Point2D currentTile, IProcessor processor, DsfObjectsProvider dsfObjectsProvider) {
        this.currentTile = currentTile;
        this.processor = processor;
        this.dsfObjectsProvider = dsfObjectsProvider;
    }

    public ConsoleTranslatorImpl() {
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
            Integer[] objectIndexAndAngle = DsfUtils.getRandomDsfObjectIndexAndAngle(node.getTag(), node.getId(), this.dsfObjectsProvider);
            if (objectIndexAndAngle != null) {
                Osm2xpLogger.info("3D object at " + node.getLat() + "/" + node.getLon() + " : " + this.dsfObjectsProvider.getObjectsList().get(objectIndexAndAngle[0]));
            }
        }
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        LinearRing2D polygon = new LinearRing2D();
        List<Node> nodeList = this.processor.getNodes(way.getNd());
        if (nodeList != null) {
            polygon = GeomUtils.getPolygonFromOsmNodes(nodeList);
            Boolean translationFinished = false;
            if (!translationFinished.booleanValue()) {
                translationFinished = this.processBuilding(way, polygon);
                translationFinished = this.processForest(way, polygon);
            }
        }
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public void complete() {
    }

    @Override
    public void init() throws Osm2xpException {
        Osm2xpLogger.info("Starting console debug output of tile " + (int)this.currentTile.x + "/" + (int)this.currentTile.y);
    }

    private boolean processBuilding(Way way, LinearRing2D polygon) {
        if (OsmUtils.isBuilding(way.getTag()) && !OsmUtils.isExcluded(way.getTag(), way.getId()) && polygon.getVertexNumber() > 3 && polygon.getVertexNumber() < 512) {
            double[] extremesVectors = GeomUtils.computeExtremeVectors(polygon);
            double minVector = extremesVectors[0];
            double maxVector = extremesVectors[1];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("building id " + way.getId() + "\n");
            stringBuilder.append("smallest vector " + minVector + ", largest vector " + maxVector + "\n");
            stringBuilder.append("area " + polygon.getArea() * 1.0E8 + "\n");
            stringBuilder.append("polygon is made of  " + (polygon.getVertexNumber() - 1) + " points\n");
            Osm2xpLogger.info(stringBuilder.toString());
            return true;
        }
        return false;
    }

    private boolean processForest(Way way, LinearRing2D polygon) {
        Integer[] forestIndexAndDensity = DsfUtils.getRandomForestIndexAndDensity(way.getTag(), this.dsfObjectsProvider);
        if (forestIndexAndDensity != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("forest id " + way.getId() + "\n");
            stringBuilder.append("area " + polygon.getArea() * 1.0E8 + "\n");
            stringBuilder.append("polygon is made of  " + (polygon.getVertexNumber() - 1) + " points\n");
            Osm2xpLogger.info(stringBuilder.toString());
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Console output mode. \nDebug mode , that display some informations about osm data being read ";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

