/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Way;
import com.osm2xp.model.stats.GenerationStats;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.BglUtils;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.writers.IWriter;
import java.text.MessageFormat;
import java.util.List;
import math.geom2d.Point2D;
import math.geom2d.polygon.LinearRing2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class FsxBgTranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/fsxLogo.jpg";
    private Point2D currentTile;
    private IWriter writer;
    private IProcessor processor;
    private static final String FSX_OBJECT_DECLARATION = "<SceneryObject lat=\"{0}\" lon=\"{1}\" alt=\"0\" altitudeIsAgl=\"TRUE\" pitch=\"0\" bank=\"0\"  heading=\"0\" imageComplexity=\"NORMAL\"> \n<LibraryObject name=\"{2}\" scale=\"1.0\"/>\n</SceneryObject>";

    public FsxBgTranslatorImpl() {
    }

    public FsxBgTranslatorImpl(GenerationStats stats, IWriter writer, Point2D currentTile, IProcessor processor, String folderPath) {
        this.currentTile = currentTile;
        this.writer = writer;
        this.processor = processor;
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
            String guid = BglUtils.getRandomBglGuid(node.getTag(), node.getId());
            if (guid != null) {
                this.write3dObjectToBgl(new Point2D(node.getLat(), node.getLon()), guid);
            }
        }
    }

    private void write3dObjectToBgl(Point2D point2d, String guid) {
        Double x = point2d.x;
        Double y = point2d.y;
        String fsxObject = MessageFormat.format(FSX_OBJECT_DECLARATION, x.toString(), y.toString(), guid);
        this.writer.write(fsxObject);
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        List<Node> nodeList = this.processor.getNodes(way.getNd());
        if (nodeList != null) {
            LinearRing2D polygon = GeomUtils.getPolygonFromOsmNodes(nodeList);
            Point2D center = GeomUtils.getPolygonCenter(polygon);
            String guid = BglUtils.getRandomBglGuid(way.getTag(), way.getId());
            if (guid != null) {
                this.write3dObjectToBgl(center, guid);
            }
        }
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public void complete() {
        this.writer.complete();
    }

    @Override
    public void init() throws Osm2xpException {
        this.writer.init(this.currentTile);
    }

    @Override
    public String getDescription() {
        return "Flight Simulator X output mode \n \nGenerate a .bgl file of 3D landmarks.";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

