/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.fsx.FsxObject;
import com.osm2xp.model.geom.Lod13Location;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Way;
import com.osm2xp.model.stats.GenerationStats;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.logging.Osm2xpLogger;
import com.osm2xp.writers.IWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import math.geom2d.Point2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class FsxTranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/fsxLogo.jpg";
    private Point2D currentTile;
    private GenerationStats stats;
    private IWriter writer;
    private IProcessor processor;
    private Date startTime;
    private String folderPath;

    public FsxTranslatorImpl(GenerationStats stats, IWriter writer, Point2D currentTile, IProcessor processor, String folderPath) {
        this.currentTile = currentTile;
        this.stats = stats;
        this.writer = writer;
        this.processor = processor;
        this.folderPath = folderPath;
        this.startTime = new Date();
    }

    public FsxTranslatorImpl() {
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
        }
    }

    private List<FsxObject> splitObject(FsxObject fsxObject) {
        ArrayList<FsxObject> result = new ArrayList<FsxObject>();
        if (!fsxObject.isOnASingleLod13Square()) {
            HashMap<String, FsxObject> objectsMap = new HashMap<String, FsxObject>();
            for (Lod13Location location : fsxObject.getLod13Locations()) {
                if (objectsMap.containsKey(location.getLod13String())) {
                    ((FsxObject)objectsMap.get(location.getLod13String())).getLod13Locations().add(location);
                    continue;
                }
                FsxObject object = new FsxObject(fsxObject.getGuid(), fsxObject.getType(), new ArrayList<Node>());
                object.getLod13Locations().add(location);
                objectsMap.put(location.getLod13String(), object);
            }
            ArrayList tempResult = new ArrayList(objectsMap.values());
            for (FsxObject object : tempResult) {
                if (!object.getLod13Locations().get(0).equals(object.getLod13Locations().get(object.getLod13Locations().size() - 1))) {
                    try {
                        object.getLod13Locations().add(object.getLod13Locations().get(0).clone());
                    }
                    catch (CloneNotSupportedException e) {
                        Osm2xpLogger.error("Error spliting fsx object along lod13 squares.", e);
                    }
                }
                if (object.getLod13Locations().size() <= 4) continue;
                result.add(object);
            }
        } else if (fsxObject.getLod13Locations().size() > 4) {
            result.add(fsxObject);
        }
        return result;
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        List<Node> nodeList = this.processor.getNodes(way.getNd());
        if (nodeList != null && OsmUtils.isForest(way.getTag())) {
            FsxObject fsxObject = new FsxObject("dc5c8dcb-551e-4980-867d-ee6d12695c50", "AGNPolyVegetation", nodeList);
            for (FsxObject object : this.splitObject(fsxObject)) {
                this.writer.write(object);
            }
        }
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public void complete() {
        this.processor.complete();
        this.writer.complete();
    }

    @Override
    public void init() throws Osm2xpException {
        Osm2xpLogger.info("Starting FSX generation of tile " + (int)this.currentTile.x + "/" + (int)this.currentTile.y);
        this.writer.init(null);
    }

    @Override
    public String getDescription() {
        return "Flight Simulator X output mode \n \nGenerate a .bgl file of 3D landmarks.NOT IMPLEMENTED YET.";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

