/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Way;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.List;
import math.geom2d.Point2D;
import math.geom2d.polygon.LinearRing2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class G2xplTranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/xplane9Logo.jpg";
    private Point2D currentTile;
    private IProcessor processor;
    private String folderPath;
    private File txtFile;

    public G2xplTranslatorImpl(Point2D currentTile, IProcessor processor, String folderPath) {
        this.currentTile = currentTile;
        this.processor = processor;
        this.folderPath = folderPath;
        this.txtFile = new File(String.valueOf(this.folderPath) + File.separator + "g2xpl_" + currentTile.x + "_" + currentTile.y + ".txt");
    }

    public G2xplTranslatorImpl() {
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
        }
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        LinearRing2D polygon = new LinearRing2D();
        List<Node> nodeList = this.processor.getNodes(way.getNd());
        if (nodeList != null) {
            polygon = GeomUtils.getPolygonFromOsmNodes(nodeList);
            if (OsmUtils.isBuilding(way.getTag())) {
                Point2D center = GeomUtils.getPolygonCenter(polygon);
                String wayText = String.valueOf(way.getId()) + ":" + center.x + "," + center.y + "\n";
                FilesUtils.writeTextToFile(this.txtFile, wayText, true);
            }
        }
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public void complete() {
        Osm2xpLogger.info("G2xpl binding file finished.");
    }

    @Override
    public void init() throws Osm2xpException {
        Osm2xpLogger.info("Starting G2xpl binding file for tile " + this.currentTile.x + "/" + this.currentTile.y + ".");
    }

    @Override
    public String getDescription() {
        return "G2XPL output mode \n \nGenerate a .cvs file for G2XPL that wil add roof color information.";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

