/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Tag;
import com.osm2xp.model.osm.Way;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import com.osm2xp.writers.IWriter;
import java.util.ArrayList;
import java.util.List;
import math.geom2d.Point2D;
import math.geom2d.polygon.LinearRing2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class OsmTranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/osmLogo.jpg";
    private IWriter writer;
    private Point2D currentTile;
    private IProcessor processor;
    private int nodeIndex = 1;

    public OsmTranslatorImpl(IWriter writer, Point2D currentTile, IProcessor processor) {
        this.writer = writer;
        this.currentTile = currentTile;
        this.processor = processor;
    }

    public OsmTranslatorImpl() {
    }

    private void writeNode(Node node) {
        if (node.getTag().isEmpty()) {
            this.writer.write("<node id=\"" + node.getId() + "\" lat=\"" + node.getLat() + "\" lon=\"" + node.getLon() + "\" version=\"1\" />\n");
        } else {
            this.writer.write("<node id=\"" + node.getId() + "\" lat=\"" + node.getLat() + "\" lon=\"" + node.getLon() + "\" version=\"1\" >\n");
            for (Tag tag : node.getTag()) {
                String normalizedTag = OsmUtils.getNormalizedTagText(tag);
                if (normalizedTag == null) continue;
                this.writer.write(normalizedTag);
            }
            this.writer.write("</node>\n");
        }
    }

    @Override
    public void init() throws Osm2xpException {
        Osm2xpLogger.info("Starting OpenStreetMap xml generation of tile " + (int)this.currentTile.x + "/" + (int)this.currentTile.y);
        this.writer.init(this.currentTile);
    }

    private void writeWay(Way way) {
        LinearRing2D poly = null;
        try {
            poly = GeomUtils.getPolygonFromOsmNodes(this.processor.getNodes(way.getNd()));
            if (GuiOptionsHelper.getOptions().isSimplifyShapes()) {
                poly = GeomUtils.simplifyPolygon(poly);
            }
            ArrayList<Node> nodeList = new ArrayList<Node>();
            for (Point2D point : poly.getVertices()) {
                Node node = new Node(null, point.x, point.y, this.nodeIndex);
                this.writeNode(node);
                nodeList.add(node);
                ++this.nodeIndex;
            }
            this.writer.write("<way id=\"" + way.getId() + "\" visible=\"true\" version=\"2\" >\n");
            for (Node node : nodeList) {
                this.writer.write("<nd ref=\"" + node.getId() + "\"/>\n");
            }
            for (Tag tag : way.getTag()) {
                String normalizedTag = OsmUtils.getNormalizedTagText(tag);
                if (normalizedTag == null) continue;
                this.writer.write(normalizedTag);
            }
            this.writer.write("</way>\n");
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error(e.getMessage());
        }
    }

    @Override
    public void complete() {
        this.writer.complete();
        this.processor.complete();
        Osm2xpLogger.info("Osm file complete");
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
        }
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        List<Node> nodeList = this.processor.getNodes(way.getNd());
        if (nodeList != null && (OsmUtils.isBuilding(way.getTag()) && !OsmUtils.isExcluded(way.getTag(), way.getId()) || OsmUtils.isForest(way.getTag()) || OsmUtils.isObject(way.getTag()))) {
            this.writeWay(way);
        }
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public String getDescription() {
        return "Osm translator";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

