/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.model.options.ObjectsRulesList;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Way;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.DsfObjectsProvider;
import com.osm2xp.utils.DsfUtils;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.helpers.WavefrontOptionsHelper;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import math.geom2d.Point2D;
import math.geom2d.polygon.LinearRing2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.target.obj.ObjTarget;

public class WavefrontTranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/osmLogo.jpg";
    private static final String GOOGLEMAPS_LOGO = "http://maps.gstatic.com/intl/fr_ALL/mapfiles/vt/mapsgl_promo_v2.png";
    private static final String GOOGLEMAPS_URL = "http://maps.google.com/maps?q=";
    private static final String OPENSTREETMAP_WAY_URL = "http://www.openstreetmap.org/browse/way/";
    private static final String OPENSTREETMAP_LOGO = "http://upload.wikimedia.org/wikipedia/commons/thumb/b/b0/Openstreetmap_logo.svg/45px-Openstreetmap_logo.svg.png";
    private String folderPath;
    private Point2D currentTile;
    private IProcessor processor;
    private List<ObjectTagRule> objectsTagRules = new ArrayList<ObjectTagRule>();
    private HashMap<Long, Point2D> objectsMap = new HashMap();
    private Boolean singleObjectExport;
    private List<Node> globalNodeList = new ArrayList<Node>();
    private List<Way> globalWayList = new ArrayList<Way>();

    public WavefrontTranslatorImpl(String folderPath, Point2D currentTile, IProcessor processor, Boolean singleObjectExport) {
        this.folderPath = folderPath;
        this.singleObjectExport = singleObjectExport;
        this.currentTile = currentTile;
        this.processor = processor;
        new File(String.valueOf(folderPath) + File.separator + "objects" + File.separator).mkdirs();
    }

    public WavefrontTranslatorImpl() {
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
        }
    }

    private void exportPolygonToObject(List<Node> nodeList, Way way) {
        if (nodeList.size() > 4 || OsmUtils.getHeightFromTags(way.getTag()) != null && OsmUtils.getHeightFromTags(way.getTag()) > 20) {
            String filePath = null;
            try {
                filePath = OsmUtils.CreateTempFile(this.folderPath, nodeList, way);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            ConversionFacade cv = new ConversionFacade();
            ObjTarget target = null;
            ArrayList<ObjTarget> targets = new ArrayList<ObjTarget>();
            try {
                target = new ObjTarget(new PrintStream(new File(String.valueOf(this.folderPath) + File.separator + "objects" + File.separator + way.getId() + ".obj")), new PrintStream(new File(String.valueOf(this.folderPath) + File.separator + "objects" + File.separator + way.getId() + ".obj.mtl")));
                new File(String.valueOf(this.folderPath) + File.separator + "objects files" + File.separator + way.getId() + ".obj.mtl").deleteOnExit();
            }
            catch (FileNotFoundException fileNotFoundException) {}
            targets.add(target);
            try {
                cv.createRepresentations(new File(filePath), null, null, targets);
                ObjectTagRule objectTagRule = new ObjectTagRule(new OsmTag("id", String.valueOf(way.getId())), (List<ObjectFile>)new ArrayList<ObjectFile>(way){
                    {
                        this.add(new ObjectFile("objects/" + way.getId() + ".obj"));
                    }
                }, 0, true);
                this.objectsTagRules.add(objectTagRule);
                this.objectsMap.put(way.getId(), GeomUtils.getPolygonCenter(GeomUtils.getPolygonFromOsmNodes(nodeList)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        List<Node> nodeList;
        if (OsmUtils.isBuilding(way.getTag()) && (nodeList = this.processor.getNodes(way.getNd())) != null && (nodeList.size() > WavefrontOptionsHelper.getOptions().getWaveFrontExportPointsFilter() || OsmUtils.getHeightFromTags(way.getTag()) != null && OsmUtils.getHeightFromTags(way.getTag()) > WavefrontOptionsHelper.getOptions().getWaveFrontExportHeightFilter())) {
            this.globalWayList.add(way);
            this.globalNodeList.addAll(nodeList);
            if (!this.singleObjectExport.booleanValue()) {
                this.exportPolygonToObject(nodeList, way);
            }
        }
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public void complete() {
        if (this.singleObjectExport.booleanValue()) {
            if (!this.globalWayList.isEmpty()) {
                String fileName = null;
                try {
                    fileName = OsmUtils.CreateTempFile(this.folderPath, this.globalNodeList, this.globalWayList, String.valueOf(this.currentTile.x) + "_" + this.currentTile.y);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File osmFile = new File(fileName);
                this.exportOsmFileToObject(osmFile);
                osmFile.deleteOnExit();
            }
        } else {
            try {
                XmlHelper.saveToXml(new ObjectsRulesList(this.objectsTagRules), new File(String.valueOf(this.folderPath) + File.separator + "objectsRules.xml"));
            }
            catch (Osm2xpException e1) {
                Osm2xpLogger.error("Error writing object rules file.", e1);
            }
            try {
                this.writeRecapHtmlFile();
            }
            catch (IOException e) {
                Osm2xpLogger.error("Error writing html recap file", e);
            }
        }
        if (WavefrontOptionsHelper.getOptions().isGenerateWaveFrontDsfPlaceholder()) {
            try {
                if (!this.singleObjectExport.booleanValue()) {
                    this.writeDsfPlaceHolder();
                } else {
                    this.writeDsfPlaceHolderForSingleLargeObject();
                }
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error writing dsf placeholder", e);
            }
        }
    }

    private void writeDsfPlaceHolder() throws Osm2xpException {
        String[] folderAndFileNames = DsfUtils.getFolderAndFileNames(this.currentTile);
        String fileName = folderAndFileNames[1];
        String folderName = folderAndFileNames[0];
        File dsfTextFile = new File(String.valueOf(this.folderPath) + File.separatorChar + "Earth nav data" + File.separatorChar + folderName + File.separatorChar + fileName + ".dsf.txt");
        dsfTextFile.deleteOnExit();
        ArrayList<String> objectsList = new ArrayList<String>();
        for (Way way : this.globalWayList) {
            objectsList.add("objects/" + way.getId() + ".obj");
        }
        DsfObjectsProvider dsfObjectsProvider = new DsfObjectsProvider();
        dsfObjectsProvider.setObjectsList(objectsList);
        String dsfHeaderText = DsfUtils.getDsfHeader(this.currentTile, dsfObjectsProvider);
        FilesUtils.writeTextToFile(dsfTextFile, dsfHeaderText, false);
        for (Way way : this.globalWayList) {
            List<Node> nodeList = this.processor.getNodes(way.getNd());
            if (nodeList == null) continue;
            LinearRing2D polygon = GeomUtils.getPolygonFromOsmNodes(nodeList);
            Point2D center = GeomUtils.getPolygonCenter(polygon);
            StringBuffer sb = new StringBuffer();
            sb.append("OBJECT " + objectsList.indexOf("/objects files/" + way.getId() + ".obj") + " " + center.y + " " + center.x + " " + 0);
            sb.append(System.getProperty("line.separator"));
            FilesUtils.writeTextToFile(dsfTextFile, sb.toString(), true);
        }
        DsfUtils.textToDsf(dsfTextFile, new File(String.valueOf(this.folderPath) + File.separatorChar + "Earth nav data" + File.separatorChar + folderName + File.separatorChar + fileName + ".dsf"));
    }

    private void writeDsfPlaceHolderForSingleLargeObject() throws Osm2xpException {
        String[] folderAndFileNames = DsfUtils.getFolderAndFileNames(this.currentTile);
        String fileName = folderAndFileNames[1];
        String folderName = folderAndFileNames[0];
        File dsfTextFile = new File(String.valueOf(this.folderPath) + File.separatorChar + "Earth nav data" + File.separatorChar + folderName + File.separatorChar + fileName + ".dsf.txt");
        dsfTextFile.deleteOnExit();
        ArrayList<String> objectsList = new ArrayList<String>();
        objectsList.add("objects/" + this.currentTile.x + "_" + this.currentTile.y + ".obj");
        DsfObjectsProvider dsfObjectsProvider = new DsfObjectsProvider();
        dsfObjectsProvider.setObjectsList(objectsList);
        String dsfHeaderText = DsfUtils.getDsfHeader(this.currentTile, dsfObjectsProvider);
        FilesUtils.writeTextToFile(dsfTextFile, dsfHeaderText, false);
        ArrayList<Point2D> areaNodes = new ArrayList<Point2D>();
        for (Way way : this.globalWayList) {
            List<Node> nodeList = this.processor.getNodes(way.getNd());
            if (nodeList == null) continue;
            areaNodes.add(GeomUtils.getNodesCenter(nodeList));
        }
        Point2D center = GeomUtils.getPolygonCenter(new LinearRing2D(areaNodes));
        StringBuffer sb = new StringBuffer();
        sb.append("OBJECT 0 " + center.y + " " + center.x + " " + 0);
        sb.append(System.getProperty("line.separator"));
        FilesUtils.writeTextToFile(dsfTextFile, sb.toString(), true);
        DsfUtils.textToDsf(dsfTextFile, new File(String.valueOf(this.folderPath) + File.separatorChar + "Earth nav data" + File.separatorChar + folderName + File.separatorChar + fileName + ".dsf"));
    }

    private void exportOsmFileToObject(File osmFile) {
        ConversionFacade cv = new ConversionFacade();
        ObjTarget target = null;
        ArrayList<ObjTarget> targets = new ArrayList<ObjTarget>();
        try {
            target = new ObjTarget(new PrintStream(new File(String.valueOf(this.folderPath) + File.separator + "objects" + File.separator + this.currentTile.x + "_" + this.currentTile.y + ".obj")), new PrintStream(new File(String.valueOf(this.folderPath) + File.separator + "objects" + File.separator + this.currentTile.x + "_" + this.currentTile.y + ".obj.mtl")));
            new File(String.valueOf(this.folderPath) + File.separator + "objects files" + File.separator + this.currentTile.x + "_" + this.currentTile.y + ".obj.mtl").deleteOnExit();
        }
        catch (FileNotFoundException fileNotFoundException) {}
        targets.add(target);
        try {
            cv.createRepresentations(osmFile, null, null, targets);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Osm2xpException {
        Osm2xpLogger.info("Starting wavefront (.obj) generation of tile " + (int)this.currentTile.x + "/" + (int)this.currentTile.y + " - wavefront export uses osm2world http://osm2world.org/");
    }

    private void writeRecapHtmlFile() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<style type=\"text/css\">");
        sb.append("table {");
        sb.append(" border-collapse:collapse;");
        sb.append("width:90%;");
        sb.append("}");
        sb.append("th, td {");
        sb.append(" border:1px solid black;");
        sb.append(" width:20%;");
        sb.append(" }");
        sb.append("td {");
        sb.append(" text-align:center;");
        sb.append(" }");
        sb.append("caption {");
        sb.append(" font-weight:bold");
        sb.append(" }");
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<table border=\"1\">");
        sb.append("<CAPTION>Osm2xp obj export report </CAPTION>");
        sb.append("<TR>");
        sb.append("<TH> object file </TH>");
        sb.append("<TH> latitude </TH>");
        sb.append("<TH> longitude</TH>");
        sb.append("<TH> OpenStreetMap link </TH>");
        sb.append("<TH> GoogleMap link </TH>");
        sb.append(" </TR>");
        for (Map.Entry<Long, Point2D> entry : this.objectsMap.entrySet()) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(String.valueOf(String.valueOf(entry.getKey())) + ".obj");
            sb.append("</td>");
            sb.append("<td>");
            sb.append(String.valueOf(entry.getValue().x));
            sb.append("</td>");
            sb.append("<td>");
            sb.append(String.valueOf(entry.getValue().y));
            sb.append("</td>");
            sb.append("<td>");
            sb.append("<a href=http://www.openstreetmap.org/browse/way/" + entry.getKey() + " TARGET=_BLANK><img src=\"" + OPENSTREETMAP_LOGO + "\"/></a>");
            sb.append("</td>");
            sb.append("<td>");
            sb.append("<a href=http://maps.google.com/maps?q=" + entry.getValue().x + "," + entry.getValue().y + "&num=1&t=h&vpsrc=0&z=20" + "\" TARGET=_BLANK><img src=" + GOOGLEMAPS_LOGO + "></a>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        sb.append("</body>");
        sb.append("</html>");
        FilesUtils.writeTextToFile(new File(String.valueOf(this.folderPath) + File.separator + "report.html"), sb.toString(), false);
    }

    @Override
    public String getDescription() {
        return "Wavefront output mode. \n\nGenerates wavefront (.obj) 3D models. \nThis export mode uses osm2world library (http://osm2world.org/). \n";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

