/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Tag;
import com.osm2xp.model.osm.Way;
import com.osm2xp.model.stats.GenerationStats;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.DsfObjectsProvider;
import com.osm2xp.utils.DsfUtils;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.utils.MiscUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.helpers.StatsHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import com.osm2xp.writers.IWriter;
import java.util.Date;
import java.util.List;
import java.util.Random;
import math.geom2d.Point2D;
import math.geom2d.polygon.LinearRing2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class Xplane9TranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/xplane9Logo.jpg";
    private static final double ASSERTION_RESIDENTIAL_MAX_AREA = 0.5;
    private static final int BUILDING_MIN_VECTORS = 3;
    private static final int BUILDING_MAX_VECTORS = 512;
    private Point2D currentTile;
    private GenerationStats stats;
    private IWriter writer;
    private IProcessor processor;
    private Date startTime;
    private String folderPath;
    private DsfObjectsProvider dsfObjectsProvider;

    public Xplane9TranslatorImpl() {
    }

    public Xplane9TranslatorImpl(GenerationStats stats, IWriter writer, Point2D currentTile, IProcessor processor, String folderPath, DsfObjectsProvider dsfObjectsProvider) {
        this.currentTile = currentTile;
        this.stats = stats;
        this.writer = writer;
        this.processor = processor;
        this.folderPath = folderPath;
        this.dsfObjectsProvider = dsfObjectsProvider;
        this.startTime = new Date();
    }

    @Override
    public void complete() {
        this.processor.complete();
        if (!StatsHelper.isTileEmpty(this.stats)) {
            Osm2xpLogger.info("stats : " + this.stats.getBuildingsNumber() + " buildings, " + this.stats.getForestsNumber() + " forests, " + this.stats.getStreetlightsNumber() + " street lights, " + this.stats.getObjectsNumber() + " objects. (generation took " + MiscUtils.getTimeDiff(this.startTime, new Date()) + ")");
            this.writer.complete();
            try {
                if (XplaneOptionsHelper.getOptions().isGenerateXmlStats() || XplaneOptionsHelper.getOptions().isGeneratePdfStats()) {
                    StatsHelper.getStatsList().add(this.stats);
                }
                if (XplaneOptionsHelper.getOptions().isGenerateXmlStats()) {
                    StatsHelper.saveStats(this.folderPath, this.currentTile, this.stats);
                }
                if (XplaneOptionsHelper.getOptions().isGeneratePdfStats()) {
                    StatsHelper.generatePdfReport(this.folderPath, this.stats);
                }
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error saving stats file for tile " + this.currentTile, e);
            }
        } else {
            Osm2xpLogger.info("Tile " + (int)this.currentTile.x + "/" + (int)this.currentTile.y + " is empty, no dsf generated");
        }
    }

    @Override
    public void init() throws Osm2xpException {
        Osm2xpLogger.info("Starting X-Plane 9 generation of tile " + (int)this.currentTile.x + "/" + (int)this.currentTile.y);
        this.dsfObjectsProvider.computePolygonsList();
        this.dsfObjectsProvider.compute3dObjectsList();
        this.writer.init(this.currentTile);
    }

    public void writeStreetLightToDsf(LinearRing2D polygon) {
        Integer densityIndex = 0;
        if (XplaneOptionsHelper.getOptions().getLightsDensity() == 0) {
            densityIndex = 10;
        } else if (XplaneOptionsHelper.getOptions().getLightsDensity() == 1) {
            densityIndex = 5;
        } else if (XplaneOptionsHelper.getOptions().getLightsDensity() == 2) {
            densityIndex = 3;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < polygon.getVertices().size()) {
            if (i % densityIndex == 0) {
                Point2D lightLoc = polygon.getVertex(i);
                lightLoc.x += 1.0E-4;
                lightLoc.y += 1.0E-4;
                if (GeomUtils.compareCoordinates(lightLoc, this.currentTile)) {
                    Random randomGenerator = new Random();
                    int orientation = randomGenerator.nextInt(360);
                    sb.append("OBJECT " + this.dsfObjectsProvider.getRandomStreetLightObject() + " " + lightLoc.y + " " + lightLoc.x + " " + orientation);
                    sb.append(System.getProperty("line.separator"));
                    StatsHelper.addStreetLight(this.stats);
                }
            }
            ++i;
        }
        this.writer.write(sb.toString());
    }

    public void writeBuildingToDsf(LinearRing2D polygon, Integer facade, Integer size) {
        if (facade != null && size != null) {
            StringBuffer sb = new StringBuffer();
            if ((polygon = GeomUtils.setClockwise(polygon)).getArea() * 1.0E7 > 0.1 && polygon.getVertexNumber() > 3 && facade != null && size != null) {
                sb.append("BEGIN_POLYGON " + facade + " " + size + " 2");
                sb.append(System.getProperty("line.separator"));
                sb.append("BEGIN_WINDING");
                sb.append(System.getProperty("line.separator"));
                polygon.removePoint(polygon.getLastPoint());
                for (Point2D loc : polygon.getVertices()) {
                    sb.append("POLYGON_POINT " + loc.y + " " + loc.x);
                    sb.append(System.getProperty("line.separator"));
                }
                sb.append("END_WINDING");
                sb.append(System.getProperty("line.separator"));
                sb.append("END_POLYGON");
                sb.append(System.getProperty("line.separator"));
                if (this.dsfObjectsProvider.getPolygonsList().get(facade).toLowerCase().contains("building") || this.dsfObjectsProvider.getPolygonsList().get(facade).toLowerCase().contains("shape")) {
                    StatsHelper.addBuildingType("Building", this.stats);
                } else if (this.dsfObjectsProvider.getPolygonsList().get(facade).toLowerCase().contains("house") || this.dsfObjectsProvider.getPolygonsList().get(facade).toLowerCase().contains("common")) {
                    StatsHelper.addBuildingType("Residential", this.stats);
                } else {
                    StatsHelper.addBuildingType("Facade rule", this.stats);
                }
                this.writer.write(sb.toString());
            }
        }
    }

    private Integer computeBuildingHeight(List<Tag> tags, LinearRing2D polygon) {
        Integer osmHeight;
        if (!OsmUtils.isStringInTags("man_made", tags) && (osmHeight = OsmUtils.getHeightFromTags(tags)) != null) {
            return osmHeight;
        }
        if (polygon.getArea() * 1.0E7 < 0.2) {
            return XplaneOptionsHelper.getOptions().getResidentialMin();
        }
        if (polygon.getArea() * 1.0E7 > 0.5) {
            return MiscUtils.getRandomSize(XplaneOptionsHelper.getOptions().getBuildingMin(), XplaneOptionsHelper.getOptions().getBuildingMax());
        }
        if (polygon.getArea() * 1.0E7 < 0.5) {
            return MiscUtils.getRandomSize(XplaneOptionsHelper.getOptions().getResidentialMin(), XplaneOptionsHelper.getOptions().getResidentialMax());
        }
        return null;
    }

    private Integer computeResidentialFacadeIndex(LinearRing2D polygon, Integer height) {
        Double[] extremesAngles = GeomUtils.getExtremesAngle(polygon);
        double[] extremesVectors = GeomUtils.computeExtremeVectors(polygon);
        double minVector = extremesVectors[0];
        if (XplaneOptionsHelper.getOptions().isGenerateSlopedRoofs() && minVector > 0.5 && polygon.getEdges().size() == 4 && extremesAngles[0] > 30.0 && extremesAngles[1] < 200.0) {
            return this.dsfObjectsProvider.computeFacadeDsfIndex(true, true, true, minVector, height.intValue(), null);
        }
        if (polygon.getEdges().size() == 4) {
            return this.dsfObjectsProvider.computeFacadeDsfIndex(true, true, false, minVector, height.intValue(), null);
        }
        return this.dsfObjectsProvider.computeFacadeDsfIndex(false, true, false, minVector, height.intValue(), null);
    }

    private Integer computeBuildingFacadeIndex(LinearRing2D polygon, Integer height) {
        if (polygon.getEdges().size() == 4) {
            return this.dsfObjectsProvider.computeFacadeDsfIndex(true, false, false, 0.0, height.intValue(), null);
        }
        return this.dsfObjectsProvider.computeFacadeDsfIndex(false, false, false, 0.0, height.intValue(), null);
    }

    public Integer computeFacadeIndex(List<Tag> tags, LinearRing2D polygon, Integer height) {
        if ((OsmUtils.isValueinTags("residential", tags) || OsmUtils.isValueinTags("house", tags) || polygon.getArea() * 1.0E7 < 0.5) && height < XplaneOptionsHelper.getOptions().getResidentialMax()) {
            return this.computeResidentialFacadeIndex(polygon, height);
        }
        if (OsmUtils.isValueinTags("industrial", tags) || OsmUtils.isValueinTags("Commercial", tags) || polygon.getArea() * 1.0E7 > 0.5 || height > XplaneOptionsHelper.getOptions().getResidentialMax()) {
            return this.computeBuildingFacadeIndex(polygon, height);
        }
        return null;
    }

    private void write3dObjectToDsf(Point2D center, Integer[] objectIndexAndAngle) {
        StringBuffer sb = new StringBuffer();
        sb.append("OBJECT " + objectIndexAndAngle[0] + " " + center.y + " " + center.x + " " + objectIndexAndAngle[1]);
        sb.append(System.getProperty("line.separator"));
        this.writer.write(sb.toString());
        StatsHelper.addObjectType(this.dsfObjectsProvider.getObjectsList().get(objectIndexAndAngle[0]), this.stats);
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
            Integer[] objectIndexAndAngle = DsfUtils.getRandomDsfObjectIndexAndAngle(node.getTag(), node.getId(), this.dsfObjectsProvider);
            if (objectIndexAndAngle != null) {
                this.write3dObjectToDsf(new Point2D(node.getLat(), node.getLon()), objectIndexAndAngle);
            }
        }
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        LinearRing2D polygon = new LinearRing2D();
        List<Node> nodeList = this.processor.getNodes(way.getNd());
        if (nodeList != null) {
            polygon = GeomUtils.getPolygonFromOsmNodes(nodeList);
            Boolean translationFinished = false;
            if (!translationFinished.booleanValue()) {
                translationFinished = this.process3dObject(way, polygon);
                translationFinished = this.processForest(way, polygon);
                translationFinished = this.processBuilding(way, polygon);
                translationFinished = this.processStreetLights(way, polygon);
            }
        }
    }

    private boolean processBuilding(Way way, LinearRing2D polygon) {
        if (XplaneOptionsHelper.getOptions().isGenerateBuildings() && OsmUtils.isBuilding(way.getTag()) && !OsmUtils.isExcluded(way.getTag(), way.getId()) && polygon.getVertexNumber() > 3 && polygon.getVertexNumber() < 512) {
            if (GuiOptionsHelper.getOptions().isSimplifyShapes()) {
                polygon = GeomUtils.simplifyPolygon(polygon);
            }
            Integer height = this.computeBuildingHeight(way.getTag(), polygon);
            Integer facade = this.computeFacadeIndex(way.getTag(), polygon, height);
            this.writeBuildingToDsf(polygon, facade, height);
            return true;
        }
        return false;
    }

    private boolean process3dObject(Way way, LinearRing2D polygon) {
        Integer[] objectIndexAndAngle;
        if (XplaneOptionsHelper.getOptions().isGenerateObj() && (objectIndexAndAngle = DsfUtils.getRandomDsfObjectIndexAndAngle(way.getTag(), way.getId(), this.dsfObjectsProvider)) != null) {
            this.write3dObjectToDsf(GeomUtils.getPolygonCenter(polygon), objectIndexAndAngle);
            return true;
        }
        return false;
    }

    private boolean processStreetLights(Way way, LinearRing2D polygon) {
        if (XplaneOptionsHelper.getOptions().isGenerateStreetLights() && OsmUtils.isTagInTagsList("highway", "residential", way.getTag())) {
            this.writeStreetLightToDsf(polygon);
            return true;
        }
        return false;
    }

    private boolean processForest(Way way, LinearRing2D polygon) {
        Integer[] forestIndexAndDensity;
        if (XplaneOptionsHelper.getOptions().isGenerateFor() && (forestIndexAndDensity = DsfUtils.getRandomForestIndexAndDensity(way.getTag(), this.dsfObjectsProvider)) != null) {
            this.writeForestToDsf(polygon, forestIndexAndDensity);
            return true;
        }
        return false;
    }

    private void writeForestToDsf(LinearRing2D polygon, Integer[] forestIndexAndDensity) {
        StringBuffer sb = new StringBuffer();
        sb.append("BEGIN_POLYGON " + forestIndexAndDensity[0] + " " + forestIndexAndDensity[1] + " 2");
        sb.append(System.getProperty("line.separator"));
        sb.append("BEGIN_WINDING");
        sb.append(System.getProperty("line.separator"));
        for (Point2D loc : polygon.getVertices()) {
            sb.append("POLYGON_POINT " + loc.y + " " + loc.x);
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("END_WINDING");
        sb.append(System.getProperty("line.separator"));
        sb.append("END_POLYGON");
        sb.append(System.getProperty("line.separator"));
        StatsHelper.addForestType(this.dsfObjectsProvider.getPolygonsList().get(forestIndexAndDensity[0]), this.stats);
        this.writer.write(sb.toString());
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public String getDescription() {
        return "Xplane 9 output mode. \n\nGenerates xplane9 scenery. \nBuildings are made of facades objects, you can customize the look of the output by creating a facade set. \n";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

