/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.translators.impl;

import com.osm2xp.dataProcessors.IProcessor;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Relation;
import com.osm2xp.model.osm.Way;
import com.osm2xp.translators.ITranslator;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.GeomUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.helpers.FlyLegacyOptionsHelper;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.List;
import math.geom2d.Point2D;
import math.geom2d.polygon.LinearRing2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class flyLegacyTranslatorImpl
implements ITranslator {
    private static final String TRANSLATOR_LOGO_PATH = "images/translatorsImages/flyLogo.jpg";
    private Point2D currentTile;
    private IProcessor processor;
    private String folderPath;
    private File txtFile;
    private int cptObjects;

    public flyLegacyTranslatorImpl(Point2D currentTile, IProcessor processor, String folderPath) {
        this.currentTile = currentTile;
        this.processor = processor;
        this.folderPath = folderPath;
        File file = new File(GuiOptionsHelper.getOptions().getCurrentFilePath());
        String fileName = file.getName().substring(0, file.getName().indexOf("."));
        this.txtFile = new File(String.valueOf(this.folderPath) + File.separator + fileName + "_" + currentTile.x + "_" + currentTile.y + ".ofe");
        this.writeAreaHeader(currentTile);
    }

    public flyLegacyTranslatorImpl() {
    }

    private void writeAreaHeader(Point2D coordinates) {
        int latitude = (int)coordinates.x;
        int longitude = (int)coordinates.y;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Area SW[" + latitude + "," + longitude + "]");
        stringBuilder.append(" NE[" + (latitude + 1) + "," + (longitude + 1) + "]\n");
        FilesUtils.writeTextToFile(this.txtFile, stringBuilder.toString(), true);
    }

    @Override
    public void processNode(Node node) throws Osm2xpException {
        if (GeomUtils.compareCoordinates(this.currentTile, node)) {
            this.processor.storeNode(node);
        }
    }

    @Override
    public void processWay(Way way) throws Osm2xpException {
        LinearRing2D polygon = new LinearRing2D();
        List<Node> nodeList = this.processor.getNodes(way.getNd());
        if (nodeList != null) {
            polygon = GeomUtils.getPolygonFromOsmNodes(nodeList);
            if (GuiOptionsHelper.getOptions().isSimplifyShapes()) {
                polygon = GeomUtils.simplifyPolygon(polygon);
            }
            if (OsmUtils.isBuilding(way.getTag()) || OsmUtils.getMatchingTag(FlyLegacyOptionsHelper.getOptions().getWatchedTagsList().getTags(), way.getTag()) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                polygon.removePoint(polygon.getLastPoint());
                stringBuilder.append("Start " + ++this.cptObjects + " id=" + way.getId() + "\n");
                OsmTag matchingTag = OsmUtils.getMatchingTag(FlyLegacyOptionsHelper.getOptions().getWatchedTagsList().getTags(), way.getTag());
                if (matchingTag != null) {
                    stringBuilder.append("tag(" + matchingTag.getKey() + "=" + matchingTag.getValue() + ")\n");
                }
                for (Point2D point2d : polygon.getVertices()) {
                    stringBuilder.append("V(" + point2d.x + "," + point2d.y + ")\n");
                }
                FilesUtils.writeTextToFile(this.txtFile, stringBuilder.toString(), true);
            }
        }
    }

    @Override
    public void processRelation(Relation relation) throws Osm2xpException {
    }

    @Override
    public void complete() {
        FilesUtils.writeTextToFile(this.txtFile, "END", true);
        Osm2xpLogger.info("Fly! Legacy buildings file finished.");
    }

    @Override
    public void init() throws Osm2xpException {
        Osm2xpLogger.info("Starting Fly! Legacy file for tile " + this.currentTile.x + "/" + this.currentTile.y + ".");
    }

    @Override
    public String getDescription() {
        return "Fly! Legacy output mode \n \nGenerate a .ofe file for Fly!Legacy.";
    }

    @Override
    public Image getLogo() {
        return ResourceManager.getPluginImage("com.osm2xp", TRANSLATOR_LOGO_PATH);
    }
}

