/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.facades.Facade;
import com.osm2xp.model.facades.FacadeSet;
import com.osm2xp.model.options.FacadeTagRule;
import com.osm2xp.model.options.ForestTagRule;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.utils.MiscUtils;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DsfObjectsProvider {
    private List<String> objectsList = new ArrayList<String>();
    private List<String> singlesFacadesList = new ArrayList<String>();
    private List<String> facadesList = new ArrayList<String>();
    private List<String> forestsList = new ArrayList<String>();
    private List<String> polygonsList = new ArrayList<String>();
    private List<String> streetLightObjectsList = new ArrayList<String>();
    private FacadeSet facadeSet;
    private List<Facade> slopedHousesList;
    private List<Facade> facadesWithRoofColorList;

    public DsfObjectsProvider(FacadeSet facadeSet) {
        try {
            this.facadeSet = facadeSet;
            this.computePolygonsList();
            this.compute3dObjectsList();
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error initializing Dsf objects provider.", e);
        }
    }

    public DsfObjectsProvider() {
    }

    public Integer computeFacadeDsfIndex(Boolean simpleBuilding, Boolean residential, Boolean slopedRoof, double minVector, double height, Color roofColor) {
        Integer result = null;
        if (residential.booleanValue()) {
            if (simpleBuilding.booleanValue()) {
                if (slopedRoof.booleanValue()) {
                    result = this.getRandomHouseSlopedFacade(minVector, height);
                    if (result == null) {
                        result = roofColor != null ? this.getRandomSimpleFootprintHouseFacadeWithRoofColor(height, roofColor) : this.getRandomSimpleFootprintHouseFacade(height);
                    }
                    if (result == null) {
                        return this.getRandomComplexFootprintHouseFacade(height);
                    }
                } else {
                    result = roofColor != null ? this.getRandomComplexFootprintHouseFacadeWithRoofColor(height, roofColor) : this.getRandomSimpleFootprintHouseFacade(height);
                    if (result == null) {
                        return this.getRandomComplexFootprintHouseFacade(height);
                    }
                }
            } else {
                result = this.getRandomComplexFootprintHouseFacade(height);
            }
        } else {
            result = simpleBuilding.booleanValue() ? (slopedRoof.booleanValue() ? this.getRandomBuildingSlopedFacade(minVector, height) : this.getRandomSimpleFootprintBuildingFacade(height)) : this.getRandomComplexFootprintBuildingFacade(height);
        }
        return result;
    }

    private Integer getRandomHouseSlopedFacade(double minVector, double height) {
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.getSlopedHousesList()) {
                if (!(facade.getMinVectorLength() <= minVector) || !(facade.getMaxVectorLength() >= minVector)) continue;
                return this.polygonsList.indexOf(facade.getFile());
            }
        }
        return null;
    }

    private Integer getRandomComplexFootprintBuildingFacade(double height) {
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.facadeSet.getFacades()) {
                if (!facade.isCommercial() && !facade.isIndustrial() || facade.isSimpleBuildingOnly()) continue;
                return this.polygonsList.indexOf(facade.getFile());
            }
        }
        return null;
    }

    private Integer getRandomSimpleFootprintBuildingFacade(double height) {
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.facadeSet.getFacades()) {
                if (!facade.isCommercial() && !facade.isIndustrial() || !facade.isSimpleBuildingOnly() || !((double)facade.getMinHeight() <= height) || facade.getMaxHeight() != 0 && (facade.getMaxHeight() == 0 || !((double)facade.getMaxHeight() >= height))) continue;
                return this.polygonsList.indexOf(facade.getFile());
            }
        }
        Osm2xpLogger.warning("No facade found for simple footprint building, with height=" + height);
        return null;
    }

    private Integer getRandomBuildingSlopedFacade(double minVector, double height) {
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.facadeSet.getFacades()) {
                if (!facade.isCommercial() && !facade.isIndustrial() || !facade.isSloped() || !(facade.getMinVectorLength() <= minVector) || !(facade.getMaxVectorLength() >= minVector)) continue;
                return this.polygonsList.indexOf(facade.getFile());
            }
        }
        return null;
    }

    private Integer getRandomComplexFootprintHouseFacade(double height) {
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.facadeSet.getFacades()) {
                if (!facade.isResidential() || facade.isSimpleBuildingOnly()) continue;
                return this.polygonsList.indexOf(facade.getFile());
            }
        }
        return null;
    }

    private Integer getRandomSimpleFootprintHouseFacade(double height) {
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.facadeSet.getFacades()) {
                if (!facade.isResidential() || !facade.isSimpleBuildingOnly() || facade.isSloped()) continue;
                return this.polygonsList.indexOf(facade.getFile());
            }
        }
        return null;
    }

    private Integer getRandomSimpleFootprintHouseFacadeWithRoofColor(double height, Color buildingColor) {
        Facade facadeResult = null;
        Integer result = null;
        Double colorDiff = null;
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.facadeSet.getFacades()) {
                if (facade.getRoofColor() == null || !facade.isResidential() || !facade.isSimpleBuildingOnly()) continue;
                String[] rgbValues = facade.getRoofColor().split(",");
                Color currentFacadeRoofColor = new Color(Integer.parseInt(rgbValues[0]), Integer.parseInt(rgbValues[1]), Integer.parseInt(rgbValues[2]));
                Double colorDifference = MiscUtils.colorDistance(buildingColor, currentFacadeRoofColor);
                if (colorDiff != null && !(colorDiff > colorDifference)) continue;
                colorDiff = colorDifference;
                facadeResult = facade;
            }
            if (facadeResult != null) {
                result = this.polygonsList.indexOf(facadeResult.getFile());
                System.out.println(facadeResult.getFile());
            }
        }
        return result;
    }

    private Integer getRandomComplexFootprintHouseFacadeWithRoofColor(double height, Color buildingColor) {
        Facade facadeResult = null;
        Integer result = null;
        Double colorDiff = null;
        if (this.facadeSet != null) {
            Collections.shuffle(this.facadeSet.getFacades());
            for (Facade facade : this.facadeSet.getFacades()) {
                if (!StringUtils.isNotBlank((String)facade.getRoofColor()) || !facade.isResidential()) continue;
                String[] rgbValues = facade.getRoofColor().split(",");
                Color currentFacadeRoofColor = new Color(Integer.parseInt(rgbValues[0]), Integer.parseInt(rgbValues[1]), Integer.parseInt(rgbValues[2]));
                System.out.println("buildingColor= " + buildingColor.getRed() + "," + buildingColor.getGreen() + "," + buildingColor.getBlue());
                System.out.println("facadeColor= " + currentFacadeRoofColor.getRed() + "," + currentFacadeRoofColor.getGreen() + "," + currentFacadeRoofColor.getBlue());
                System.out.println("color diff=" + MiscUtils.colorDistance(buildingColor, currentFacadeRoofColor));
                Double colorDifference = MiscUtils.colorDistance(buildingColor, currentFacadeRoofColor);
                if (colorDiff != null && !(colorDiff > colorDifference)) continue;
                colorDiff = colorDifference;
                facadeResult = facade;
            }
            if (facadeResult != null) {
                result = this.polygonsList.indexOf(facadeResult.getFile());
                System.out.println(facadeResult.getFile());
            }
        }
        return result;
    }

    public void computePolygonsList() throws Osm2xpException {
        if (this.facadeSet != null) {
            this.facadesList.clear();
            this.forestsList.clear();
            this.polygonsList.clear();
            this.singlesFacadesList.clear();
            for (Facade facade : this.facadeSet.getFacades()) {
                this.facadesList.add(facade.getFile());
            }
            for (FacadeTagRule facadeTagRule : XplaneOptionsHelper.getOptions().getFacadesRules().getRules()) {
                for (ObjectFile file : facadeTagRule.getObjectsFiles()) {
                    if (this.singlesFacadesList.contains(file.getPath())) continue;
                    this.singlesFacadesList.add(file.getPath());
                }
            }
            for (ForestTagRule forest : XplaneOptionsHelper.getOptions().getForestsRules().getRules()) {
                for (ObjectFile file : forest.getObjectsFiles()) {
                    if (this.forestsList.contains(file.getPath())) continue;
                    this.forestsList.add(file.getPath());
                }
            }
            this.polygonsList.addAll(this.singlesFacadesList);
            this.polygonsList.addAll(this.forestsList);
            this.polygonsList.addAll(this.facadesList);
        }
    }

    public void compute3dObjectsList() {
        this.objectsList.clear();
        for (ObjectTagRule object : XplaneOptionsHelper.getOptions().getObjectsRules().getRules()) {
            for (ObjectFile file : object.getObjectsFiles()) {
                if (this.objectsList.contains(file.getPath())) continue;
                this.objectsList.add(file.getPath());
            }
        }
        if (XplaneOptionsHelper.getOptions().isGenerateStreetLights()) {
            for (ObjectFile file : XplaneOptionsHelper.getOptions().getStreetLightObjects().getObjects()) {
                if (this.objectsList.contains(file.getPath())) continue;
                this.objectsList.add(file.getPath());
                this.streetLightObjectsList.add(file.getPath());
            }
        }
    }

    public Integer getRandomSingleFacade(FacadeTagRule facadeTagRule) {
        Collections.shuffle(this.singlesFacadesList);
        String randomSingleFacade = this.singlesFacadesList.get(0);
        return this.polygonsList.indexOf(randomSingleFacade);
    }

    public Integer getRandomObject(ObjectTagRule objectTagRule) {
        Collections.shuffle(objectTagRule.getObjectsFiles());
        String objectFile = objectTagRule.getObjectsFiles().get(0).getPath();
        return this.objectsList.indexOf(objectFile);
    }

    public Integer getRandomStreetLightObject() {
        Collections.shuffle(this.streetLightObjectsList);
        String objectFile = this.streetLightObjectsList.get(0);
        return this.objectsList.indexOf(objectFile);
    }

    public Integer getRandomForest(ForestTagRule forestTagRule) {
        Collections.shuffle(forestTagRule.getObjectsFiles());
        String forestFile = forestTagRule.getObjectsFiles().get(0).getPath();
        return this.polygonsList.indexOf(forestFile);
    }

    public List<String> getObjectsList() {
        return this.objectsList;
    }

    public void setObjectsList(List<String> objectsList) {
        this.objectsList = objectsList;
    }

    public List<String> getSinglesFacadesList() {
        return this.singlesFacadesList;
    }

    public void setSinglesFacadesList(List<String> singlesFacadesList) {
        this.singlesFacadesList = singlesFacadesList;
    }

    public List<String> getFacadesList() {
        return this.facadesList;
    }

    public void setFacadesList(List<String> facadesList) {
        this.facadesList = facadesList;
    }

    public List<String> getForestsList() {
        return this.forestsList;
    }

    public void setForestsList(List<String> forestsList) {
        this.forestsList = forestsList;
    }

    public List<String> getPolygonsList() {
        return this.polygonsList;
    }

    public void setPolygonsList(List<String> polygonsList) {
        this.polygonsList = polygonsList;
    }

    public List<String> getStreetLightObjectsList() {
        return this.streetLightObjectsList;
    }

    public void setStreetLightObjectsList(List<String> streetLightObjectsList) {
        this.streetLightObjectsList = streetLightObjectsList;
    }

    private void computeSlopedHousesFacadesList() {
        this.slopedHousesList = new ArrayList<Facade>();
        for (Facade facade : this.facadeSet.getFacades()) {
            if (!facade.isResidential() || !facade.isSloped()) continue;
            this.slopedHousesList.add(facade);
        }
    }

    private void computeFacadesWithRoofColorList() {
        this.facadesWithRoofColorList = new ArrayList<Facade>();
        for (Facade facade : this.facadeSet.getFacades()) {
            if (facade.getRoofColor() == null) continue;
            this.facadesWithRoofColorList.add(facade);
        }
    }

    public List<Facade> getFacadesWithRoofColorList() {
        if (this.facadesWithRoofColorList == null) {
            this.computeFacadesWithRoofColorList();
        }
        return this.facadesWithRoofColorList;
    }

    public List<Facade> getSlopedHousesList() {
        if (this.slopedHousesList == null) {
            this.computeSlopedHousesFacadesList();
        }
        return this.slopedHousesList;
    }
}

