/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils;

import com.osm2xp.constants.Osm2xpConstants;
import com.osm2xp.model.options.ForestTagRule;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.model.osm.Tag;
import com.osm2xp.utils.DsfObjectsProvider;
import com.osm2xp.utils.MiscUtils;
import com.osm2xp.utils.OsmUtils;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import math.geom2d.Point2D;

public class DsfUtils {
    public static String getDsfToolPath() {
        String dsfTool = MiscUtils.isWindows() ? String.valueOf(Osm2xpConstants.UTILS_PATH) + File.separatorChar + "DSFTool.exe" : (MiscUtils.isMac() ? String.valueOf(Osm2xpConstants.UTILS_PATH) + File.separatorChar + "DSFToolMac" : String.valueOf(Osm2xpConstants.UTILS_PATH) + File.separatorChar + "DSFToolLinux");
        return dsfTool;
    }

    public static void textToDsf(File textFile, File dsfFile) {
        try {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec(new String[]{DsfUtils.getDsfToolPath(), "--text2dsf", textFile.getPath(), dsfFile.getPath()});
        }
        catch (IOException e) {
            Osm2xpLogger.error("Error on .dsf conversion.", e);
        }
    }

    public static String[] getFolderAndFileNames(Point2D coordinates) {
        int latitude = (int)coordinates.x;
        int longitude = (int)coordinates.y;
        Double dossierFirst = new Double(latitude);
        Double dossierEnd = new Double(longitude);
        while (dossierFirst % 10.0 != 0.0) {
            dossierFirst = dossierFirst - 1.0;
        }
        while (dossierEnd % 10.0 != 0.0) {
            dossierEnd = dossierEnd - 1.0;
        }
        DecimalFormat dfLat = (DecimalFormat)DecimalFormat.getNumberInstance();
        dfLat.applyPattern("00");
        DecimalFormat dfLong = (DecimalFormat)DecimalFormat.getNumberInstance();
        dfLong.applyPattern("000");
        StringBuffer fichier = new StringBuffer();
        StringBuffer dossier = new StringBuffer();
        if (latitude >= 0) {
            fichier.append("+");
            dossier.append("+");
        }
        fichier.append(dfLat.format(latitude));
        dossier.append(dfLat.format(dossierFirst));
        if (longitude >= 0) {
            fichier.append("+");
            dossier.append("+");
        }
        fichier.append(dfLong.format(longitude));
        dossier.append(dfLong.format(dossierEnd));
        String nomFichier = fichier.toString();
        String nomRepertoire = dossier.toString();
        String[] result = new String[]{nomRepertoire, nomFichier};
        return result;
    }

    public static String getDsfExclusions(String tileCoordinate) {
        StringBuilder sb = new StringBuilder();
        if (XplaneOptionsHelper.getOptions().isExcludeObj()) {
            sb.append("PROPERTY sim/exclude_obj " + tileCoordinate);
        }
        if (XplaneOptionsHelper.getOptions().isExcludeFac()) {
            sb.append("PROPERTY sim/exclude_fac " + tileCoordinate);
        }
        if (XplaneOptionsHelper.getOptions().isExcludeFor()) {
            sb.append("PROPERTY sim/exclude_for " + tileCoordinate);
        }
        if (XplaneOptionsHelper.getOptions().isExcludeNet()) {
            sb.append("PROPERTY sim/exclude_net " + tileCoordinate);
        }
        if (XplaneOptionsHelper.getOptions().isExcludeLin()) {
            sb.append("PROPERTY sim/exclude_lin " + tileCoordinate);
        }
        if (XplaneOptionsHelper.getOptions().isExcludeStr()) {
            sb.append("PROPERTY sim/exclude_str " + tileCoordinate);
        }
        if (GuiOptionsHelper.getOptions().getOutputFormat().equals("Xplane 10")) {
            if (XplaneOptionsHelper.getOptions().isExcludePol()) {
                sb.append("PROPERTY sim/exclude_pol " + tileCoordinate);
            }
            if (XplaneOptionsHelper.getOptions().isExcludeBch()) {
                sb.append("PROPERTY sim/exclude_bch " + tileCoordinate);
            }
        }
        return sb.toString();
    }

    public static String getDsfHeader(Point2D coordinates, DsfObjectsProvider dsfObjectsProvider) {
        StringBuilder sb = new StringBuilder();
        int latitude = (int)coordinates.x;
        int longitude = (int)coordinates.y;
        String tileCoordinate = String.valueOf(longitude) + ".000000/" + latitude + ".000000/" + (longitude + 1) + ".000000/" + (latitude + 1) + ".000000\n";
        sb.append("I\n");
        sb.append("800\n");
        sb.append("DSF2TEXT\n\n");
        sb.append("PROPERTY sim/planet earth\n");
        sb.append("PROPERTY sim/overlay 1\n");
        if (XplaneOptionsHelper.getOptions().isGenerateStreetLights()) {
            int requireIndex = dsfObjectsProvider.getStreetLightObjectsList().size();
            sb.append("PROPERTY sim/require_object 1/" + requireIndex + "\n");
        } else {
            sb.append("PROPERTY sim/require_object 1/0\n");
        }
        sb.append("PROPERTY sim/require_facade 6/0\n");
        sb.append("PROPERTY sim/creation_agent Osm2Xp 2.0.2 by Benjamin Blanchet \n");
        sb.append(DsfUtils.getDsfExclusions(tileCoordinate));
        sb.append("PROPERTY sim/west " + longitude + "\n");
        sb.append("PROPERTY sim/east " + (longitude + 1) + "\n");
        sb.append("PROPERTY sim/north " + (latitude + 1) + "\n");
        sb.append("PROPERTY sim/south " + latitude + "\n\n");
        if (dsfObjectsProvider.getSinglesFacadesList() != null) {
            for (String facadeTagRule : dsfObjectsProvider.getSinglesFacadesList()) {
                sb.append("POLYGON_DEF singlesFacades\\" + facadeTagRule + "\n");
            }
        }
        if (dsfObjectsProvider.getForestsList() != null) {
            for (String forest : dsfObjectsProvider.getForestsList()) {
                sb.append("POLYGON_DEF " + forest + "\n");
            }
        }
        if (dsfObjectsProvider.getFacadesList() != null) {
            for (String facade : dsfObjectsProvider.getFacadesList()) {
                String facadeDeclaration = null;
                facadeDeclaration = !XplaneOptionsHelper.getOptions().isPackageFacades() ? "POLYGON_DEF \\lib\\osm2xp\\facades\\" + facade + "\n" : "POLYGON_DEF facades\\" + facade + "\n";
                sb.append(facadeDeclaration);
            }
            sb.append("\n");
        }
        if (dsfObjectsProvider.getObjectsList() != null) {
            for (String objectPath : dsfObjectsProvider.getObjectsList()) {
                sb.append("OBJECT_DEF " + objectPath + "\n");
            }
        }
        return sb.toString();
    }

    public static Integer[] getRandomDsfObjectIndexAndAngle(List<Tag> tags, Long id, DsfObjectsProvider dsfObjectsProvider) {
        for (Tag tag : tags) {
            for (ObjectTagRule objectTagRule : XplaneOptionsHelper.getOptions().getObjectsRules().getRules()) {
                if ((!objectTagRule.getTag().getKey().equalsIgnoreCase("id") || !objectTagRule.getTag().getValue().equalsIgnoreCase(String.valueOf(id))) && !OsmUtils.compareTags(objectTagRule.getTag(), tag)) continue;
                Integer[] result = new Integer[2];
                result[0] = dsfObjectsProvider.getRandomObject(objectTagRule);
                if (objectTagRule.isRandomAngle()) {
                    Random randomGenerator = new Random();
                    result[1] = randomGenerator.nextInt(360);
                } else {
                    result[1] = objectTagRule.getAngle();
                }
                return result;
            }
        }
        return null;
    }

    public static Integer[] getRandomForestIndexAndDensity(List<Tag> tags, DsfObjectsProvider dsfObjectsProvider) {
        for (Tag tag : tags) {
            for (ForestTagRule forestTagRule : XplaneOptionsHelper.getOptions().getForestsRules().getRules()) {
                if (!OsmUtils.compareTags(forestTagRule.getTag(), tag)) continue;
                Integer[] result = new Integer[]{dsfObjectsProvider.getRandomForest(forestTagRule), forestTagRule.getForestDensity()};
                return result;
            }
        }
        return null;
    }
}

