/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils;

import com.osm2xp.constants.Osm2xpConstants;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.utils.WindowsExplorerComparator;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilesUtils {
    public static Map<Long, Color> loadG2xplColorFile(File file) throws Osm2xpException {
        HashMap<Long, Color> result = new HashMap<Long, Color>();
        try {
            BufferedReader buff = new BufferedReader(new FileReader(file.getPath()));
            try {
                String line;
                while ((line = buff.readLine()) != null) {
                    Long wayId = Long.parseLong(line.substring(0, line.indexOf(":")));
                    String lineWork = line;
                    Integer blue = Integer.parseInt(lineWork.substring(lineWork.lastIndexOf(",") + 1, lineWork.length()));
                    lineWork = lineWork.substring(0, lineWork.lastIndexOf(","));
                    Integer green = Integer.parseInt(lineWork.substring(lineWork.lastIndexOf(",") + 1, lineWork.length()));
                    lineWork = lineWork.substring(0, lineWork.lastIndexOf(","));
                    Integer red = Integer.parseInt(lineWork.substring(lineWork.lastIndexOf(",") + 1, lineWork.length()));
                    Color roofColor = new Color(red, green, blue);
                    result.put(wayId, roofColor);
                }
            }
            finally {
                buff.close();
            }
        }
        catch (IOException e) {
            throw new Osm2xpException("Error parsing g2xpl roof color file " + e.getMessage());
        }
        return result;
    }

    public static void writeTextToFile(File file, String text, Boolean append) {
        if (text != null) {
            if (!new File(file.getParent()).exists()) {
                new File(file.getParent()).mkdirs();
            }
            try {
                FileWriter writer = new FileWriter(file.getPath(), (boolean)append);
                BufferedWriter output = new BufferedWriter(writer);
                output.write(text);
                output.flush();
                output.close();
            }
            catch (IOException e) {
                Osm2xpLogger.error("Error writing to file " + file.getName(), e);
            }
        }
    }

    public static List<String> listFacadesSets() throws Osm2xpException {
        ArrayList<String> listeSetsFacades = new ArrayList<String>();
        File repertoire = new File(Osm2xpConstants.FACADES_SETS_PATH);
        File[] list = repertoire.listFiles();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].isDirectory()) {
                    listeSetsFacades.add(list[i].getName());
                }
                ++i;
            }
        }
        if (listeSetsFacades.isEmpty()) {
            throw new Osm2xpException("No facades sets found in /ressources/facades!");
        }
        return listeSetsFacades;
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                FilesUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                ++i;
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static String[] listFacadesFiles(String facadeSetFolder) {
        FilenameFilter facFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().contains(".fac");
            }
        };
        String[] files = new File(facadeSetFolder).list(facFilter);
        Arrays.sort(files, new WindowsExplorerComparator());
        return files;
    }

    public static void deleteDirectory(File folder) {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FilesUtils.deleteDirectory(file);
            } else {
                file.delete();
            }
            ++n2;
        }
        folder.delete();
    }
}

