/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils;

import SGImplify.SGImplify;
import Tuple.Tuple2f;
import com.osm2xp.model.geom.Lod13Location;
import com.osm2xp.model.osm.Node;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import math.geom2d.Angle2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.SimplePolygon2D;
import org.opencarto.algo.ShortEdgesDeletion;

public class GeomUtils {
    public static double[] computeExtremeVectors(LinearRing2D polygon) {
        Double minVector = null;
        Double maxVector = null;
        for (LineSegment2D segment : polygon.getEdges()) {
            if (minVector == null || minVector > segment.getLength()) {
                minVector = segment.getLength();
            }
            if (maxVector != null && !(maxVector < segment.getLength())) continue;
            maxVector = segment.getLength();
        }
        minVector = minVector * 10000.0;
        maxVector = maxVector * 10000.0;
        return new double[]{minVector, maxVector};
    }

    public static boolean compareCoordinates(math.geom2d.Point2D pointA, math.geom2d.Point2D pointB) {
        return (int)Math.floor(pointA.x) == (int)Math.floor(pointB.x) && (int)Math.floor(pointA.y) == (int)Math.floor(pointB.y);
    }

    public static boolean isListOfNodesOnTile(math.geom2d.Point2D tile, List<Node> nodes) {
        for (Node node : nodes) {
            if (GeomUtils.compareCoordinates(tile, node)) continue;
            return false;
        }
        return true;
    }

    public static LineSegment2D getLargestVector(LinearRing2D linearRing2D) {
        LineSegment2D result = null;
        for (LineSegment2D loc : linearRing2D.getEdges()) {
            if (result != null && !(loc.getLength() > result.getLength())) continue;
            result = loc;
        }
        return result;
    }

    public static LinearRing2D simplifyLine2D(LinearRing2D polygon) {
        try {
            boolean isAreaChangeMinimal;
            ArrayList<Tuple2f> tuples = new ArrayList<Tuple2f>();
            for (math.geom2d.Point2D pt : polygon.getVertices()) {
                Tuple2f tuple2f = new Tuple2f((float)pt.x, (float)pt.y);
                tuples.add(tuple2f);
            }
            Tuple2f[] tuplesTab = tuples.toArray(new Tuple2f[tuples.size()]);
            Tuple2f[] tuplesmod = SGImplify.simplifyLine2D((float)3.0E-5f, (Tuple2f[])tuplesTab);
            ArrayList<math.geom2d.Point2D> cleanedPoints = new ArrayList<math.geom2d.Point2D>();
            int i = 0;
            while (i < tuplesmod.length) {
                math.geom2d.Point2D point2d = new math.geom2d.Point2D((double)tuplesmod[i].x, (double)tuplesmod[i].y);
                cleanedPoints.add(point2d);
                ++i;
            }
            LinearRing2D result = new LinearRing2D(cleanedPoints);
            boolean isOnSingleTile = GeomUtils.isLinearRingOnASingleTile(result);
            boolean isASimpleFootprint = result.getVertexNumber() == 5;
            boolean bl = isAreaChangeMinimal = GeomUtils.linearRing2DToPolygon(result).getArea() > GeomUtils.linearRing2DToPolygon(polygon).getArea() / 1.5;
            if (isOnSingleTile && isASimpleFootprint && isAreaChangeMinimal) {
                return result;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Polygon linearRing2DToPolygon(LinearRing2D linearRing2D) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (math.geom2d.Point2D pt : linearRing2D.getVertices()) {
            Coordinate coordinate = new Coordinate(pt.x, pt.y, 1.0);
            coordinates.add(coordinate);
        }
        Coordinate[] coordinatesTab = coordinates.toArray(new Coordinate[coordinates.size()]);
        CoordinateArraySequence coordinateArraySequence = new CoordinateArraySequence(coordinatesTab);
        LinearRing linearRing = new LinearRing((CoordinateSequence)coordinateArraySequence, new GeometryFactory());
        Polygon jtsPoly = new Polygon(linearRing, null, new GeometryFactory());
        return jtsPoly;
    }

    private static LinearRing2D polygonToLinearRing2D(Geometry polygon) {
        ArrayList<math.geom2d.Point2D> points = new ArrayList<math.geom2d.Point2D>();
        Coordinate[] coordinateArray = polygon.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            math.geom2d.Point2D point2d = new math.geom2d.Point2D(coordinate.x, coordinate.y);
            points.add(point2d);
            ++n2;
        }
        return new LinearRing2D(points);
    }

    private static Boolean isLinearRingOnASingleTile(LinearRing2D linearRing2D) {
        for (math.geom2d.Point2D point : linearRing2D.getVertices()) {
            if (GeomUtils.compareCoordinates(linearRing2D.getFirstPoint(), point)) continue;
            return false;
        }
        return true;
    }

    public static boolean areParallelsSegmentsIdentics(LinearRing2D linearRing2D) {
        if (linearRing2D.getVertexNumber() == 5) {
            boolean sameLength2;
            LineSegment2D line1 = new LineSegment2D((Point2D)linearRing2D.getVertex(0), (Point2D)linearRing2D.getVertex(1));
            LineSegment2D line2 = new LineSegment2D((Point2D)linearRing2D.getVertex(1), (Point2D)linearRing2D.getVertex(2));
            LineSegment2D line3 = new LineSegment2D((Point2D)linearRing2D.getVertex(2), (Point2D)linearRing2D.getVertex(3));
            LineSegment2D line4 = new LineSegment2D((Point2D)linearRing2D.getVertex(3), (Point2D)linearRing2D.getVertex(4));
            double length1 = line1.getLength();
            double length2 = line2.getLength();
            double length3 = line3.getLength();
            double length4 = line4.getLength();
            double diff1 = Math.abs(length1 - length3);
            double diff2 = Math.abs(length2 - length4);
            boolean sameLength1 = diff1 < line1.getLength() / 10.0;
            boolean bl = sameLength2 = diff2 < line2.getLength() / 10.0;
            if (sameLength1 && sameLength2) {
                return true;
            }
        }
        return false;
    }

    public static LinearRing2D simplifyPolygon(LinearRing2D sourceFootprint) {
        LinearRing2D result = sourceFootprint;
        if (sourceFootprint.getVertexNumber() > 5 && (result = GeomUtils.ShortEdgesDeletion(sourceFootprint)) == null) {
            result = sourceFootprint;
        }
        return result;
    }

    public static LinearRing2D ShortEdgesDeletion(LinearRing2D sourceFootprint) {
        try {
            boolean isAreaChangeMinimal;
            Polygon sourcePoly = GeomUtils.linearRing2DToPolygon(sourceFootprint);
            Geometry cleanPoly = ShortEdgesDeletion.get((Polygon)sourcePoly, (double)5.0);
            LinearRing2D result = GeomUtils.polygonToLinearRing2D(cleanPoly);
            boolean isOnSingleTile = GeomUtils.isLinearRingOnASingleTile(result);
            boolean isASimpleFootprint = result.getVertexNumber() == 5;
            boolean bl = isAreaChangeMinimal = GeomUtils.linearRing2DToPolygon(result).getArea() > sourcePoly.getArea() / 1.5;
            if (isOnSingleTile && isASimpleFootprint && isAreaChangeMinimal) {
                return result;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Double[] getExtremesAngle(LinearRing2D polygon) {
        Double minAngle = null;
        Double maxAngle = null;
        int i = 0;
        while (i < polygon.getVertexNumber() - 2) {
            Double angle = Math.toDegrees(Angle2D.getAbsoluteAngle((Point2D)polygon.getVertex(i), (Point2D)polygon.getVertex(i + 1), (Point2D)polygon.getVertex(i + 2)));
            if (minAngle == null || angle < minAngle) {
                minAngle = angle;
            }
            if (maxAngle == null || angle > maxAngle) {
                maxAngle = angle;
            }
            ++i;
        }
        Double lastAngle = Math.toDegrees(Angle2D.getAbsoluteAngle((Point2D)polygon.getVertex(polygon.getVertexNumber() - 2), (Point2D)polygon.getVertex(0), (Point2D)polygon.getVertex(1)));
        if (minAngle == null || lastAngle < minAngle) {
            minAngle = lastAngle;
        }
        if (maxAngle == null || lastAngle > maxAngle) {
            maxAngle = lastAngle;
        }
        return new Double[]{minAngle, maxAngle};
    }

    public static LinearRing2D getPolygonFromOsmNodes(List<Node> nodes) {
        LinearRing2D result = new LinearRing2D();
        for (Node node : nodes) {
            result.addPoint(new math.geom2d.Point2D(node.getLat(), node.getLon()));
        }
        return result;
    }

    public static math.geom2d.Point2D getNodesCenter(List<Node> nodes) {
        LinearRing2D polygon = new LinearRing2D();
        for (Node node : nodes) {
            polygon.addPoint(new math.geom2d.Point2D(node.getLat(), node.getLon()));
        }
        math.geom2d.Point2D center = GeomUtils.getPolygonCenter(polygon);
        return center;
    }

    public static boolean compareCoordinates(math.geom2d.Point2D tile, Node node) {
        return (int)Math.floor(tile.x) == (int)Math.floor(node.getLat()) && (int)Math.floor(tile.y) == (int)Math.floor(node.getLon());
    }

    public static LinearRing2D setClockwise(LinearRing2D linearRing2D) {
        double clockwise = 0.0;
        int i = 0;
        while (i < linearRing2D.getVertices().size() - 1) {
            double a = linearRing2D.getVertex((int)(i + 1)).x - linearRing2D.getVertex((int)i).x;
            double b = linearRing2D.getVertex((int)(i + 1)).y + linearRing2D.getVertex((int)i).y;
            clockwise += a * b;
            ++i;
        }
        if (clockwise < 0.0) {
            Collection clockwiseVectors = linearRing2D.getReverseCurve().getVertices();
            linearRing2D.clearVertices();
            linearRing2D.getVertices().addAll(clockwiseVectors);
        }
        return linearRing2D;
    }

    public static math.geom2d.Point2D getPolygonCenter(LinearRing2D polygon) {
        SimplePolygon2D simplePolygon2D = new SimplePolygon2D(polygon.getSingularPoints());
        math.geom2d.Point2D pointCenter = simplePolygon2D.getCentroid();
        return pointCenter;
    }

    public static Lod13Location getLod13Location(double latitude, double longitude) {
        StringBuilder lod13String = new StringBuilder();
        double leftLong = -180.0;
        double rightLong = 300.0;
        double topLat = 90.0;
        double bottomLat = -270.0;
        int i = 0;
        while (i < 15) {
            double newBottomLat;
            double newTopLat;
            double newRightLong;
            double newLeftLong;
            int quadNumber;
            double centerLong = (leftLong + rightLong) / 2.0;
            double centerLat = (topLat + bottomLat) / 2.0;
            if (longitude < centerLong) {
                quadNumber = 0;
                newLeftLong = leftLong;
                newRightLong = centerLong;
            } else {
                quadNumber = 1;
                newLeftLong = centerLong;
                newRightLong = rightLong;
            }
            if (latitude > centerLat) {
                newTopLat = topLat;
                newBottomLat = centerLat;
            } else {
                quadNumber += 2;
                newTopLat = centerLat;
                newBottomLat = bottomLat;
            }
            lod13String.append(quadNumber);
            leftLong = newLeftLong;
            rightLong = newRightLong;
            topLat = newTopLat;
            bottomLat = newBottomLat;
            ++i;
        }
        double xOffset = (longitude - leftLong) / (rightLong - leftLong);
        double yOffset = (topLat - latitude) / (topLat - bottomLat);
        Lod13Location location = new Lod13Location();
        location.setLod13String(lod13String.toString());
        location.setxOffset(xOffset);
        location.setyOffset(yOffset);
        return location;
    }
}

