/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils;

import com.osm2xp.utils.StreamGobbler;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.awt.Color;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class MiscUtils {
    public static String getPerspectiveId(String outputMode) {
        String perspectiveID = null;
        perspectiveID = outputMode.equalsIgnoreCase("Xplane 9") ? "com.osm2xp.xplane9ConfigurationPerspective" : (outputMode.equalsIgnoreCase("Xplane 10") ? "com.osm2xp.xplane10ConfigurationPerspective" : (outputMode.equalsIgnoreCase("Flight Simulator X") ? "com.osm2xp.fsxConfigurationPerspective" : (outputMode.equalsIgnoreCase("WaveFront (.obj)") ? "com.osm2xp.wavefrontConfigurationPerspective" : (outputMode.equalsIgnoreCase("Fly! Legacy") ? "com.osm2xp.flyLegacyConfigurationPerspective" : "com.osm2xp.minimalPerspective"))));
        return perspectiveID;
    }

    public static void switchPerspective(String outputMode) {
        IWorkbench workbench;
        String perspectiveID = MiscUtils.getPerspectiveId(outputMode);
        if (perspectiveID != null && (workbench = PlatformUI.getWorkbench()) != null) {
            try {
                workbench.showPerspective(perspectiveID, workbench.getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                Osm2xpLogger.warning("Error switching perspective", e);
            }
        }
    }

    private static String getOnlyNumerics(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer strBuff = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isDigit(c) || Character.toString(c).equals(".")) {
                strBuff.append(c);
            }
            ++i;
        }
        return strBuff.toString();
    }

    public static Integer extractNumbers(String value) {
        value = value.replaceAll(",", ".");
        value = MiscUtils.getOnlyNumerics(value);
        try {
            if (value != null && !value.equals("")) {
                return (int)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            Osm2xpLogger.warning("Error extracting height from osm tag, input :" + value, e);
        }
        return null;
    }

    public static Integer getRandomSize(Integer min, Integer max) {
        if (min.equals(max)) {
            return max;
        }
        Random randomGenerator = new Random();
        return randomGenerator.nextInt(max - min) + min;
    }

    public static String getTimeDiff(Date dateOne, Date dateTwo) {
        long timeDiff = Math.abs(dateOne.getTime() - dateTwo.getTime());
        long hours = TimeUnit.MILLISECONDS.toHours(timeDiff);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timeDiff) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(timeDiff));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timeDiff) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(timeDiff));
        return String.valueOf(hours) + "h" + minutes + "m" + seconds + "s";
    }

    public static boolean isWindows() {
        return System.getProperties().get("os.name").toString().toLowerCase().contains("windows");
    }

    public static boolean isMac() {
        return System.getProperties().get("os.name").toString().toLowerCase().contains("mac");
    }

    public static void execProgramm(String command) {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static double colorDistance(Color color1, Color color2) {
        double a = color2.getRed() - color1.getRed();
        double b = color2.getGreen() - color1.getGreen();
        double c = color2.getBlue() - color1.getBlue();
        return Math.sqrt(a * a + b * b + c * c);
    }
}

