/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils;

import com.osm2xp.model.options.ForestTagRule;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.model.osm.Nd;
import com.osm2xp.model.osm.Node;
import com.osm2xp.model.osm.Tag;
import com.osm2xp.model.osm.Way;
import com.osm2xp.utils.MiscUtils;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Normalizer;
import java.util.List;
import java.util.regex.Pattern;

public class OsmUtils {
    public static boolean isStringInTags(String value, List<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getK().toLowerCase().contains(value) && !tag.getV().toLowerCase().contains(value)) continue;
            return true;
        }
        return false;
    }

    public static Color getRoofColorFromTags(List<Tag> tagsList) {
        Color result = null;
        for (Tag tag : tagsList) {
            if (!tag.getK().contains("roof:color")) continue;
            try {
                result = Color.decode(tag.getV());
            }
            catch (Exception exception) {
                Osm2xpLogger.warning("Failed to extract color information for value " + tag.getV());
            }
        }
        return result;
    }

    public static OsmTag getMatchingTag(List<OsmTag> tagsList1, List<Tag> tagsList2) {
        for (OsmTag tag : tagsList1) {
            if (!OsmUtils.isTagInTagsList(tag.getKey(), tag.getValue(), tagsList2)) continue;
            return tag;
        }
        return null;
    }

    public static boolean isTagInTagsList(String key, String value, List<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getK().equalsIgnoreCase(key) || !tag.getV().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExcluded(List<Tag> tags, Long id) {
        for (Tag tag : tags) {
            for (OsmTag userTag : XplaneOptionsHelper.getOptions().getBuildingsExclusions().getExclusions()) {
                if ((!userTag.getKey().equalsIgnoreCase("id") || !userTag.getValue().equalsIgnoreCase(String.valueOf(id))) && !OsmUtils.compareTags(userTag, tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValueinTags(String value, List<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getV().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObject(List<Tag> tags) {
        for (Tag tag : tags) {
            for (ObjectTagRule objectTagRule : XplaneOptionsHelper.getOptions().getObjectsRules().getRules()) {
                if (!OsmUtils.compareTags(objectTagRule.getTag(), tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isForest(List<Tag> tags) {
        for (Tag tag : tags) {
            for (ForestTagRule forestTagsRule : XplaneOptionsHelper.getOptions().getForestsRules().getRules()) {
                if (!OsmUtils.compareTags(forestTagsRule.getTag(), tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean compareTags(OsmTag userTag, Tag tag) {
        return userTag.getKey().equalsIgnoreCase(tag.getK()) && userTag.getValue().equalsIgnoreCase(tag.getV());
    }

    public static boolean isBuilding(List<Tag> tags) {
        return OsmUtils.isStringInTags("building", tags) && !OsmUtils.isTagInTagsList("wall", "no", tags);
    }

    public static String getNormalizedTagText(Tag tag) {
        if (!(tag.getK().toLowerCase().contains("source") || tag.getK().toLowerCase().contains("name") || tag.getK().toLowerCase().contains("addr") || tag.getK().toLowerCase().contains("description") || tag.getK().toLowerCase().contains("fixme") || tag.getK().toLowerCase().contains("todo"))) {
            String value = tag.getV().replace("&", "&amp;");
            value = value.replace("\"", "&quot;");
            value = value.replace("'", "&apos;");
            value = value.replace("<", "&gt;");
            value = value.replace(">", "&apos;");
            String temp = Normalizer.normalize(value, Normalizer.Form.NFD);
            Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
            value = pattern.matcher(temp).replaceAll("");
            tag.setV(Normalizer.normalize(tag.getV(), Normalizer.Form.NFKD));
            return "<tag k=\"" + tag.getK() + "\" v=\"" + value + "\"/>\n";
        }
        return null;
    }

    public static Integer getHeightFromTags(List<Tag> tags) {
        for (Tag tag : tags) {
            int height;
            Integer levels;
            Integer height2;
            if (tag.getK().toLowerCase().contains("max") || tag.getK().toLowerCase().contains("min")) continue;
            if (tag.getK().toLowerCase().contains("height") && tag.getV().length() < 11 && (height2 = MiscUtils.extractNumbers(tag.getV())) != null && height2 < 800 && height2 > 4) {
                return height2;
            }
            if (!tag.getK().toLowerCase().contains("level") || tag.getV().contains("-1") || tag.getV().length() >= 5 || (levels = MiscUtils.extractNumbers(tag.getV())) == null || (height = levels * 3 + 1) >= 800 || height <= 4) continue;
            return height;
        }
        return null;
    }

    public static String CreateTempFile(String folderPath, List<Node> nodeList, List<Way> wayList, String fileName) throws IOException {
        FileWriter writer = null;
        String filePath = String.valueOf(folderPath) + File.separator + fileName + ".osm";
        writer = new FileWriter(filePath, false);
        BufferedWriter output = new BufferedWriter(writer);
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("<osm version=\"0.6\" generator=\"osm2xp 2.0.2\">\n");
        for (Node node : nodeList) {
            output.write("<node id=\"" + node.getId() + "\" lat=\"" + node.getLat() + "\" lon=\"" + node.getLon() + "\" version=\"1\" />\n");
        }
        for (Way way : wayList) {
            output.write("<way id=\"" + way.getId() + "\" visible=\"true\" version=\"2\" >\n");
            for (Nd nd : way.getNd()) {
                output.write("<nd ref=\"" + nd.getRef() + "\"/>\n");
            }
            for (Tag tag : way.getTag()) {
                String normalizedTag = OsmUtils.getNormalizedTagText(tag);
                if (normalizedTag == null) continue;
                output.write(normalizedTag);
            }
            output.write("</way>\n");
        }
        output.write("</osm>");
        output.flush();
        new File(filePath).deleteOnExit();
        return filePath;
    }

    public static String CreateTempFile(String folderPath, List<Node> nodeList, Way way) throws IOException {
        FileWriter writer = null;
        String filePath = String.valueOf(folderPath) + File.separator + way.getId() + ".osm";
        writer = new FileWriter(filePath, false);
        BufferedWriter output = new BufferedWriter(writer);
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("<osm version=\"0.6\" generator=\"osm2xp 2.0.2\">\n");
        for (Node node : nodeList) {
            output.write("<node id=\"" + node.getId() + "\" lat=\"" + node.getLat() + "\" lon=\"" + node.getLon() + "\" version=\"1\" />\n");
        }
        output.write("<way id=\"" + way.getId() + "\" visible=\"true\" version=\"2\" >\n");
        for (Nd nd : way.getNd()) {
            output.write("<nd ref=\"" + nd.getRef() + "\"/>\n");
        }
        for (Tag tag : way.getTag()) {
            String normalizedTag = OsmUtils.getNormalizedTagText(tag);
            if (normalizedTag == null) continue;
            output.write(normalizedTag);
        }
        output.write("</way>\n");
        output.write("</osm>");
        output.flush();
        new File(filePath).deleteOnExit();
        return filePath;
    }
}

