/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.model.stats.BuildingStat;
import com.osm2xp.model.stats.ForestStat;
import com.osm2xp.model.stats.GenerationStats;
import com.osm2xp.model.stats.ObjectStat;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;

public class ChartsHelper {
    public static JFreeChart getRecapPieChart(GenerationStats stats) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        if (XplaneOptionsHelper.getOptions().isGenerateBuildings()) {
            dataset.setValue((Comparable)((Object)("Buildings(" + stats.getBuildingsNumber() + ")")), (double)stats.getBuildingsNumber());
        }
        if (XplaneOptionsHelper.getOptions().isGenerateFor()) {
            dataset.setValue((Comparable)((Object)("Forests(" + stats.getForestsNumber() + ")")), (double)stats.getForestsNumber());
        }
        if (XplaneOptionsHelper.getOptions().isGenerateObj()) {
            dataset.setValue((Comparable)((Object)("Objects(" + stats.getObjectsNumber() + ")")), (double)stats.getObjectsNumber());
        }
        if (XplaneOptionsHelper.getOptions().isGenerateStreetLights()) {
            dataset.setValue((Comparable)((Object)("Street lights(" + stats.getStreetlightsNumber() + ")")), (double)stats.getStreetlightsNumber());
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"Generated items", (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint((Paint)Color.WHITE);
        return chart;
    }

    public static JFreeChart getBuildingsPieChart(GenerationStats stats) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (BuildingStat stat : stats.getBuildingsStats().getBuildingStat()) {
            dataset.setValue((Comparable)((Object)(String.valueOf(stat.getType()) + " (" + stat.getNumber() + " / " + stat.getNumber() * 100 / stats.getBuildingsNumber() + "%)")), (double)stat.getNumber());
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"Buildings/houses repartition", (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint((Paint)Color.WHITE);
        return chart;
    }

    public static JFreeChart getObjectsPieChart(GenerationStats stats) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (ObjectStat stat : stats.getObjectsStats().getObjectStat()) {
            dataset.setValue((Comparable)((Object)(String.valueOf(stat.getObjectPath()) + " (" + stat.getNumber() + " / " + stat.getNumber() * 100 / stats.getObjectsNumber() + "%)")), (double)stat.getNumber());
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"Objects files", (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator(null);
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint((Paint)Color.WHITE);
        return chart;
    }

    public static JFreeChart getForestsPieChart(GenerationStats stats) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (ForestStat stat : stats.getForestsStats().getForestStat()) {
            dataset.setValue((Comparable)((Object)(String.valueOf(stat.getForestPath()) + " (" + stat.getNumber() + " / " + stat.getNumber() * 100 / stats.getForestsNumber() + "%)")), (double)stat.getNumber());
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"Forests files", (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator(null);
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint((Paint)Color.WHITE);
        return chart;
    }
}

