/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.facades.Facade;
import com.osm2xp.model.facades.FacadeSet;
import com.osm2xp.utils.FilesUtils;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class FacadeSetHelper {
    public static void saveFacadeSet(FacadeSet facadeSet, String facadeSetFolder) throws Osm2xpException {
        File facadeSetFile = new File(String.valueOf(facadeSetFolder) + File.separator + "osm2xpFacadeSetDescriptor.xml");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)FacadeSet.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)facadeSet, facadeSetFile);
        }
        catch (JAXBException jAXBException) {
            throw new Osm2xpException("Error saving facade set descriptor to file " + facadeSetFile.getPath());
        }
    }

    public static FacadeSet getFacadeSet(String facadeSetFolder) throws Osm2xpException {
        File facadeSetFile = new File(String.valueOf(facadeSetFolder) + File.separator + "osm2xpFacadeSetDescriptor.xml");
        if (facadeSetFile.exists()) {
            return FacadeSetHelper.loadFacadeSet(facadeSetFile.getPath());
        }
        FacadeSet facadeSet = new FacadeSet();
        String[] stringArray = FilesUtils.listFacadesFiles(facadeSetFolder);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String facadeFile = stringArray[n2];
            Facade facade = new Facade();
            facade.setFile(facadeFile);
            facadeSet.getFacades().add(facade);
            ++n2;
        }
        return facadeSet;
    }

    public static FacadeSet loadFacadeSet(String filePath) throws Osm2xpException {
        FacadeSet result = new FacadeSet();
        File facadeSetFile = new File(filePath);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)FacadeSet.class.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            result = (FacadeSet)u.unmarshal(facadeSetFile);
        }
        catch (JAXBException e) {
            throw new Osm2xpException("Error loading facadeSet " + filePath + "\n" + e.getCause().getMessage());
        }
        return result;
    }
}

