/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.BuildingsExclusionsList;
import com.osm2xp.model.options.FlyLegacyOptions;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.model.options.WatchedTagsList;
import com.osm2xp.utils.helpers.OptionsHelper;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;

public class FlyLegacyOptionsHelper
extends OptionsHelper {
    private static FlyLegacyOptions options;
    private static final String FLY_LEGACY_OPTIONS_FILE_PATH;

    static {
        FLY_LEGACY_OPTIONS_FILE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation() + File.separator + "flyLegacyOptions.xml";
        if (new File(FLY_LEGACY_OPTIONS_FILE_PATH).exists()) {
            try {
                options = (FlyLegacyOptions)XmlHelper.loadFileFromXml(new File(FLY_LEGACY_OPTIONS_FILE_PATH), FlyLegacyOptions.class);
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error initializing Fly Legacy options helper", e);
            }
        } else {
            options = FlyLegacyOptionsHelper.createNewFlyLegacyOptionsBean();
        }
    }

    private static FlyLegacyOptions createNewFlyLegacyOptionsBean() {
        FlyLegacyOptions result = new FlyLegacyOptions(FlyLegacyOptionsHelper.createNewWatchedTagsList());
        return result;
    }

    public static FlyLegacyOptions getOptions() {
        return options;
    }

    private static WatchedTagsList createNewWatchedTagsList() {
        ArrayList<OsmTag> watchedTags = new ArrayList<OsmTag>();
        watchedTags.add(new OsmTag("amenity", "college"));
        watchedTags.add(new OsmTag("amenity", "school"));
        watchedTags.add(new OsmTag("amenity", "university"));
        watchedTags.add(new OsmTag("amenity", "clinic"));
        watchedTags.add(new OsmTag("amenity", "hospital"));
        watchedTags.add(new OsmTag("amenity", "fire_station"));
        watchedTags.add(new OsmTag("amenity", "place_of_worship"));
        watchedTags.add(new OsmTag("amenity", "police"));
        watchedTags.add(new OsmTag("amenity", "prison"));
        watchedTags.add(new OsmTag("amenity", "townhall"));
        watchedTags.add(new OsmTag("building", "church"));
        watchedTags.add(new OsmTag("building", "hospital"));
        watchedTags.add(new OsmTag("building", "school"));
        watchedTags.add(new OsmTag("building", "university"));
        watchedTags.add(new OsmTag("landuse", "forest"));
        WatchedTagsList result = new WatchedTagsList(watchedTags);
        return result;
    }

    public static void saveOptions() throws Osm2xpException {
        XmlHelper.saveToXml(FlyLegacyOptionsHelper.getOptions(), new File(FLY_LEGACY_OPTIONS_FILE_PATH));
    }

    public static void importWatchedTags(File file) {
        try {
            Object result = XmlHelper.loadFileFromXml(file, BuildingsExclusionsList.class);
            FlyLegacyOptionsHelper.getOptions().setWatchedTagsList((WatchedTagsList)result);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error importing watched tags list file", e);
        }
    }
}

